/**
 */
package jackHack.util.string;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

/**
 * Utilities for path<br>
 * <br>
 * @author JackHack
 */
public class UtilitiesString
{
	/** Real class name. Without package, with ".class" */
	private static final String CLASS_NAME = UtilitiesString.obtainClassName(UtilitiesString.class);
	/**
	 * Obtain a real class name<br>
	 * Without package, with ".class"
	 * @param clas
	 *        Class to get the name
	 * @return Real Class name
	 */
	private static String obtainClassName(Class clas)
	{
		// Declaration
		String className;
		int index;
		//
		// Initialization
		className = clas.getName();
		//
		index = className.lastIndexOf('.');
		className = className.substring(index + 1) + ".class";
		//
		return className;
	}
	/**
	 * Convert relative path from the jar to local disk absolute path
	 * @param relativePath
	 *        Path to convert
	 * @return Converted path
	 */
	public static String convertRelativePathToAbsolutePath(String relativePath)
	{
		// Declaration
		URL url;
		String directoryPath;
		int indexStart;
		int indexEnd;
		String absolutePath;
		//
		// Initialization
		absolutePath = null;
		// Obtain this class path
		url = UtilitiesString.class.getResource(UtilitiesString.CLASS_NAME);
		try
		{
			// Convert url path to file path
			directoryPath = URLDecoder.decode(url.toString(), "UTF-8");
			// Compute directory path start index
			indexStart = directoryPath.indexOf("file:/") + "file:/".length();
			// Compute directory path end index
			indexEnd = directoryPath.indexOf(".jar!");
			indexEnd = directoryPath.lastIndexOf('/', indexEnd);
			// Compute absolute path
			absolutePath = directoryPath.substring(indexStart, indexEnd + 1) + relativePath;
			// Change url separator to operating system file separator
			absolutePath = absolutePath.replace('/', File.separatorChar);
		}
		catch(UnsupportedEncodingException e)
		{
			e.printStackTrace();
		}
		//
		// To help Garbage Collector to do it's work
		url = null;
		directoryPath = null;
		//
		return absolutePath;
	}
}