/**
 */
package jackHack.util.io;

import jackHack.util.string.UtilitiesString;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

/**
 * Utilities for Input/Output<br>
 * <br>
 * @author JackHack
 */
public class UtilitiesIO
{
	/**
	 * Create a directory
	 * @param directory
	 *        Directory to create
	 * @return <code>true</code> if the directory is create
	 */
	public static boolean createDirectory(File directory)
	{
		// We c'ant create null directory
		if(directory == null)
		{
			return false;
		}
		//
		// If the directory already exists, then it is create
		if(directory.exists() == true)
		{
			return true;
		}
		//
		// If we can create it's parent directory, then try create the directory
		if(UtilitiesIO.createDirectory(directory.getParentFile()) == true)
		{
			return directory.mkdir();
		}
		//
		return false;
	}
	/**
	 * Create a file
	 * @param file
	 *        File to create
	 * @return <code>true</code> if the file is create
	 */
	public static boolean createFile(File file)
	{
		// We can't create null file
		if(file == null)
		{
			return false;
		}
		//
		// If file already exists, then it is create
		if(file.exists() == true)
		{
			return true;
		}
		//
		// If we can create it's parent directory, then try create the file
		if(UtilitiesIO.createDirectory(file.getParentFile()) == true)
		{
			try
			{
				return file.createNewFile();
			}
			catch(IOException e)
			{
				return false;
			}
		}
		//
		return false;
	}
	/**
	 * Copy a stream to other one
	 * @param inputStream
	 *        Stream to copy
	 * @param outputStream
	 *        Stream where copy
	 * @throws IOException
	 *         On reading/writing problem
	 */
	public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException
	{
		// Declaration
		byte[] temporary;
		int read;
		//
		// Initialization
		temporary = new byte[4096];
		//
		// While there are something read, write it
		read = inputStream.read(temporary);
		while(read >= 0)
		{
			outputStream.write(temporary, 0, read);
			//
			read = inputStream.read(temporary);
		}
		//
		// Flush the copy, to be sure the copy is complete
		outputStream.flush();
		//
		// To help Garbage Collector to do it's work
		temporary = null;
	}
	/**
	 * Copy an URL to a file
	 * @param source
	 *        URL source
	 * @param destination
	 *        File destination
	 * @throws IOException
	 *         On reading/writing problem
	 */
	public static void copy(URL source, File destination) throws IOException
	{
		// Declaration
		InputStream inputStream;
		OutputStream outputStream;
		//
		// Initialization
		inputStream = source.openStream();
		outputStream = new FileOutputStream(destination);
		//
		// Do the copy
		UtilitiesIO.copy(inputStream, outputStream);
		//
		// Close streams
		outputStream.close();
		inputStream.close();
		//
		// To help Garbage Collector to do it's work
		inputStream = null;
		outputStream = null;
	}
	/**
	 * Obtain a file external from the jar
	 * @param relativePath
	 *        Relative path to the jar
	 * @return The file
	 */
	public static File computeExternalJarFile(String relativePath)
	{
		// Declaration
		String absolutePath;
		File file;
		//
		// Initialization
		//
		// Compute absolute path
		absolutePath = UtilitiesString.convertRelativePathToAbsolutePath(relativePath);
		// Create the file
		file = new File(absolutePath);
		//
		// To help Garbage Collector to do it's work
		absolutePath = null;
		//
		return file;
	}
}