package jackHack.launcher;

import jackHack.util.io.UtilitiesIO;
import jackHack.util.string.UtilitiesString;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

/**
 * Launch the jar <br>
 * <br>
 * @author Jack Hack
 */
public class Launcher
{
	/**
	 * Launch the jar
	 * @param args
	 *        Unused
	 */
	public static void main(String[] args)
	{
		// Declaration
		ArrayList<String> jarList;
		ArrayList<String> commandArguments;
		String nativePath;
		String mainClass;
		String classPath;
		//
		// Initialization
		jarList = new ArrayList<String>();
		commandArguments = new ArrayList<String>();
		//
		Launcher.fillJarList(jarList);
		classPath = Launcher.computeClassPath(jarList);
		//
		nativePath = Launcher.obtainNativePath();
		//
		mainClass = Launcher.obtainMainClass();
		//
		commandArguments.add("java");
		if(nativePath != null)
		{
			commandArguments.add("-Djava.library.path=" + nativePath);
		}
		commandArguments.add("-cp");
		commandArguments.add(classPath);
		commandArguments.add(mainClass);
		//
		Launcher.launchTheJar(commandArguments);
		//
		// To help Garbage Collector to do it's work
		jarList.clear();
		jarList = null;
		commandArguments.clear();
		commandArguments = null;
		nativePath = null;
		mainClass = null;
		classPath = null;
		//
		System.exit(0);
	}
	/**
	 * Fill the jar list
	 * @param jarList
	 *        Jar list to fill
	 */
	private static void fillJarList(ArrayList<String> jarList)
	{
		// Declaration
		File file;
		FileInputStream fileInputStream;
		InputStreamReader inputStreamReader;
		BufferedReader bufferedReader;
		String line;
		//
		// Initialization
		file = UtilitiesIO.computeExternalJarFile("jarList.txt");
		try
		{
			fileInputStream = new FileInputStream(file);
			inputStreamReader = new InputStreamReader(fileInputStream);
			bufferedReader = new BufferedReader(inputStreamReader);
			//
			line = bufferedReader.readLine();
			while(line != null)
			{
				jarList.add(line);
				//
				line = bufferedReader.readLine();
			}
			//
			bufferedReader.close();
		}
		catch(FileNotFoundException e)
		{
			e.printStackTrace();
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
		//
		// To help Garbage Collector to do it's work
		file = null;
		fileInputStream = null;
		inputStreamReader = null;
		bufferedReader = null;
		line = null;
	}
	/**
	 * Obtain the native path
	 * @return Native path
	 */
	private static String obtainNativePath()
	{
		// Declaration
		File file;
		FileInputStream fileInputStream;
		InputStreamReader inputStreamReader;
		BufferedReader bufferedReader;
		String line;
		String nativePath;
		//
		// Initialization
		nativePath = null;
		file = UtilitiesIO.computeExternalJarFile("nativePath.txt");
		try
		{
			fileInputStream = new FileInputStream(file);
			inputStreamReader = new InputStreamReader(fileInputStream);
			bufferedReader = new BufferedReader(inputStreamReader);
			//
			line = bufferedReader.readLine();
			if(line != null)
			{
				nativePath = line;
			}
			//
			bufferedReader.close();
		}
		catch(FileNotFoundException e)
		{
			e.printStackTrace();
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
		//
		// To help Garbage Collector to do it's work
		file = null;
		fileInputStream = null;
		inputStreamReader = null;
		bufferedReader = null;
		line = null;
		//
		return nativePath;
	}
	/**
	 * Obtain the main class
	 * @return Main class
	 */
	private static String obtainMainClass()
	{
		// Declaration
		File file;
		FileInputStream fileInputStream;
		InputStreamReader inputStreamReader;
		BufferedReader bufferedReader;
		String line;
		String mainClass;
		//
		// Initialization
		mainClass = null;
		file = UtilitiesIO.computeExternalJarFile("mainClass.txt");
		try
		{
			fileInputStream = new FileInputStream(file);
			inputStreamReader = new InputStreamReader(fileInputStream);
			bufferedReader = new BufferedReader(inputStreamReader);
			//
			line = bufferedReader.readLine();
			if(line != null)
			{
				mainClass = line;
			}
			//
			bufferedReader.close();
		}
		catch(FileNotFoundException e)
		{
			e.printStackTrace();
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
		//
		// To help Garbage Collector to do it's work
		file = null;
		fileInputStream = null;
		inputStreamReader = null;
		bufferedReader = null;
		line = null;
		//
		return mainClass;
	}
	/**
	 * Compute the class path
	 * @param jarList
	 *        Jar list
	 * @return Class path
	 */
	private static String computeClassPath(ArrayList<String> jarList)
	{
		// Declaration
		StringBuilder classPath;
		boolean first;
		char jarSeparator;
		String osName;
		//
		// Initialization
		classPath = new StringBuilder();
		first = true;
		//
		osName = System.getProperty("os.name");
		//
		jarSeparator = ':';
		if(osName.indexOf("Windows") >= 0)
		{
			jarSeparator = ';';
		}
		//
		for(String jar : jarList)
		{
			if(first == false)
			{
				classPath.append(jarSeparator);
			}
			// Use absolute path for jar, to be sure to find them
			classPath.append(UtilitiesString.convertRelativePathToAbsolutePath(jar));
			first = false;
		}
		//
		// To help Garbage Collector to do it's work
		osName = null;
		//
		return classPath.toString();
	}
	/**
	 * Launch the jar
	 * @param command
	 *        Command line for the launch
	 */
	private static void launchTheJar(ArrayList<String> command)
	{
		// Declaration
		String[] stringCommand;
		int size;
		Runtime runtime;
		//
		// Initialization
		size = command.size();
		stringCommand = new String[size];
		runtime = Runtime.getRuntime();
		//
		stringCommand = command.toArray(stringCommand);
		try
		{
			runtime.exec(stringCommand);
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
		try
		{
			Thread.sleep(1000);
		}
		catch(InterruptedException e)
		{
			e.printStackTrace();
		}
		//
		// To help Garbage Collector to do it's work
		stringCommand = null;
		runtime = null;
	}
}