/**
 */
package jackHack.applet;

import jackHack.util.io.UtilitiesIO;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

import javax.swing.JApplet;

/**
 * Applet do the copy and launch the launcher.<br>
 * This Applet have for parameters :
 * <ul>
 * <li>needToCopyListPath : List of need to copy before launching path. You must have it</li>
 * <li>directoryWhereToCopy : Directory name where the copy is done. If the parameter not use, the
 * default directory is used</li>
 * <li>otherToCopyListPath : List of other things to copy path. Optional parameter</li>
 * </ul>
 * <br>
 * The list is a text file where witch line is jar Applet relative path for resource and jar to copy
 * <br>
 * <br>
 * @author Jack Hack
 */
public class AppletLauncher
		extends JApplet
		implements Runnable
{
	/** Thread do the copy and launch the launcher */
	private Thread thread;
	/** List of need to copy before launching path */
	private String needToCopyListPath;
	/** Directory name where the copy is done */
	private String directoryWhereToCopy;
	/** List of other things to copy path */
	private String otherToCopyListPath;
	/** To show copy progress */
	private CopyProgressor copyProgressor;
	/**
	 * Constructs the Applet
	 */
	public AppletLauncher()
	{
	}
	/**
	 * Destroy the Applet
	 * @see java.applet.Applet#destroy()
	 */
	@Override
	public void destroy()
	{
		this.stop();
		//
		// To help Garbage Collector to do it's work
		this.thread = null;
		this.needToCopyListPath = null;
		this.directoryWhereToCopy = null;
		this.otherToCopyListPath = null;
		//
		super.destroy();
	}
	/**
	 * Initialize the Applet
	 * @see java.applet.Applet#init()
	 */
	@Override
	public void init()
	{
		// Create here the way to show copy progress
		this.copyProgressor = new DefaultCopyProgressor();
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add((Component)this.copyProgressor, BorderLayout.CENTER);
	}
	/**
	 * Start the Applet
	 * @see java.applet.Applet#start()
	 */
	@Override
	public void start()
	{
		if(this.thread == null)
		{
			this.thread = new Thread(this);
			this.thread.start();
		}
	}
	/**
	 * Stop the Applet
	 * @see java.applet.Applet#stop()
	 */
	@Override
	public void stop()
	{
	}
	/**
	 * Do the copy and launch the launcher
	 * @see java.lang.Runnable#run()
	 */
	@Override
	public void run()
	{
		// Collect parameters
		this.collectParameters();
		// Copy first resource
		this.copyNeedJarAndResourceNeedForLaunch();
		// Launch the launcher
		this.launchTheLauncher();
		// Copy other data
		this.copyOtherThings();
		//
		// To help Garbage Collector to do it's work
		this.thread = null;
	}
	/**
	 * Collect parameters value
	 */
	private void collectParameters()
	{
		this.needToCopyListPath = this.getParameter("needToCopyListPath");
		this.directoryWhereToCopy = this.getParameter("directoryWhereToCopy");
		this.otherToCopyListPath = this.getParameter("otherToCopyListPath");
		//
		if(this.needToCopyListPath == null)
		{
			System.err.println("/!\\ Warning !!! Need to copy list not found !");
		}
		//
		if(this.directoryWhereToCopy == null)
		{
			System.err.println("No directory where to copy, so we use the default !");
			//
			this.directoryWhereToCopy = "JackHack";
		}
		//
		// Convert directory path to absolute path
		this.directoryWhereToCopy = System.getProperty("user.home") + File.separator
				+ this.directoryWhereToCopy.replace('/', File.separatorChar);
	}
	/**
	 * Copy the minimal jar and resource for the application can launch
	 */
	private void copyNeedJarAndResourceNeedForLaunch()
	{
		if(this.needToCopyListPath == null)
		{
			return;
		}
		//
		this.copyList(this.needToCopyListPath);
	}
	/**
	 * Copy a list
	 * @param listPath
	 *        List path
	 */
	private void copyList(String listPath)
	{
		// Declaration
		URL url;
		InputStreamReader inputStreamReader;
		BufferedReader bufferedReader;
		ArrayList<String> fileList;
		String line;
		int size;
		int index;
		//
		// Initialization
		fileList = new ArrayList<String>();
		try
		{
			url = new URL(this.getCodeBase(), this.needToCopyListPath);
			inputStreamReader = new InputStreamReader(url.openStream());
			bufferedReader = new BufferedReader(inputStreamReader);
			//
			line = bufferedReader.readLine();
			while(line != null)
			{
				line = line.trim();
				//
				if(line.length() > 0)
				{
					fileList.add(line);
				}
				//
				line = bufferedReader.readLine();
			}
			//
			bufferedReader.close();
		}
		catch(MalformedURLException e)
		{
			e.printStackTrace();
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
		//
		size = fileList.size();
		this.copyProgressor.startCopy(size);
		//
		for(index = 0; index < size; index++)
		{
			this.copyFile(fileList.get(index));
			//
			this.copyProgressor.copyProgress(index);
		}
		//
		this.copyProgressor.endCopy();
		//
		// To help Garbage Collector to do it's work
		url = null;
		inputStreamReader = null;
		bufferedReader = null;
		line = null;
	}
	/**
	 * Copy a file
	 * @param filePath
	 *        File path
	 */
	private void copyFile(String filePath)
	{
		// Declaration
		File file;
		URL url;
		//
		// Initialization
		file = this.createFile(filePath);
		if(file == null)
		{
			return;
		}
		//
		try
		{
			url = new URL(this.getCodeBase(), filePath);
			//
			// Do the copy
			UtilitiesIO.copy(url, file);
		}
		catch(MalformedURLException e)
		{
			e.printStackTrace();
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
		//
		// To help Garbage Collector to do it's work
		file = null;
		url = null;
	}
	/**
	 * Create a local file
	 * @param filePath
	 *        File to create
	 * @return Created file
	 */
	private File createFile(String filePath)
	{
		// Declaration
		String fileAbsolutePath;
		File file;
		//
		// Initialization
		fileAbsolutePath = this.directoryWhereToCopy + File.separator + filePath.replace('/', File.separatorChar);
		//
		// Create the file
		file = new File(fileAbsolutePath);
		if(UtilitiesIO.createFile(file) == false)
		{
			file = null;
		}
		//
		// To help Garbage Collector to do it's work
		fileAbsolutePath = null;
		//
		return file;
	}
	/**
	 * Launch the launcher
	 */
	private void launchTheLauncher()
	{
		// Declaration
		String launcherPath;
		String[] command;
		Runtime runtime;
		Process process;
		//
		// Initialization
		command = new String[3];
		launcherPath = this.directoryWhereToCopy + File.separator + "Launcher.jar";
		System.out.println("AppletLauncher.launchTheLauncher(" + launcherPath + ")");
		//
		command[0] = "java";
		command[1] = "-jar";
		command[2] = '"' + launcherPath + '"';
		//
		runtime = Runtime.getRuntime();
		//
		try
		{
			process = runtime.exec(command);
			System.out.println("AppletLauncher.launchTheLauncher(EXEC)");
			//
			process.waitFor();
			System.out.println("AppletLauncher.launchTheLauncher(WAIT)");
			Thread.sleep(100);
			//
			process.destroy();
			System.out.println("AppletLauncher.launchTheLauncher(DESTROY)");
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
		catch(InterruptedException e)
		{
			e.printStackTrace();
		}
		//
		// To help Garbage Collector to do it's work
		launcherPath = null;
		command = null;
		runtime = null;
		process = null;
	}
	/**
	 * Copy resources that not need now, but may be later.<br>
	 * Could be use for example for streaming, load data use in other Applet use, ...
	 */
	private void copyOtherThings()
	{
		if(this.otherToCopyListPath == null)
		{
			return;
		}
		//
		this.copyList(this.otherToCopyListPath);
	}
}