/**
 */
package jackHack.applet;

import java.awt.BorderLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Default copy progress component <br>
 * <br>
 * @author JackHack
 */
public class DefaultCopyProgressor
		extends JPanel
		implements CopyProgressor
{
	/** Progress label */
	private JLabel labelProgress;
	/** Total size to copy */
	private long size;
	/** Actual copy progress */
	private long progress;
	/**
	 * Constructs the progress component
	 */
	public DefaultCopyProgressor()
	{
		this.size = 0;
		this.progress = 0;
		//
		this.createComponents();
		this.layoutComponents();
		this.addListeners();
	}
	/**
	 * Create listeners
	 */
	private void createComponents()
	{
		this.labelProgress = new JLabel("Loading in progress", JLabel.CENTER);
	}
	/**
	 * Layout components
	 */
	private void layoutComponents()
	{
		this.setLayout(new BorderLayout());
		//
		this.add(this.labelProgress, BorderLayout.CENTER);
	}
	/**
	 * Add listeners
	 */
	private void addListeners()
	{
	}
	/**
	 * Update progress status
	 */
	private void updateProgress()
	{
		this.labelProgress.setText(this.progress + "/" + this.size);
		//
		this.repaint();
	}
	/**
	 * Call when copy progress
	 * @param copyProgress
	 *        The actual copy size
	 * @see jackHack.applet.CopyProgressor#copyProgress(long)
	 */
	@Override
	public void copyProgress(long copyProgress)
	{
		this.progress = copyProgress;
		//
		this.updateProgress();
	}
	/**
	 * Call when copy end
	 * @see jackHack.applet.CopyProgressor#endCopy()
	 */
	@Override
	public void endCopy()
	{
		this.progress = this.size;
		//
		this.updateProgress();
	}
	/**
	 * Call when copy start
	 * @param size
	 *        Total size of copy
	 * @see jackHack.applet.CopyProgressor#startCopy(long)
	 */
	@Override
	public void startCopy(long size)
	{
		this.size = size;
		//
		this.updateProgress();
	}
	/**
	 * Destroy the component
	 */
	public void destroyMySelf()
	{
		this.labelProgress = null;
	}
}