/*
 * Decompiled with CFR 0.152.
 */
package jackHack.util.io;

import jackHack.util.string.UtilitiesString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class UtilitiesIO {
    public static boolean createDirectory(File directory) {
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return true;
        }
        if (UtilitiesIO.createDirectory(directory.getParentFile())) {
            return directory.mkdir();
        }
        return false;
    }

    public static boolean createFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        if (UtilitiesIO.createDirectory(file.getParentFile())) {
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] temporary = new byte[4096];
        int read = inputStream.read(temporary);
        while (read >= 0) {
            outputStream.write(temporary, 0, read);
            read = inputStream.read(temporary);
        }
        outputStream.flush();
        temporary = null;
    }

    public static void copy(URL source, File destination) throws IOException {
        InputStream inputStream = source.openStream();
        FileOutputStream outputStream = new FileOutputStream(destination);
        UtilitiesIO.copy(inputStream, outputStream);
        ((OutputStream)outputStream).close();
        inputStream.close();
        inputStream = null;
        outputStream = null;
    }

    public static File computeExternalJarFile(String relativePath) {
        String absolutePath = UtilitiesString.convertRelativePathToAbsolutePath(relativePath);
        File file = new File(absolutePath);
        absolutePath = null;
        return file;
    }
}

