/*
 * Decompiled with CFR 0.152.
 */
package jackHack.launcher;

import jackHack.util.io.UtilitiesIO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class Launcher {
    public static void main(String[] args) {
        ArrayList<String> jarList = new ArrayList<String>();
        ArrayList<String> commandArguments = new ArrayList<String>();
        Launcher.fillJarList(jarList);
        String classPath = Launcher.computeClassPath(jarList);
        String nativePath = Launcher.obtainNativePath();
        String mainClass = Launcher.obtainMainClass();
        commandArguments.add("java");
        if (nativePath != null) {
            commandArguments.add("-Djava.library.path=" + nativePath);
        }
        commandArguments.add("-cp");
        commandArguments.add(classPath);
        commandArguments.add(mainClass);
        Launcher.launchTheJar(commandArguments);
        jarList.clear();
        jarList = null;
        commandArguments.clear();
        commandArguments = null;
        nativePath = null;
        mainClass = null;
        classPath = null;
    }

    private static void fillJarList(ArrayList<String> jarList) {
        String line;
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        File file = UtilitiesIO.computeExternalJarFile("jarList.txt");
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            line = bufferedReader.readLine();
            while (line != null) {
                jarList.add(line);
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file = null;
        fileInputStream = null;
        inputStreamReader = null;
        bufferedReader = null;
        line = null;
    }

    private static String obtainNativePath() {
        String line;
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        String nativePath = null;
        File file = UtilitiesIO.computeExternalJarFile("nativePath.txt");
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            line = bufferedReader.readLine();
            if (line != null) {
                nativePath = line;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file = null;
        fileInputStream = null;
        inputStreamReader = null;
        bufferedReader = null;
        line = null;
        return nativePath;
    }

    private static String obtainMainClass() {
        String line;
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        String mainClass = null;
        File file = UtilitiesIO.computeExternalJarFile("mainClass.txt");
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            line = bufferedReader.readLine();
            if (line != null) {
                mainClass = line;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file = null;
        fileInputStream = null;
        inputStreamReader = null;
        bufferedReader = null;
        line = null;
        return mainClass;
    }

    private static String computeClassPath(ArrayList<String> jarList) {
        StringBuilder classPath = new StringBuilder();
        boolean first = true;
        String osName = System.getProperty("os.name");
        char jarSeparator = ':';
        if (osName.indexOf("Windows") >= 0) {
            jarSeparator = ';';
        }
        for (String jar : jarList) {
            if (!first) {
                classPath.append(jarSeparator);
            }
            classPath.append(jar);
            first = false;
        }
        osName = null;
        return classPath.toString();
    }

    private static void launchTheJar(ArrayList<String> command) {
        int size = command.size();
        String[] stringCommand = new String[size];
        Runtime runtime = Runtime.getRuntime();
        stringCommand = command.toArray(stringCommand);
        try {
            runtime.exec(stringCommand);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        stringCommand = null;
        runtime = null;
    }
}

