/*
//============================================================================
// Name        : FRAME_BUTTON.cpp
// Author      : CAROLITO
// Version     :
// Copyright   : Dvloppeur - CAROLITO
// Description : FRAME WITH BUTTONS AND TEXT-FIELD
//============================================================================
*/

/** 
 * Blibliothque Principale
 *  
 * Dans FRAME_BUTTON.h :
 * - #pragma once 
 * - #include "resource.h"
 * 
 * Dans resource.h :
 * - #define IDI_ICON1 1000
 * - #define IDI_ICON2 1001
 * 
 */#include "FRAME_BUTTON.h"
 
 /**
  * Dans FRAME_BUTTON.rc :
  * - IDI_ICON1 ICON FRAME_BUTTON.ico
  * - IDI_ICON2 ICON FRAME_BUTTON_SM.ico
  * */

/** Bibliothques Complmentaires */
#include <windows.h>
#include <iostream>
#include <sstream>
#include <string>
using namespace std;

/** Bibliothque de fonctions fabriques et utiles au programme */
#include "fonctions.h"

/** ID(identificateur) */
#define ID_BUTTON1 1 // de 0  65535
#define ID_BUTTON2 2 // de 0  65535
#define ID_EDITBOX 3

/** Private Handle(s) */
HWND winhWnd;// fentre
HWND cmdhWnd1;// bouton END
HWND cmdhWnd2;// bouton ACTION
HWND edithWnd;// champ texte

/** Procdure qui va recevoir les messages */
LRESULT CALLBACK WinProc(HWND, UINT, WPARAM, LPARAM);

/** Entr du programme */
int WINAPI WinMain(
		HINSTANCE FirstInstance, 
		HINSTANCE PrevInstance, 
		LPSTR CmdLine, 
		int CmdShow){

	MSG msg;
	WNDCLASSEX wc;

	// Cration de la classe
	wc.hInstance = FirstInstance;  // Instance
	wc.lpszClassName = "NitRic_Button";  // Nom de la classe
	wc.lpfnWndProc = WinProc;  // Adresse de la procdure
	wc.style = CS_DBLCLKS;  // Style
	wc.cbSize = sizeof(WNDCLASSEX);  // Taille
	
	wc.hIcon = LoadIcon(wc.hInstance, MAKEINTRESOURCE(IDI_ICON1));  // Grande icone
	wc.hIconSm = LoadIcon(wc.hInstance, MAKEINTRESOURCE(IDI_ICON2));  // Petite icone
	/*
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);  // Grande icone
	wc.hIconSm = LoadIcon(NULL, IDI_APPLICATION);  // Petite icone
	*/
	
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);  // Curseur
	wc.lpszMenuName = NULL;  // Menu
	wc.cbClsExtra = 0;  // ...
	wc.cbWndExtra = 0;  // ...
	wc.hbrBackground  = (HBRUSH)(LTGRAY_BRUSH);
	//wc.hbrBackground  = (HBRUSH)(COLOR_WINDOW + 1);
	//wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);  // Couleur de fond
	
	// Enregistre la classe
	if (!RegisterClassEx(&wc)){
		// chec
		MessageBox(NULL, "Erreur lors de l'enregistrement de la classe.", "Erreur", MB_OK);
		return 0;
	}

	// Dimensions de la fentre
	int screen_width = 1280;
	int screen_height = 1024;
	int w = 500;// largeur de la fentre
	int h = 200;// hauteur de la fentre
	int x = (screen_width - w)/2;
	int y = (screen_height - h)/2;
	  	
	// Cration de la fentre
	winhWnd = CreateWindowEx(
			0, 
			"NitRic_Button", 
			"Titre : FRAME BUTTON", 
			WS_OVERLAPPEDWINDOW, 
			x, 
			y, 
			w, 
			h, 
			HWND_DESKTOP, 
			NULL, 
			FirstInstance, 
			NULL);

	if (winhWnd == NULL){
		// chec
		MessageBox(NULL, "Erreur lors de la cration de la fentre.", "Erreur", MB_OK);
		return 0;
	}

	/** BUTTON 1 */
	// Cration du bouton
	cmdhWnd1 = CreateWindowEx(
			0, 
			"BUTTON", 
			"", 
			WS_VISIBLE|WS_CHILD|BS_PUSHBUTTON|BS_NOTIFY|BS_TEXT, 
			30, 
			30, 
			200, 
			50, 
			winhWnd, 
			(HMENU)ID_BUTTON1, 
			FirstInstance, 
			NULL);
	  	
	// chec
	if (cmdhWnd1 == NULL){
		MessageBox(winhWnd, "Erreur lors de la cration du Bouton 1.", "Erreur", MB_OK);
		return 0;
	}

	// Envoie tu texte dans le bouton(Caption)
	SetWindowText(cmdhWnd1, "END");

	// Met  jour le bouton
	UpdateWindow(cmdhWnd1);
	
	// Donne le focus au bouton
	SetFocus(cmdhWnd1);

	/** BUTTON 2 */
	// Cration du bouton
	cmdhWnd2 = CreateWindowEx(
			0, 
			"BUTTON", 
			"", 
			WS_VISIBLE|WS_CHILD|BS_PUSHBUTTON|BS_NOTIFY|BS_TEXT, 
			260, 
			30, 
			200, 
			50, 
			winhWnd, 
			(HMENU)ID_BUTTON2, 
			FirstInstance, 
			NULL);

	// chec
	if (cmdhWnd2 == NULL){
		MessageBox(winhWnd, "Erreur lors de la cration du Bouton 2.", "Erreur", MB_OK);
		return 0;
	}

	// Envoie tu texte dans le bouton(Caption)
	SetWindowText(cmdhWnd2, "ACTION");

	// Met  jour le bouton
	UpdateWindow(cmdhWnd2);
	
	// Donne le focus au bouton
	SetFocus(cmdhWnd2);

	/** TEXT BOX */
	edithWnd = CreateWindowEx(
			WS_EX_OVERLAPPEDWINDOW, 
			"EDIT", "", 
			WS_VISIBLE|WS_CHILD|ES_AUTOHSCROLL|ES_NOHIDESEL, 
			30, 
			110, 
			200, 
			20, 
			winhWnd, 
			(HMENU)ID_EDITBOX, 
			FirstInstance, 
			NULL);

	if (edithWnd == NULL){
		MessageBox(winhWnd, "Erreur lors de la cration du EditBox.", "Erreur", MB_OK);
		return 0;
	}

	ShowWindow(winhWnd, SW_SHOW);
	UpdateWindow(winhWnd);

	// Envoie du texte dans le EditBox
	SetWindowText(edithWnd, "");

	UpdateWindow(edithWnd);
	SetFocus(edithWnd);
	
	/** WINDOW */
	// Affiche la fentre
	ShowWindow(winhWnd, SW_SHOW);
	
	// Met  jour la fentre
	UpdateWindow(winhWnd);

	// Boucle qui permet au programme de rester ouvert :)
	while (GetMessage(&msg, NULL, 0, 0)){
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
			
	// Fin du programme
	return msg.wParam;
}

/** Rception des messages */
LRESULT CALLBACK WinProc(
		HWND hwnd, 
		UINT msg, 
		WPARAM wParam, 
		LPARAM lParam){

	switch (msg){
    	// Fermeture du programme
        case WM_DESTROY:
        // Ferme le programme
        PostQuitMessage(0);
        break;

        // Fermeture de la fentre via le menu systme ou la croix(X) noir
        case WM_CLOSE:
        	// Dtruit la fentre
        	DestroyWindow(hwnd);
        	break;

        // Rception des commandes
        case WM_COMMAND:
        	/** BUTTON 1 */
        	// Vrifie que c'est bien le bouton 1 & Vrifie si on  cliquer sur le bouton
        	if ((LOWORD(wParam) == ID_BUTTON1) && (HIWORD(wParam) == BN_CLICKED)){
        		cout << "END" << endl;
        		{DestroyWindow(hwnd);};
        	}
                 
        	/** BUTTON 2 */
        	// Vrifie que c'est bien le bouton 2 & Vrifie si on  cliquer sur le bouton
        	if ((LOWORD(wParam) == ID_BUTTON2) && (HIWORD(wParam) == BN_CLICKED)){
        		// Affiche un MessageBox
        		MessageBox(winhWnd, "Vous avez cliqu sur le bouton 'ACTION'\n\nEn cliquant sur 'OK' vous allez :\n1) - Afficher 'ACTION' dans la console 'DOS'\n2) - Calculer la factorielle 34 et afficher le rsultat dans le champ texte\n3) - Lancer NotePad grce  la fonction 'ShellExecute()'", "Titre : Message Box", MB_OK|MB_ICONINFORMATION);        		
        		
        		// Console DOS
        		cout << "ACTION" << endl;
        		
        		// TextBox => factorielle 34
        		SetWindowText(edithWnd,string2char("34 ! = " + float2string(factorielle(34))));
        		
        		// Lancement de NotePad
        		shell();
        	}
        	break;

            default:
            	return DefWindowProc(hwnd, msg, wParam, lParam);
            	break;
	}
	return 0;
}


