using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.SqlServer.Management.Common;
using Microsoft.SqlServer.Replication;
using Microsoft.SqlServer.Server;


namespace AgentFusionPull
{
    public class RMO
    {
        /// <summary>
        /// Launch a client merge replication (as a sql agent done)
        /// </summary>
        /// <param name="subscriberName">Subscriber instance name</param>
        /// <param name="publisherName">Publisher instance name</param>
        /// <param name="publicationName">Publication name</param>
        /// <param name="publicationDbName">Publication DB Name</param>
        /// <param name="subscriptionDbName">Subscription DB Name</param>
        /// <param name="createSubscription">Indicate if it is necessary to create subscription</param>
        public static void MergePushReplic(string subscriberName, string publisherName, string publicationName, string publicationDbName, string subscriptionDbName, bool createSubscription)
        {



            // Create a connection to the Publisher.
            ServerConnection connPub = new ServerConnection(publisherName);
            ServerConnection connSub = new ServerConnection(subscriberName);
            MergePublication publication;
            MergePullSubscription subscription;



            try
            {

                connPub.Connect();
                connSub.Connect();


                publication = new MergePublication(publicationName, publicationDbName, connPub);

                if (publication.LoadProperties())
                {
                    if ((publication.Attributes & PublicationAttributes.AllowPull) == 0)
                    {
                        publication.Attributes |= PublicationAttributes.AllowPull;
                    }


                    subscription = new MergePullSubscription(subscriptionDbName, publisherName, publicationDbName, publicationName, connSub);
                    subscription.SynchronizationAgentProcessSecurity.Login = @"";
                    subscription.SynchronizationAgentProcessSecurity.Password = "";
                    subscription.CreateSyncAgentByDefault = true;


                    if (createSubscription)
                        subscription.Create();

                    Boolean registered = false;

                    // Verify that the subscription is not already registered.
                    foreach (MergeSubscription existing
                        in publication.EnumSubscriptions())
                    {
                        if (existing.SubscriberName == subscriberName
                            && existing.SubscriptionDBName == subscriptionDbName
                            && existing.SubscriptionType == SubscriptionOption.Pull)
                        {
                            registered = true;
                        }
                    }
                    /*
                    if (!registered)
                    {
                        // Register the local subscription with the Publisher.
                        publication.MakePullSubscriptionWellKnown(
                            subscriberName, subscriptionDbName,
                            SubscriptionSyncType.None,
                            MergeSubscriberType.Local, 0);
                    }
                    */
                    // Check that we have enough metadata to start the agent.
                    if (subscription.SubscriberSecurity != null)
                    {
                        subscription.SynchronizationAgent.PublisherSecurityMode = SecurityMode.Integrated;
                        subscription.SynchronizationAgent.DistributorSecurityMode = SecurityMode.Integrated;
                        subscription.SynchronizationAgent.OutputVerboseLevel = 1;
                        subscription.SynchronizationAgent.Output = "c:\\replic.log";
                        // Synchronously start the Merge Agent for the subscription.
                        subscription.SynchronizationAgent.Synchronize();

                    }
                    else
                    {
                        throw new ApplicationException("There is insufficent metadata to " +
                            "synchronize the subscription. Recreate the subscription with " +
                            "the agent job or supply the required agent properties at run time.");
                    }
                }
                else
                {
                    // Do something here if the push subscription does not exist.
                    throw new ApplicationException(String.Format(
                        "The subscription to '{0}' does not exist on {1}",
                        publicationName, subscriberName));
                }
            }
            catch (Exception ex)
            {
                // Implement appropriate error handling here.
                throw new ApplicationException("The subscription could not be synchronized.", ex);

            }
            finally
            {
                connPub.Disconnect();
                connSub.Disconnect();
            }


        }

    }
}
