/*
 * CoalescedThreadsMonitor.java
 *
 * Created on 20. juillet 2007, 12:27
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package net.library.jiga.sf3.system;

import net.library.jiga.installer.UIMessage;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JOptionPane;

/**
 *
 * @author Bruno
 */
public class CoalescedThreadsMonitor<T> extends ThreadGroup {
    /***/
    private T monitor;
    /***/
    private ConcurrentHashMap<Long, Thread> _currentThreads = new ConcurrentHashMap<Long, Thread>();
    /***/
    private WeakHashMap<Long, Long> _currentThreadsTimes = new WeakHashMap<Long, Long>();
    /***/
    private boolean MRUEnabled = true;
    /***/
    private Map<Long, Long> currentThreadsTimes = Collections.synchronizedMap(_currentThreadsTimes);
    /***/
    private Map<Long, Thread> currentThreads = Collections.synchronizedMap(_currentThreads);;
    
    /***/
    public CoalescedThreadsMonitor(String name) {
        super(name);
        setMaxPriority(Thread.MAX_PRIORITY);
        monitor = (T)new Monitor();
    }
    
    /***/
    public CoalescedThreadsMonitor(ThreadGroup tg, String name) {
        super(tg, name);
        setMaxPriority(Thread.MAX_PRIORITY);
        monitor = (T)new Monitor();
    }
    
    /**
     * Creates a new instance of CoalescedThreadsMonitor
     */
    public CoalescedThreadsMonitor(String name, T monitor) {
        super(name);
        setMaxPriority(Thread.MAX_PRIORITY);
        this.monitor = monitor;
    }
    
    /***/
    public CoalescedThreadsMonitor(ThreadGroup tg, String name, T monitor) {
        super(tg, name);
        setMaxPriority(Thread.MAX_PRIORITY);
        this.monitor = monitor;
    }
    
    /***/
    public void setMRUEnabled(boolean b) {
        MRUEnabled = b;
    }
    
    /***/
    public void coalesce() {
        System.err.println(getName() + " has registered " + currentThreads.size() + " Threads and has " + activeCount() + "+ active Threads.");
        int pty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(Math.min(getMaxPriority() + 1, Thread.MAX_PRIORITY));
        int maxCount = currentThreads.size();
        SortedMap<Long, Long> sorted = (!MRUEnabled)?new TreeMap<Long, Long>(Collections.reverseOrder()):new TreeMap<Long, Long>();
        synchronized(sorted) {
            synchronized(currentThreadsTimes) {
                for(Iterator<Long> i = currentThreadsTimes.keySet().iterator(); i.hasNext() && maxCount > 0; maxCount--) {
                    Long id = i.next();
                    sorted.put(currentThreadsTimes.get(id), id);
                }
            }
            for(Iterator<Long> i = sorted.values().iterator(); i.hasNext();) {
                long id = i.next();
                Thread t1 = currentThreads.get(id);
                if(t1 instanceof Thread) {
                    if(
                            t1.isAlive()
                            && t1.getId() != Thread.currentThread().getId()
                            ) {
                        t1.interrupt();
                    }
                    if(t1.isInterrupted() || !t1.isAlive())
                        currentThreads.remove(id);
                } else
                    currentThreads.remove(id);
            }
            System.err.println(getName() + " has " + currentThreads.size() + " registered Threads left and has " + activeCount() + "+ active Threads left pty level = " + getMaxPriority() + ".");
        }
        Thread.currentThread().setPriority(pty);
    }
    
    /***/
    public long addThread(Thread t) {
        currentThreads.put(t.getId(), t);
        currentThreadsTimes.put(t.getId(), System.currentTimeMillis());
        //System.err.println(getName() + " has registered a new Thread " + t.getName() + " .");
        return t.getId();
    }
    
    /***/
    public void removeThread(Thread t){
        currentThreads.remove(t.getId());
        //System.err.println(getName() + " has unregistered a Thread " + t.getName() + " .");
    }
    
    /***/
    public T getMonitor(boolean enqueue) {
        if(enqueue)
            addThread(Thread.currentThread());
        System.err.println(getName() + " w/ " + Thread.currentThread().getName() + " is getting on monitor.");
        return monitor;
    }
    
    /***/
    private static UIMessage currentMessage = null;
    
    /***/
    private static String previousMessage = "";
    
    /***/
    public void uncaughtException(Thread thread, Throwable throwable) {
        if(currentMessage instanceof UIMessage) {
            if(currentMessage.isShowing()) {
                currentMessage.dispose();
                previousMessage += "\r\n\r\n";
            } else
                previousMessage = "";
        } else
            previousMessage = "";
        String stack = "";
        for(StackTraceElement ste : throwable.getStackTrace())
            stack += "\n" + ste;
        String stack_c = "";
        if(throwable.getCause() instanceof Throwable) {
            for(StackTraceElement ste : throwable.getCause().getStackTrace())
                stack_c += "\n" + ste;
        }
        
        currentMessage = new UIMessage(
                false,
                previousMessage += "an unexpected exception has been caught in thread group named "
                + getName() + " : "
                + throwable.getClass().getName() + " : " + throwable.getMessage() + " \n\r"
                + stack
                + " \n in Thread " + thread.getName()
                + ((throwable.getCause() instanceof Throwable)?(" caused by : " + throwable.getCause().getClass().getName() + "\n\r"
                + stack_c):""),
                null,
                UIMessage.ERROR_TYPE
                );
        throwable.printStackTrace();
    }
    
    /***/
    public void cancelAll(boolean wait) {
        int pty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(Math.min(getMaxPriority() + 1, Thread.MAX_PRIORITY));
        interrupt();
        final long id = Thread.currentThread().getId();
        Thread t = new Thread(new Runnable() { public void run() {
            synchronized(currentThreads) {
                int maxCount = currentThreads.size();
                for(Iterator<Long> i = currentThreads.keySet().iterator(); i.hasNext() && maxCount > 0; maxCount--) {
                    long id = i.next();
                    Thread t1 = currentThreads.get(id);
                    if(t1 instanceof Thread) {
                        if(t1.isAlive() && t1.getId() != id) {
                            t1.interrupt();
                        }
                        if(t1.isInterrupted() || !t1.isAlive())
                            currentThreads.remove(id);
                    }
                }
            }
            currentThreads.clear();
            interrupt();
        }}, "T-clear-" + getName());
        t.setDaemon(true);
        t.start();
        if(wait) {
            try {
                t.join();
            } catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Thread.currentThread().setPriority(pty);
    }
    
    private boolean coalesce = true;
    /***/
    public boolean isCoalesceEnabled() {
        return coalesce;
    }
    
    /***/
    public void setCoalesceEnabled(boolean b) {
        coalesce = b;
    }
    
    /***/
    public void waitOnMonitor() throws InterruptedException {
        waitOnMonitor(0, 0);
    }
    
    /***/
    public void waitOnMonitor(long time) throws InterruptedException {
        waitOnMonitor(time, 0);
    }
    
    /***/
    public void waitOnMonitor(long time, int nano) throws InterruptedException {
        if(coalesce)
            coalesce();
        else
            System.err.println(getName() + " w/ " + Thread.currentThread().getName() + " is waiting uncoalesced.");
        addThread(Thread.currentThread());
        monitor.wait(time, nano);
        removeThread(Thread.currentThread());
    }
    
    /***/
    public void notifyOnMonitor() {
        removeThread(Thread.currentThread());
        monitor.notify();
    }
    
    /***/
    public void notifyAllOnMonitor() {
        removeThread(Thread.currentThread());
        monitor.notifyAll();
    }
    
    /***/
    protected void finalize() throws Throwable {
        cancelAll(false);
        super.finalize();
    }
}
