package com.developpez.adiguba.annotation;

import java.util.Set;

import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

/**
 * Le Processor : la classe qui traitera les annotations UseParameterNames
 * @author adiGuba
 */
@SupportedSourceVersion(SourceVersion.RELEASE_6)
@SupportedAnnotationTypes("com.developpez.adiguba.annotation.UseParameterNames")
public class ParameterNamesProcessor extends AbstractProcessor {
	
	@Override
	public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {

		if (!roundEnv.processingOver()) {
			// On rcupre tout les types marqus par notre annotation :
			for (Element type : roundEnv.getElementsAnnotatedWith(UseParameterNames.class)) {
				// On instancie le visitor qui tudiera toutes les mthodes de la classe
				ParameterNamesVisitor visitor = new ParameterNamesVisitor(type);
				// On rcupre tous les lments qu'il contient (attributs, mthodes, constructeurs,...)
				for (Element element : type.getEnclosedElements()) {
					element.accept(visitor, null);
				}
				visitor.store(super.processingEnv);
			}
		}
		return false;
	}

}
