/*
 * Decompiled with CFR 0.152.
 */
package com.developpez.adiguba.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;

public class ParameterTools {
    public static String[] getParameterNames(Method method) {
        Class<?> type = method.getDeclaringClass();
        URL url = type.getResource(String.valueOf(type.getSimpleName()) + ".methods");
        if (url == null) {
            return null;
        }
        StringBuilder key = new StringBuilder(method.getName());
        key.append("(");
        Class<?>[] params = method.getParameterTypes();
        if (params.length > 0) {
            key.append(params[0].getCanonicalName());
            int i = 1;
            while (i < params.length) {
                key.append(",").append(params[i].getCanonicalName());
                ++i;
            }
        }
        key.append(")");
        Properties p = new Properties();
        try {
            InputStream in = url.openStream();
            try {
                p.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String value = p.getProperty(key.toString());
        if (value != null) {
            return value.split(",");
        }
        return null;
    }
}

