/*
 * Decompiled with CFR 0.152.
 */
package com.developpez.adiguba.annotation;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

class ParameterNamesVisitor
extends SimpleElementVisitor6<Void, Void> {
    final Element root;
    final Properties methods = new Properties();

    public ParameterNamesVisitor(Element root) {
        this.root = root;
    }

    @Override
    public Void visitExecutable(ExecutableElement e, Void p) {
        List<? extends VariableElement> parameters = e.getParameters();
        StringBuilder key = new StringBuilder(e.getSimpleName()).append("(");
        StringBuilder value = new StringBuilder();
        Iterator<? extends VariableElement> iter = parameters.iterator();
        if (iter.hasNext()) {
            VariableElement parameter = iter.next();
            key.append(parameter.asType());
            value.append(parameter.getSimpleName());
            while (iter.hasNext()) {
                parameter = iter.next();
                key.append(",").append(parameter.asType());
                value.append(",").append(parameter.getSimpleName());
            }
        }
        key.append(")");
        this.methods.setProperty(key.toString(), value.toString());
        return null;
    }

    public void store(ProcessingEnvironment processingEnv) {
        Elements elements = processingEnv.getElementUtils();
        Filer filer = processingEnv.getFiler();
        try {
            FileObject file = filer.createResource(StandardLocation.CLASS_OUTPUT, elements.getPackageOf(this.root).getQualifiedName(), this.root.getSimpleName() + ".methods", this.root);
            OutputStream out = file.openOutputStream();
            try {
                this.methods.store(out, "Methods for " + this.root);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), this.root);
        }
    }
}

