#!/usr/bin/php -q
 <?

  define ("TIME_OUT_WD", 200); // Temps d'inactivité en sec. (au delà -> réveiller le client!)
  define("DEF_PORT", 6545);    // port par défaut

  /* ws_server+.php

     Cette source est une reprise avec un profond remaniement du tutoriel de
     http://sii-rennes.developpez.com/articles/un-chat-en-html5-avec-les-websockets/
     qui n’est absolument pas fonctionnel en l’état actuel (<2015-06-28). C’est un bon départ
     pour “tâter” voir ce que sont les websockets avec un serveur PHP. La source d’information
     la plus sérieuse, mais qui n’est toujours pas “normative” est la fastidieuse mais abordable
     http://tools.ietf.org/html/rfc6455 que je vous invite à parcourir (en anglais).
     TODO le document rfc6455 décrit de nombreux cas où la connexion doit être close (paquet
          “non conforme”)

     Il y a beaucoup d'autres infos en tête du fichier source du client ws_client+.php.

     Ce script est "normalement" lancé depuis une console sur le cerveur. Il est possible de le
     lancer depuis un fureteur, mais que si on peut rendre l'exécution "sans fin", ce que votre
     hébergeur interdit sûrement.

     Précision sur cette source:
     - comme ce script est sensé être lancé depuis une console, j’utilise la couleur pour
       “dynamiser” les messages de débogage, (c’est sympa et si vous regardez un peu, ça mange
       pas beaucoup de pain !)

     Pour la mise en forme:
     - j'ai laissé les lignes d'impression de déboguage en commentaire, ça pourrait vous éviter
     de perdre du temps, en cas de remanipulation. */

  error_reporting(E_ALL);

  define ("_cLiR_", "\x1B[0J");
  define ("ConClr", "\x1Bc"); // Effacement de l'écran

  define ("_N", "\x1B[1;30m"); // Noir
  define ("_R", "\x1B[1;31m"); // Rouge
  define ("_V", "\x1B[1;32m"); // Vert
  define ("_J", "\x1B[1;33m"); // Jaune
  define ("_B", "\x1B[1;34m"); // Bleu
  define ("_M", "\x1B[1;35m"); // Magenta
  define ("_C", "\x1B[1;36m"); // Cyan
  define ("_G", "\x1B[1;37m"); // Gris (heu… blanc)
  define ("C_", "\x1B[0;0m");  // fin de coloration

  function say ($l, $m="") { print(_G.$l.": ".C_.$m.C_."\n"); } // Causerie "normale"
  function dbug ($l, $m="") {
    if (@$GLOBALS['debug']) {
      print(_G.$l.": "._R.$m.C_."\n");
      strpos($m, "\x07") && exec("aplay /opt/kde3/share/sounds/k3b_wait_media1.wav", $dummy, $resu);
    }
  }

  class User {
  /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
    public $id;
    public $socket;
    public $handshake;
    public $nick;
    public $watchDog;

    public function __construct ($socket) {
      $this->id=uniqid();     // Ici, le client est unique !
      $this->socket=$socket;  // La socket pour lui
      $this->handshake=false; // Jamais "upgradée" (ou "handchecké")
      $this->nick="";         // N'a pas encore de sobriquet
      $this->watchDog=time(); // Surveillance de la ligne / client
dbug(__LINE__, C_."\x07"."Démarrage à ".date("Y-m-d H:i:s ", time()));
    }
  }

  function SocketCreate ($address, $port){
  /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
    $master=socket_create(AF_INET, SOCK_STREAM, SOL_TCP)     or die("socket_create() failed");
    socket_set_option($master, SOL_SOCKET, SO_REUSEADDR, 1)  or die("socket_option() failed");
    socket_bind($master, $address, $port)                    or die("socket_bind() failed");
    socket_listen($master, 20)                               or die("socket_listen() failed");
    print("Server Started : "._G.date('Y-m-d H:i:s').C_."\n");
    print("Master socket  : "._B.$master.C_."\n");
    print("Listening on   : "._R.$address.C_." port "._B.$port.C_."\n\n");
    return $master;
  }

    function ConnecteClient ($socket) { // Créer un client. "socket" est sa socket
    /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
    global $sockStk, $usrStk;

      $user=new User($socket);           // $this-> :id, socket, handshake
      array_push($usrStk,$user);         // On le place dans la liste des clients
      array_push($sockStk,$socket);      // Et sa socket dans la liste des sockets
//dbug(__LINE__, $socket." CONNECTED!");   // Information de dégugging
//dbug(__LINE__, print_r($usrStk, !0));    // Information de dégugging
    }

  function GetUserBySocket ($socket) {
  /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
  global $usrStk;

//dbug(__LINE__, _J.print_r($socket, !0)); // Information de dégugging
    $n=count($usrStk);                 // Nombre de connexion à cette socket
    for($i=0; $i<$n; $i++)             // Tous les utilisateur en revue
      if($usrStk[$i]->socket==$socket) // Celui-ci:
        return $usrStk[$i];            // Retourné le trouvé
    return null; // NOTE Le cas d'une réponse "null" n'est pas traité
  }

  function DeconnecteClient ($socket) { // Supprimer utilisateur utilisant cette socket
  /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
    global $sockStk, $usrStk;

    $n=count($usrStk);                       // Nombre de connexion à cette socket
    for($i=0; $i<$n; $i++)                   // Les utilisateur en revue
      if ($usrStk[$i]->socket==$socket)
        break;                               // $found <- $i : trouvé
    $i<$n && array_splice($usrStk, $i, 1);   // Trouvé : supprimé de la liste des utilisateurs
    $index=array_search($socket, $sockStk);  // Chercher la socket, maintenant
    socket_close($socket);                   // Fermer la connexion
//dbug(__LINE__, $socket." DISCONNECTED!"); // Debugging
    if($index>=0) array_splice($sockStk, $index, 1); // Supprimer de la liste si dedans
  }

  function Handshaking ($user, $buffer) { // Utilisateur à "valider"
  /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
  // Répond à une requête "Handshake" reçu d'un client : buffer=message reçu
  /** $buffer
  pour Firefox (44.0):
    GET / HTTP/1.1
    Host: 192.168.0.3:6545
    User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:44.0) Gecko/20100101 Firefox/44.0
    Accept: text/html,application/xhtml+xml,application/xml;q=0.9,* /*;q=0.8
    Accept-Language: fr,fr-FR;q=0.7,es;q=0.3
    Accept-Encoding: gzip, deflate
    DNT: 1
    Sec-WebSocket-Version: 13
    Origin: http://www.serru.chic
    Sec-WebSocket-Extensions: permessage-deflate
    Sec-WebSocket-Key: kdPzSxeZD68DSakI8qJr0A==
    Connection: keep-alive, Upgrade
    Pragma: no-cache
    Cache-Control: no-cache
    Upgrade: websocket
  pour Chrome (47.0.2526.106 (64-bit)):
    GET / HTTP/1.1
    Host: 192.168.0.3:6545
    Connection: Upgrade
    Pragma: no-cache
    Cache-Control: no-cache
    Upgrade: websocket
    Origin: http://www.serru.chic
    Sec-WebSocket-Version: 13
    User-Agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.106 Safari/537.36
    Accept-Encoding: gzip, deflate, sdch
    Accept-Language: fr-FR,fr;q=0.8,en-US;q=0.6,en;q=0.4
    Sec-WebSocket-Key: 122X/uAiuxGz1SVndaEnPw==
    Sec-WebSocket-Extensions: permessage-deflate; client_max_window_bits
  */
//dbug(__LINE__, "Requête \"Handshake\": reçu du client :"); // Debugging
//dbug(__LINE__, $buffer);
    // Transformation les lignes en array, ex.:
    //   Sec-WebSocket-Key: 122X/uAiuxGz1SVndaEnPw== -->> [Sec-WebSocket-Key] => 122X/uAiuxGz1SVndaEnPw==
    if(preg_match("/GET (.*) HTTP/"   ,$buffer, $match)) $rsc=$match[1]; // ???
    if(preg_match("/Host: (.*)\r\n/"  ,$buffer, $match)) $hst=$match[1];
    $headers=array();
    $lines=preg_split("/\r\n/", $buffer);
    foreach($lines as $line) {
      $line=chop($line);
      if(preg_match('/\A(\S+): (.*)\z/', $line, $matches))
        $headers[$matches[1]]=$matches[2];
    }
    $secKey=$headers['Sec-WebSocket-Key'];
    $secAccept=base64_encode(sha1($secKey.'258EAFA5-E914-47DA-95CA-C5AB0DC85B11', true));
    $upgrade ="HTTP/1.1 101 Web Socket Protocol Handshake\r\n". // hand shaking header
    "Upgrade: websocket\r\n" .
    "Connection: Upgrade\r\n" .
    "WebSocket-Location: ws://$hst".$rsc."\r\n". // ???
    "Sec-WebSocket-Accept: $secAccept\r\n\r\n";
    socket_write($user->socket, $upgrade, strlen($upgrade));
    $user->handshake=true; // Fait, ouffff!
//dbug(__LINE__, "Réponse :");
//dbug(__LINE__, $upgrade); // Debugging
//dbug(__LINE__, "Requête exécutée."); // Debugging
  }

  function Unmask ($text) { // "Dé-masquer" le "cadre" texte entrant
  /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
/*  1er octet: Drapeaux (ex: 0x81 -> Fin + Text
    2nd octet: (maskFlag<<7) + len du texte avec cas spécial pour len>125 et len>65535
    ..
    --- (3e, 5e ou 9e) masque 32 bits
    ex:

      81 [81..FD] mm mm mm mm tt......tt len caratères                (texte[0] en frame[6])
      Cas d'un texte "masqué" de lg < 126 car.

      81 [01..7D] tt.......tt len caratères                           (texte[0] en frame[2])
      Cas d'un texte de lg < 126 car.

      81 FE ll ll mm mm mm mm tt......tt                              (texte[0] en frame[8])
      Cas d'un texte "masqué" de lg > 126 et < 65535 car.

      81 7E ll ll tt......tt                                          (texte[0] en frame[4])
      Cas d'un texte de lg > 126 et < 65535 car.

      81 FF ll ll ll ll ll ll mm mm mm mm tt......tt                  (texte[0] en frame[12])
      Cas d'un texte "masqué" de lg > 65535 et < 281474976710655 car.

      81 7F ll ll ll ll ll ll tt......tt                              (texte[0] en frame[8])
      Cas d'un texte de lg > 65535 et < 281474976710655 car.

     |               |               |               |               |
      7 6 5 4 3 2 1 0 7 6 5 4 3 2 1 0 7 6 5 4 3 2 1 0 7 6 5 4 3 2 1 0 
     +-+-+-+-+-------+-+-------------+-------------------------------+
     |F|R|R|R| opcode|M| Payload len |    Extended payload length    |
     |I|S|S|S|  (4)  |A|     (7)     |             (16/64)           |
     |N|V|V|V|       |S|             |   (if payload len==126/127)   |
     | |1|2|3|       |K|             |                               |
     +-+-+-+-+-------+-+-------------+ - - - - - - - - - - - - - - - +
     |     Extended payload length   |                               |
     |  cont., if payload len==127   |                               |
     + - - - - - - - - - - - - - - - +-------------------------------+
     |                               |Masking-key, if MASK set to 1  |
     +-------------------------------+-------------------------------+
     | Masking-key (continued)       |          Payload Data         |
     +-------------------------------- - - - - - - - - - - - - - - - +
     :                     Payload Data continued ...                :
     + - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - +
     |                     Payload Data continued ...                |
     +---------------------------------------------------------------+

     NOTE Les trames TCP envoyées par les web-sockets (clients) sont toujours masquée) */

//dbug(__LINE__, "masked: \""._C.bin2hex($text).C_."\".");
    $length=ord($text[1])&0x7F;          // Longeur du texte "utile"
    $mFlgP=(ord($text[1])&0x80) ? 4 : 0; // Indicateur de masquage
    $l=strlen($text);                    // Longueur de la trame TCP embarquée
    if($length==0x7E)                    // Texte composé de moins de 65536 caractères
     $pos=4;                             // Position du masque
    elseif($length==0x7F)                // Texte composé de plus de 65536 caractères
     $pos=8;                             // Position du masque
    else                                 // Texte composé de moins de 126 caractères
     $pos=2;                             // Position du masque
    if ($mFlgP)                          // Le texte est "masqué" (0 ou 4)
      for ($umask="", $j=0, $i=$pos+4; $i<$l; ++$j, ++$i) // 4: lg. du masque
        $umask.=$text[$i]^$text[$pos+($j&3)];
//dbug(__LINE__, "Masked:   \""._J.bin2hex($text).C_."\".");
//dbug(__LINE__, "reçu head    ".C_.": \""._J.bin2hex(substr($text, 0, 2)).C_."\".");
//dbug(__LINE__, "reçu message ".C_.": \""._J.$umask.C_."\".");
//dbug(__LINE__, "Message:  \""._R.substr($text, $pos+$mFlgP, $l-$pos-$mFlgP).C_."\".");
//    return(substr($text, $pos+$mFlgP, $l-$pos-$mFlgP));
if(!isset($umask))print_r(debug_backtrace());
    return array(((ord($text[0])<<8)|ord($text[1])), $umask);
  }

  function Mask ($entet, $text, $mask=0) { // Encode message for transfer to client. {
  /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
  // "Text" correspond au message à envoyer (data), $entet est l'entier de 16 bits (-> chaîne
  // de 2 caractères) constituant l'entête du message. Cette fonction manipule les ¢6..¢0 du
  // header (ceux correspondant à la taille du message).
  // "$mask" est soit une chaîne de 4 caractères, soit 0
  // NOTE Les messages envoyés par le serveur à une websocket ne doivent pas être masqués :-)
//dbug(__LINE__, _G.$text.C_.", longueur: "._M.strlen($text).C_.".");
//dbug(__LINE__, "    "._M.bin2hex($text).C_.".");
    $l=strlen($text);                    // Longueur du texte
    $entet=($entet&0xFFF8)|($l&0x7F);    // Lg en place dans le header (si < 126)
    if ($entet&0x0080)                   // Si le message est à masquer ($mskB:¢7)
      for ($i=0; $i<$l; $i++)            // Réaliser le masquage
        $text[$i]=$text[$i]^$mask[$i&3]; // Caractère par caractères
    $xLM="";                             // Les éventuels car. additionnels lg. et msk.
    if ($l>=0x7E) {                      // Caractères additionnels de longueur
      if ($l<0xFFFF) {
        $entet=($entet&0xFFF8)|0x7E;
        $xLM.=chr($l>>8).chr($l&0xFF);
      } else {                           // On limite à deux gigas
        $entet=($entet&0xFFF8)|0x7F;
        $xLM.="\x00\x00\x00\x00".chr($l>>24).chr($l>>16).chr($l>>8).chr($l&0xFF);
      }
    }
    if ($entet&0x0080)                   // Caractères additionnels de masquage
      $xLM.=$mask[0].$mask[1].$mask[2].$mask[3];
//dbug(__LINE__, "envoi head   ".C_.": \""._J.bin2hex(chr($entet>>8).chr($entet&0xFF)).C_."\".");
//dbug(__LINE__, "envoi message".C_.": \""._J.$text.C_."\".");
//dbug(__LINE__, C_."\$xLM: \""._M.(bin2hex($xLM)).C_."\".");
    return chr($entet>>8).chr($entet&0xFF).$xLM.$text;
  }

  function Emet ($socket, $head, $msg){
  /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
//dbug(__LINE__, "Emet head    ".C_.": \""._J.bin2hex(chr($head>>8).chr($head&0xFF)).C_."\".");
//dbug(__LINE__, "Emet message ".C_.": \""._J.$msg.C_."\". (→ "._B.substr($s=" ".$socket, strpos($s, "#")).C_.").");
    $msg=htmlspecialchars($msg, ENT_HTML5|ENT_NOQUOTES); // Attention
    $msg=Mask($head, $msg);                              // NOTE Ajoute éventuellement, mais ne masque pas
    socket_write($socket, $msg, strlen($msg));
  }

  function Process ($user, $msg) {
  /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
  global $sockStk, $usrStk;

    $arr=Unmask($msg);                       // [0]:header (16 bits), [1]message json
    $head=$arr[0];                           // Le pur header de ce message
    $mess=str_replace("\n", "\\n", $arr[1]); // Le message (json du chat ou message système)
//dbug(__LINE__, " ← "._J.$mess.C_." (lg ".strlen($arr[1])."), "._B.sprintf("%x", $head).C_);
    $jsObj=json_decode(str_replace("'", '"', $mess), !0);
    $user->nick                              // Actualiser maintenant le nick, si possible
      ? "Quelqu’un" : $user->nick=@$jsObj['usr'];
//dbug(__LINE__, C_.(print_r($user, !0)));
//dbug(__LINE__, C_._B.(var_dump($jsObj)).C_);

//dbug(__LINE__, "Header ← \"".bin2hex(chr($head>>8).chr($head&0xFF))."\" ([0,1]".bin2hex(substr($arr[1], 0, 2)).").");
//dbug(__LINE__, "Messag ← \"".$arr[1]."\" (".$user->socket.").");
    if ($head==0x8882 && $arr[1]=="\x03\xe9") { // Fermeture de signet/fenêtre, sans prévenir
      DeconnecteClient($user->socket);       // Déconnexion du client
      $s=($n=count($usrStk))>1 ? "s" : "" ;  // Nb de connexion actives (après DeconnecteClient)
      $mess="{'usr':'".$user->nick."','mes':'est parti !','col':'red'}";
//dbug(__LINE__, C_."Envoi de \""._J.$mess.C_."\" ".($n==1 ? "à l'" : "aux "._R.$n.C_)."utilisateur{$s} connecté{$s}.");
      for($i=0; $i<$n; $i++)                 // Tous les utilisateur en passés en revue
        Emet($usrStk[$i]->socket, 0x8100, $mess); // Mis en forme 1 seule fois
    }
    if (($head&0x7F00)==0x0900)              // Ping
      Emet($user->socket, $head&0xF07F|0x0A00, $arr[1]); // Pas de mask + ¢ ping
    elseif (($head&0xFF00)==0x0A00)          // Pong
      ;                                      // Ignoré aujourd'hui
    elseif ($head&0x7000) {                  // Si 1 des 3 ¢s "RSV" (erreur ?)
      DeconnecteClient($user->socket);       // Déconnexion du client (après DeconnecteClient)
    } elseif (($head&0x7F00)<0x0300)         // Continuation, texte ou binaire (page 29)
    /// Not a control frames (-> message)
      if ($head==0x8182) {                   // Message de deux caractères :
       if ($arr[1]=="\x04\x04")              // "End Of Transmition" pour une déconnexion immédiate
        DeconnecteClient($user->socket);     // Déconnexion du client (avec DeconnecteClient)
      } else {
      $n=count($usrStk);                     // Nombre de connexion actives
//dbug(__LINE__, C_."Envoi de \""._J.$mess.C_."\" ".($n==1 ? "à l'" : "aux "._R.$n.C_)."utilisateur{$s} connecté{$s}.");
      for($i=0; $i<$n; $i++) {               // Tous les utilisateur en passés en revue
        Emet($usrStk[$i]->socket, $head&0xFF00, $mess); // Mis en forme et envoi
dbug(__LINE__, C_."\x07"."Relance à ".date("Y-m-d H:i:s ", time()));
        $usrStk[$i]->watchDog=time();        // On relance le chien de garde
      }
    }
    return;                     // Réveiller le client, peut-être
  }




  /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
  /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
  $debug=true;
  if (!isset($argc))
    die("<html><head><title>Erreur:</title>"
      ."<meta http-equiv='Content-Type' content='text/html; charset=UTF-8' /><style></style></head><body>"
      ."<h1>Erreur :</h1><h3>Ce script N'est exécutable QUE lancé depuis une console (PHP mode CLI)!</h3>"
      ."</body></html>");
  if ($argc>1) {
    if (!is_numeric($gPORT=$argv[1])) {
      say(_R."Erreur: syntaxe du port:"._C." \"$gPORT\" n'est pas un "._R."nombre".C_."!");
      die();
    }
    elseif ($gPORT>65536 || $gPORT<=0) {
      say(_R."Erreur: syntaxe du port:"._C." \"$gPORT\" n'est pas un "._R."nombre".C_."!");
      die();
    }
  } else
    $gPORT=DEF_PORT; // Port par défaut
//dbug(__LINE__, ConClr);
//dbug(__LINE__, print_r($GLOBALS, !0));
  $gHOST_NAME=trim(file_get_contents("/etc/hostname"));
  exec("hostname -i", $gHOST, $res);
  if ($res)
    die("La commande \"hostname -1\" ne fonctionne pas !\n");
  if (($p=strpos($gHOST=trim($gHOST[0]), " "))!==!1) {
    say(__LINE__, _R."ATTENTION".C_.": Cet hôte a plusieurs adresses IP ! (".str_replace(" ", ", ", $gHOST).")");
    $gHOST=substr($gHOST, 0, $p);
    }
  say(__LINE__, C_."Cet hôte s'appelle: \""._G.$gHOST_NAME.C_."\" (@$gHOST)");
  $usrStk=array();                     // Création d'une liste des utilisateurs
  $sock0=SocketCreate($gHOST, $gPORT); // Création de la socket de référence
  $sockStk[0]=$sock0;                  // En en fait une pile

  while(true) {
    $R_Array=$sockStk;                       // Cloner : socket_select() modifie la pile
    $W_Null=$X_Null=NULL;                    // &NULL n'est pas admis par socket_select()
    $res=socket_select($R_Array,$W_Null,$X_Null,2); // Voir si un message en attente -> $R_Array
    if ($res) foreach($R_Array as $sock) {   // Résultat de l'obs. des connectés en $R_Array
      if($sock==$sock0) {                    // La sock. originale : un nouveau client
        ($newSok=socket_accept($sock0))===!1 // Nouvelle ressource socket. Erreur si FALSE
          ? say(__LINE__, ": un client refusé.") // Oups ! ( continue; )
          : ConnecteClient($newSok);         // Pousse: 1 nouveau "user", cette ressource sock.
      }
      else {                                 // Une connexion déjà ouverte
        $bytes=@socket_recv($sock, $buffer, 2048, 0); // Disposé à recevoir
        if($bytes==0)                        // Si on n'a rien reçu maintenant :…
          DeconnecteClient($sock);           // …déconnexion de cette socket
        else {
          // Le cas où $bytes=2048 (gros fichier transmis ?) serait à traiter ici (?)
          $user=GetUserBySocket($sock);      // Retrouver l'utilisateur depuis sa socket
          if(!$user->handshake)              // Jamais valider…
            Handshaking($user, $buffer);     // …valider.
          else
            Process($user, $buffer);         // Traiter le message reçu.
        }
      }
    } else {
print(date("  Y-m-d H:i:s ", time())."\r");
      foreach ($sockStk as $sock) {   // Les n seconde (n=2) se sont écoulées
        $out=time()-TIME_OUT_WD;
        $user=GetUserBySocket($sock);        // Retrouver l'utilisateur depuis sa socket
        if ($user && $out>=$user->watchDog) { // Donner un coup de pied au client…
          $user->watchDog=time();            // …pour le réveiller
dbug(__LINE__, C_."\x07"."Envoi d'un ping à ".date("Y-m-d H:i:s ", time()));
          Emet($user->socket, 0x8904, "Ping"); // Pas de mask + ¢ ping
        }
      }
    }
  }
/*
php -r '$a=["A","B","C"];print_r($a);array_splice($a,1,1,["b","x","y","z"]);print_r($a);print("\n");'
Array ( [0] => A; [1] => B; [2] => C )
Array ( [0] => A; [1] => b; [2] => x; [3] => y; [4] => z; [5] => C )
 */