<?
  define("DEF_ADD", "192.168.0.5");
  define("DEF_PORT", "6545");
  define("DEF_COLO", "b903fd");

 /* ws_client+.php

Pour aller vite, soit pour base :
  Nom de la machine sur laquelle vous êtes (/home/moi) : "linux-moi.loc"
  Répertoire du zip :                                    "/home/moi/Téléchargement/websokets/"
  Votre nom d'utilisateur :                              "moi"
  URL de votre serveur local :                           "mon.serveur.local"
  IPv4 de votre serveur local :                          "192.168.0.5"
  Répertoire principale du sous domaine "mon" :          "/var/www/serveur/mon/"
  Dans une console (la suite est fonction de la conf de linux-se) :
    cd ~/Téléchargement/websokets/
    # Se connecter au serveur
    sudo ssh mon.serveur.local # saisir les mots de passe des "root"s des 2 machines
    # copier les fichiers sources
    scp moi@linux-moi.loc:/home/moi/Téléchargement/websokets/ws_server+.php /var/www/
    scp moi@linux-moi.loc:/home/moi/Téléchargement/websokets/ws_client+.php /var/www/
    # Lancer le serveur
    php /var/www/serveur/mon/websokets/ws_server+.php

  Cette source est une reprise avec un profond remaniement du tutoriel de
  http://sii-rennes.developpez.com/articles/un-chat-en-html5-avec-les-websockets/
  qui n’est absolument pas fonctionnel en l’état actuel (<2015-06-28). C’est un bon départ
  pour “tâter” voir ce que sont les websockets. La source d’information la plus sérieuse,
  mais qui n’est toujours pas “normative” est la fastidieuse mais abordable
  http://tools.ietf.org/html/rfc6455 que je vous invite à parcourir (en anglais).

  J’ai essayé avec Chrome et Firefox. Firefox est prompt au tennis de table. Il envoie un
  PING toutes les 20 secondes, et se déconnecte s'il n'y a aucune activité autre que les
  PONGs en réaction. Le serveur se charge d'envoyer des PING de sont côté, toute les 200 sec-
  ondes suivants le précédent PING ou suivant un message utilisateur retransmis.

  Précision sur cette source:
  Soit le script client "ws_client+.php" placé sur votre serveur, invoquez le comme ceci
    http://mon.serveur.local/ws_client+.php
  Il vous sera demandé un pseudonyme d'utilisateur (nécessaire en réalité et pratique pour
  les essais).
  Si vous invoquez ce script tel-quel, la page cherchera à se connecter
    - à l'hôte DEF_ADD,
    - sur le port DEF_PORT,
  et la couleur affectée à l'utilisateur sera "#".DEF_COLO. (voir les définitions plus bas)
  "mon.serveur.local devrait figurer dans votre /etc/hosts ou votre DNS. Vous pouvez
  cependant définir un autre hôte que celui par défaut en saisissant le paramètre
  "host=nom.de.lhote" ou "host=84.100.101.102". Si vous désirez préciser le port, il faut
  ajouter ":" suivit d'un Nº de port.
  Notez que la disponibilité système type UNIX du Nº de port est vérifiée à partir du fichier
  local "/etc/services", et donc celui du client.
  NOTE Les vérifications sur l'hote et le port donneront lieu à des modification (de sorte à
  ce que cette vérification ne soit plus faite ?), en particulier si le client est
  animé par ce système  de l'autre monde.

  Résultats de la fonction CheckPort() :
    http://mon.serveur.local/websokets/ws_client+.php?host=mon.serveur.local:13
    Erreur: Protocole 13 réservé (tcp, udp).

    http://mon.serveur.local/websokets/ws_client+.php?host=mon.serveur.local:12
    /etc/services indique: port 12 utilisable.

    http://mon.serveur.local/websokets/ws_client+.php?host=mon.serveur.local:foo
    Erreur: syntaxe du port: "foo" n'est ni un nombre, ni un protocole connu (sur autre que "tcp").

  Autres résultats :
    http://mon.serveur.local/websokets/ws_client+.php?host=192.168.0.300
    L'adresse IP passée en paramètre est incorrecte!

    http://mon.serveur.local/websokets/ws_client+.php?host=mon.serveur.local:1564853
    Erreur: le nº de port: "1564853" est hors échelle.

    http://mon.serveur.local/websokets/ws_client+.php?host=mon.serveur.local:12
    L'hôte "192.168.0.5" ne répond pas sur le port "12".

  Pour la mise en forme de cette source :
  - je “joue” des ressources de coloration et de la police de caractères de mon éditeur afin
    de “grouper” visuellement le code
  - Jamais de code sur la première colonne (sauf # et <? en 1ère ligne) : strictement réservé
    au code de débogage
  - Le “principal” du code en bas de source, les fonctions et autres définitions en haut, le
    la plus “légère” à la plus “lourde”
 - indentation de 1 espace en JS, deux en PHP
 - j’évite de dépasser 96 colonnes par ligne (loin, les écrans de 12 lignes x 40 col.!)

    NOTE C'est le serveur qui se charge de convertir les caractères spéciaux, et la function php
    htmlspecial() traite à priori de la sécurité : souvenez-vous que le message est confié à
    eval() côté client… J'ai essayé l'envoi d'un "gros" texte de plus de 500 caractères et une
    fois "formatée" par php, les '\n' et les ' ' sucsessifs ont été supprimé par htmlspecial(),
    ce qui fait pourrait nuire à la présentation.

    TODO Sur Firefox, il y a une erreur "SyntaxError: expected expression, got end of script" et il
    est montrée la ligne <!DOCTYPE html>, mais la page continue de fonctionner, sauf la
    touche "↵". Même chose pour Chrome (Uncaught SyntaxError: Unexpected token }), mais l'erreur
    est affichée à un autre endroit (<button id=SendM onclick=SendIn()>Envoi</button>). Je n'ai
    pas trouvé ! Je l'est observé peu de temps après avoir voulu utiliser l'opacité sur le
    bouton "#SendM".
    Je n'insiste pas dans le débogage, vu que j'utiliserais la librairie JQuery si je voulais
    continuer plus avant.
    TODO Il faut

/** compréhension des commentaires:
      ⇄    ⇄   correspond à
      ☉    ⇄   voir…
      ¢    ⇄   bit, Lsb=¢0; ¢7:¢0 ⇄ l'octet du bit 0 au bit 7
« ∗– ’‘”” ✓✔✉—•†‡…⏎↵ ÆæŒœ »⇩⇧✈☑☐ ∞↻ ♥♠♦♣▒ peru:#cd853f
¥ ☩ ★ ☆ ≶ ≛ ≒ ≍ ≈ ⇄ ☐ ☹ ☺ ☻ ☚ ☜ ± ÷ ¼ ¾ Ππ ✌ ₀ ₁ ₂ ₃ ₄ ₅ ₆ ₇ ₈ ₉ ⁰ ¹ ² ³ ⁴ ⁵ ⁶ ⁷ ⁸ ⁹ ⅟ ᵉ ◎ ☉ */

   /// *******************************************************************************************
  function CheckPort ($nOrName, &$info) {
  // Vérifie si $nOrName est dans la liste "/etc/services". 4 Protocoles de bas connus aujourd'hui:
  // tcp, udp, sctp et dccp; "the WebSocket Protocol is an independent TCP-based protocol".

    $fname="/etc/services";
    $num=is_numeric($nOrName);              // Boolean : numérique
    if (($fHand=fopen($fname, "r"))===false) { // Le ficher est là ?
      if ($num) {
        $info="Le fichier $fname n'est pas disponible sur cette machine. Nº de port accepté sans vérification de disponibilité.<br >";
        return $nOrName;
      } else {
        $info="Le fichier $fname n'est pas disponible sur cette machine. Nº de port correspondant à \"$nOrName\" est inconnu.<br >";
        return 0;
      }
    }
    $num && $nOrName=intval($nOrName);          // Vrai entier
    for ($protoN="", $otos="", $res=$found=$n=0; !feof($fHand); $n++) {
      if (substr($buffer=trim(fgets($fHand)), 0, 1)=="#")
        continue;
      list($pName, $pNumber, $proto)=sscanf($buffer, "%s %d/%s");
//if ($n<=200) print("<!-- ".__LINE__.", \$pName:$pName, \$pNumber:$pNumber, \$proto:$proto-->\n");
      if ($num) {                            // Le paramètre est numérique
        if ($pNumber==$nOrName) {
          $found|=1;
          $protoN=$pName;
          $res=$nOrName;
          $otos.=($otos ? ", " : "").$proto; // Utilisé également pour ce protocole
          }
        elseif ($pNumber>$nOrName) {           // Sont classés dans l'ordre croissant
          $found ? 0 : $res=$nOrName;
          break;
        }
      } elseif ($pName==$nOrName) {
        $found|=1;
        $protoN=$pName;
        $res=$pNumber;
        $otos.=($otos ? ", " : "").$proto;   // Utilisé également pour ce protocole
      }
    }
    fclose($fHand);
    if ($found && strpos($otos, "tcp")!==false) // Port+Protocol tcp réservé
      $res=0;
    $info="$fname indique: port $nOrName "
          .($res ? "utilisable" : ($num ? "réservé" : "inconnu"))
          .($otos ? " (".$otos.")" : "").".<br />";
//print("<!-- ".__LINE__.", \$res: $res, \"$info\" -->\n");
    return $res;
  }


   /// *******************************************************************************************
  $info="";

  // Vérification et ajustage de la couleur
  if ($colo=@$_GET['colo']) {
    if ($colo=="rnd")
      $colo=sprintf("%x", (rand(0x10, 0xE0)<<16)+(rand(0x10, 0xE0)<<8)+rand(0x10, 0xE0));
    else if (preg_match_all("([0-9a-fA-F])", $colo)!=strlen($colo))
      die("<big style=color:red><b>Erreur: Couleur incorrecte ':' doit comporter 6 caractères alphanumériques, ou être \"rnd\".</b></big><br />");
  } else
    $colo=DEF_COLO;
  // Vérification et ajustage de l'adresse de l'hôte et du port
  if (!($host=@$_GET['host'])) {
    $host=DEF_ADD;
    $hName="[par défaut], ".gethostbyaddr($host).":".($port=DEF_PORT);
  } else {
    $port=explode(":", $host);     // [0]: Adresse / name, [1]: port
    $host=$port[0];
    if (!($port=$port[1]))
      die("<big style=color:red><b>Erreur: le caractère ':' est placé mais le port n'est pas précisé.</b></big><br />");
    elseif (!is_numeric($port)) {
      if (!($res=CheckPort($port, $info)))
        die("<big style=color:red><b>Erreur: syntaxe du port: \"$port\" n'est ni un nombre, ni un protocole connu (sur autre que \"tcp\").</b></big><br />");
    }
    elseif ($port>65536 || $port<=0)
      die("<big style=color:red><b>Erreur: le nº de port: \"$port\" est hors échelle.</b></big><br />");
    else
      $res=CheckPort($port, $info);
    $ip=@gethostbyname($host);                     // Récupérer l'adresse IP d'après le nom en paramètre
    if ($res
        && !filter_var($ip, FILTER_VALIDATE_IP)    // Un nom a bien été retourné par gethostbyaddr()
        && !filter_var($host, FILTER_VALIDATE_IP)) // L'adresse IP en paramètre est incorrecte
      die("<big style=color:red><b>L'adresse IP passée en paramètre est incorrecte!</b></big><br />");
    else {
      $hName=$host;              // L'utilisateur à bien saisi un nom
      $host=$ip;                 // L'adresse IP a (peut-être) été trouvée
    }
  }
  // Vérifier si le serveur répond:
  if ($res) {
    $fp=@fsockopen($host, $res, $errno, $errstr, 1);
    $fp
      ? fclose($fp)
      : die($info."<big style=color:red><b>L'hôte \"$host\" ne répond pas sur le port \"$res\".</b></big><br />");
  } else
    die("<big style=color:red><b>Erreur: $info</b></big>");
 ?>
 <!DOCTYPE html>
 <html>
  <head>
   <meta charset="utf-8" />
   <title>WebSocket</title>
   <style>
   html,body{font:normal 0.9em arial,helvetica}
   #Chat {width:440px;height:200px;border:1px solid #7F9DB9;overflow:auto}
   #Edit {width:300px}
   </style>

   <script>
   const kStTxt=["Ouvrant","Ouvert","Fermant","Fermé"]
   ,kStCol=["yellow","green","orange","red"]
   ;
   var $d$=document, $w$=window, gWS=0
   ,gSedo="Paul_Le_Heros"
   ,gColo="#"+"<?= $colo ?>"
   ,gPort="<?= $res ?>"
   ,gHName="<?= $hName ?>"
   ,gAdd="<?= $host ?>"
   ,gFeu
   ;
    function colz (m, c){ /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
     return "<span style=color:"+c+">"+m+"</span>"
    }
    function $ (id) { /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
     return document.getElementById(id)
    }
    function Dit (a) {  /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
    var $$=$("Chat");
     a.mes.substr(-1)!="\n" ? a.mes+="\n" : 0;
     $$.innerHTML+=colz(a.usr, a.col)+": "+a.mes.replace(/</g, "&lt;").replace(/\n/g, "<br />");
     $$.scrollTop=0x7fffffff;
    }
    function log (m){ /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
     $("debug").innerHTML+="<br />"+m
    }
    function Send (m) { /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
     try { gWS.send(m); log('Sent: '+m) } catch (ex) { log(ex) }
    }
    function OBU (e) {  /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
     return "Attention. Quitter ce chat en pressant le bouton \"Quitter\", s'il-vous-plaît.\n"
           +"Cliquez sur \"Rester sur cette page\" ou \"Ne pas actualiser\" pour pouvoir le faire."
    }
    function Quit(t){ /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
      log("Goodbye!");
      Send("{ 'usr':'"+gSedo+"'"     // Salutations
          +", 'mes':'Au revoir !'" // , “"+gHName+"”
          +", 'col':'"+gColo+"' }");
      setTimeout(function () { // Réelle fermeture dans ⅟₁₀ᵉ sec.
       Send("\x04\x04");       // "End Of Transmition"
       gWS.close()
      }, 100)
      t.style.display=/*$("SendM").style.display=*/"none";
    }
    function SendIn () {  /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
    // Envoie le contenu de l'INPUT #Edit, au format utilisateur (encapsulé websocket)
    var _u, _t=$("Edit"), _m=_t.value;
     if (!_m) return;
     _t.value=""; // Éffacer le contenu du champ
     _t.focus();   // Et focuser dessus
     _m="{'usr':'"+gSedo+"'" // Composer le message au format
      +",'mes':'"+_m+"'"
      +",'col':'"+gColo+"'}";
     Send(_m);
    }
    function KeyPressed (e) { /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
     if (e.keyCode==13)
      // TODO Remplacer l'INPUT "#edi" par un TEXTAREA. "Ctrl+↵" ou "Alt+↵" insèrant "\n" dans
      // ce champ
      $("Edit").value.length && SendIn()
    }
   function init () { /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
    try{
       gWS=new WebSocket("ws://"+gAdd+":"+gPort+"/");
       gWS.onopen=
        function(m){
         Send("{ 'usr':'"+gSedo+"'"
             +", 'mes':'Bonjour !'" // , “"+gHName+"”
             +", 'col':'"+gColo+"' }");
         log("État: "+kStTxt[this.readyState]);
         $w$.onbeforeunload=OBU
        };
       gWS.onmessage=
        function(m){
        var _a;
         eval("_a="+m.data);
         Dit(_a);
        };
       gWS.onclose=
        function(msg){
         $w$.onbeforeunload=null;
         log("État: "+kStTxt[this.readyState]);
        };
     } catch(ex){ log(ex); }

     $("Edit").focus();
     setInterval(function () { // "CONNECTING","OPEN","CLOSING","CLOSED"
     var _t;
      gFeu.style.backgroundColor=kStCol[gWS
       ? (_t=gWS.readyState)==3
        ? (gWs=0, 3)
        : _t
       : 3]; // gWS==0 Jamais utilisée ou fermée
      //$("SendM").style.opacity=$("Edit").value ? 1 : 0.1;
     }, 100) // À chaque ⅟₁₀ᵉ sec.
   }

   /// *******************************************************************************************
   $w$.onload=function () { /// <s"*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*">
 //initNotify();
   var cp="Utilisateur_" // Pseudo par défaut
   ,re=/^[0-9_a-zA-ZÀ-ʯ]{3,18}$/ // new RegExp("^[0-9_a-zA-Z\u00c0-\u02AF]{3,8}$")
   ;
    function GetSetOpt () {
    // Propose à l'utilisateur le changement de son pseudonyme "cp" si "cp" est défini, ou la
    // saisie d'un nouveau si "cp" est une chaîne syntaxiquement correcte.
    var /*const*/ kC="Saisissez un nouveau pseudonyme si vous voulez en changer :"
    ,k1="Saisissez le pseudonyme que vous souhaitez utiliser :"
    ,kE="Le pseudo est incorrect. de 3 à 18 lettres(avec accents), nombre et '_' sont autorisés"
    ,fg=re.test(cp) // Tester la syntaxe du pseudonyme
    ,ok, np // Nouveau pseudo
    ;
     np=prompt(fg ? kC : k1, cp);
     ok=fg ? re.test(np ? np : np=cp) : np ? re.test(np) : np="";
     for (; !ok; _i=prompt(kE, np), ok=_i!==null && re.test(np=_i ? _i : np));
     gSedo=np; // Les modifications de pseudo
    }
   !re.test(cp)
    && alert("ATTENTION :\nLe pseudo par défaut “"+cp+"”, codé en dur, n'est pas correct!");
   $("Add").innerHTML=gAdd;
   $("Port").innerHTML=gPort;
   GetSetOpt();
   gFeu=$("phoro");
   init();
   //$("SendM").style.opacity=0.1;
   };
   /// *******************************************************************************************
   </script>

  </head>
  <body><?= $info ?>
   WebSocket v2.00 &nbsp; <big><b id=Add style=color:red></b></big> (<?= $hName ?>), <small id=Port></small>
   <div id="Chat"></div>
   <img id=phoro src=Phoro.png style=background-color:green;position:relative;top:4px />
   <input id=Edit type=textbox onkeypress=KeyPressed(event)/>
   <button id=SendM onclick=SendIn()>Envoi</button><!-- style=opacity:0.1-->
   <button onclick=Quit(this)>Quitter</button>
<div id=debug></div>
  </body>
 </html>
