/* -*- Mode: C; c-file-style: "gnu"; tab-width: 8 -*- */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __MY_NOTEBOOK_H__
#define __MY_NOTEBOOK_H__


//#if defined(GTK_DISABLE_SINGLE_INCLUDES) && !defined (__GTK_H_INSIDE__) && !defined (GTK_COMPILATION)
//#error "Only <gtk/gtk.h> can be included directly."
//#endif

//#include <gtk/gtkcontainer.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define MY_TYPE_NOTEBOOK                  (my_notebook_get_type ())
#define MY_NOTEBOOK(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), MY_TYPE_NOTEBOOK, MyNotebook))
#define MY_NOTEBOOK_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), MY_TYPE_NOTEBOOK, MyNotebookClass))
#define MY_IS_NOTEBOOK(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MY_TYPE_NOTEBOOK))
#define MY_IS_NOTEBOOK_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), MY_TYPE_NOTEBOOK))
#define MY_NOTEBOOK_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), MY_TYPE_NOTEBOOK, MyNotebookClass))


typedef enum
{
  MY_NOTEBOOK_TAB_FIRST,
  MY_NOTEBOOK_TAB_LAST
} MyNotebookTab;

typedef struct _MyNotebook       MyNotebook;
typedef struct _MyNotebookClass  MyNotebookClass;
#if !defined (GTK_DISABLE_DEPRECATED) || defined (GTK_COMPILATION)
typedef struct _MyNotebookPage   MyNotebookPage;
#endif

struct _MyNotebook
{
  GtkContainer container;

#if !defined (GTK_DISABLE_DEPRECATED) || defined (GTK_COMPILATION)
  MyNotebookPage *GSEAL (cur_page);
#else
  gpointer GSEAL (cur_page);
#endif
  GList *GSEAL (children);
  GList *GSEAL (first_tab);		/* The first tab visible (for scrolling notebooks) */
  GList *GSEAL (focus_tab);

  GtkWidget *GSEAL (menu);
  GdkWindow *GSEAL (event_window);

  guint32 GSEAL (timer);

  guint16 GSEAL (tab_hborder);
  guint16 GSEAL (tab_vborder);

  guint GSEAL (show_tabs)          : 1;
  guint GSEAL (homogeneous)        : 1;
  guint GSEAL (show_border)        : 1;
  guint GSEAL (tab_pos)            : 2;
  guint GSEAL (scrollable)         : 1;
  guint GSEAL (in_child)           : 3;
  guint GSEAL (click_child)        : 3;
  guint GSEAL (button)             : 2;
  guint GSEAL (need_timer)         : 1;
  guint GSEAL (child_has_focus)    : 1;
  guint GSEAL (have_visible_child) : 1;
  guint GSEAL (focus_out)          : 1;	/* Flag used by ::move-focus-out implementation */

  guint GSEAL (has_before_previous) : 1;
  guint GSEAL (has_before_next)     : 1;
  guint GSEAL (has_after_previous)  : 1;
  guint GSEAL (has_after_next)      : 1;
};

struct _MyNotebookClass
{
  GtkContainerClass parent_class;

  void (* switch_page)       (MyNotebook     *notebook,
#if !defined (GTK_DISABLE_DEPRECATED) || defined (GTK_COMPILATION)
                              MyNotebookPage *page,
#else
                              gpointer         page,
#endif
                  guint            page_num);

  /* Action signals for keybindings */
  gboolean (* select_page)     (MyNotebook       *notebook,
                                gboolean           move_focus);
  gboolean (* focus_tab)       (MyNotebook       *notebook,
                                MyNotebookTab     type);
  gboolean (* change_current_page) (MyNotebook   *notebook,
                                gint               offset);
  void (* move_focus_out)      (MyNotebook       *notebook,
                GtkDirectionType   direction);
  gboolean (* reorder_tab)     (MyNotebook       *notebook,
                GtkDirectionType   direction,
                gboolean           move_to_last);

  /* More vfuncs */
  gint (* insert_page)         (MyNotebook       *notebook,
                    GtkWidget         *child,
                GtkWidget         *tab_label,
                GtkWidget         *menu_label,
                gint               position);

  MyNotebook * (* create_window) (MyNotebook       *notebook,
                                   GtkWidget         *page,
                                   gint               x,
                                   gint               y);

  void (*_gtk_reserved1) (void);
};

typedef MyNotebook* (*MyNotebookWindowCreationFunc) (MyNotebook *source,
                                                       GtkWidget   *page,
                                                       gint         x,
                                                       gint         y,
                                                       gpointer     data);

/***********************************************************
 *           Creation, insertion, deletion                 *
 ***********************************************************/

GType   my_notebook_get_type       (void) G_GNUC_CONST;
GtkWidget * my_notebook_new        (void);
gint my_notebook_append_page       (MyNotebook *notebook,
                     GtkWidget   *child,
                     GtkWidget   *tab_label);
gint my_notebook_append_page_menu  (MyNotebook *notebook,
                     GtkWidget   *child,
                     GtkWidget   *tab_label,
                     GtkWidget   *menu_label);
gint my_notebook_prepend_page      (MyNotebook *notebook,
                     GtkWidget   *child,
                     GtkWidget   *tab_label);
gint my_notebook_prepend_page_menu (MyNotebook *notebook,
                     GtkWidget   *child,
                     GtkWidget   *tab_label,
                     GtkWidget   *menu_label);
gint my_notebook_insert_page       (MyNotebook *notebook,
                     GtkWidget   *child,
                     GtkWidget   *tab_label,
                     gint         position);
gint my_notebook_insert_page_menu  (MyNotebook *notebook,
                     GtkWidget   *child,
                     GtkWidget   *tab_label,
                     GtkWidget   *menu_label,
                     gint         position);
void my_notebook_remove_page       (MyNotebook *notebook,
                     gint         page_num);

/***********************************************************
 *           Tabs drag and drop                            *
 ***********************************************************/

#ifndef GTK_DISABLE_DEPRECATED
void my_notebook_set_window_creation_hook (MyNotebookWindowCreationFunc  func,
                        gpointer                       data,
                                            GDestroyNotify                 destroy);
void my_notebook_set_group_id             (MyNotebook *notebook,
                        gint         group_id);
gint my_notebook_get_group_id             (MyNotebook *notebook);

void my_notebook_set_group                (MyNotebook *notebook,
                        gpointer     group);
gpointer my_notebook_get_group            (MyNotebook *notebook);
#endif /* GTK_DISABLE_DEPRECATED */

void         my_notebook_set_group_name   (MyNotebook *notebook,
                                            const gchar *group_name);
const gchar *my_notebook_get_group_name   (MyNotebook *notebook);


/***********************************************************
 *            query, set current NotebookPage              *
 ***********************************************************/

gint       my_notebook_get_current_page (MyNotebook *notebook);
GtkWidget* my_notebook_get_nth_page     (MyNotebook *notebook,
                      gint         page_num);
gint       my_notebook_get_n_pages      (MyNotebook *notebook);
gint       my_notebook_page_num         (MyNotebook *notebook,
                      GtkWidget   *child);
void       my_notebook_set_current_page (MyNotebook *notebook,
                      gint         page_num);
void       my_notebook_next_page        (MyNotebook *notebook);
void       my_notebook_prev_page        (MyNotebook *notebook);

/***********************************************************
 *            set Notebook, NotebookTab style              *
 ***********************************************************/

void     my_notebook_set_show_border      (MyNotebook     *notebook,
                        gboolean         show_border);
gboolean my_notebook_get_show_border      (MyNotebook     *notebook);
void     my_notebook_set_show_tabs        (MyNotebook     *notebook,
                        gboolean         show_tabs);
gboolean my_notebook_get_show_tabs        (MyNotebook     *notebook);
void     my_notebook_set_tab_pos          (MyNotebook     *notebook,
                            GtkPositionType  pos);
GtkPositionType my_notebook_get_tab_pos   (MyNotebook     *notebook);

#ifndef GTK_DISABLE_DEPRECATED
void     my_notebook_set_homogeneous_tabs (MyNotebook     *notebook,
                        gboolean         homogeneous);
void     my_notebook_set_tab_border       (MyNotebook     *notebook,
                        guint            border_width);
void     my_notebook_set_tab_hborder      (MyNotebook     *notebook,
                        guint            tab_hborder);
void     my_notebook_set_tab_vborder      (MyNotebook     *notebook,
                        guint            tab_vborder);
#endif /* GTK_DISABLE_DEPRECATED */

void     my_notebook_set_scrollable       (MyNotebook     *notebook,
                        gboolean         scrollable);
gboolean my_notebook_get_scrollable       (MyNotebook     *notebook);
guint16  my_notebook_get_tab_hborder      (MyNotebook     *notebook);
guint16  my_notebook_get_tab_vborder      (MyNotebook     *notebook);

/***********************************************************
 *               enable/disable PopupMenu                  *
 ***********************************************************/

void my_notebook_popup_enable  (MyNotebook *notebook);
void my_notebook_popup_disable (MyNotebook *notebook);

/***********************************************************
 *             query/set NotebookPage Properties           *
 ***********************************************************/

GtkWidget * my_notebook_get_tab_label    (MyNotebook *notebook,
                       GtkWidget   *child);
void my_notebook_set_tab_label           (MyNotebook *notebook,
                       GtkWidget   *child,
                       GtkWidget   *tab_label);
void my_notebook_set_tab_label_text      (MyNotebook *notebook,
                       GtkWidget   *child,
                       const gchar *tab_text);
const gchar *my_notebook_get_tab_label_text (MyNotebook *notebook,
                                              GtkWidget   *child);
GtkWidget * my_notebook_get_menu_label   (MyNotebook *notebook,
                       GtkWidget   *child);
void my_notebook_set_menu_label          (MyNotebook *notebook,
                       GtkWidget   *child,
                       GtkWidget   *menu_label);
void my_notebook_set_menu_label_text     (MyNotebook *notebook,
                       GtkWidget   *child,
                       const gchar *menu_text);
const gchar *my_notebook_get_menu_label_text (MyNotebook *notebook,
                                               GtkWidget   *child);
#ifndef GTK_DISABLE_DEPRECATED
void my_notebook_query_tab_label_packing (MyNotebook *notebook,
                       GtkWidget   *child,
                       gboolean    *expand,
                       gboolean    *fill,
                       GtkPackType *pack_type);
void my_notebook_set_tab_label_packing   (MyNotebook *notebook,
                       GtkWidget   *child,
                       gboolean     expand,
                       gboolean     fill,
                       GtkPackType  pack_type);
#endif
void my_notebook_reorder_child           (MyNotebook *notebook,
                       GtkWidget   *child,
                       gint         position);
gboolean my_notebook_get_tab_reorderable (MyNotebook *notebook,
                       GtkWidget   *child);
void my_notebook_set_tab_reorderable     (MyNotebook *notebook,
                       GtkWidget   *child,
                       gboolean     reorderable);
gboolean my_notebook_get_tab_detachable  (MyNotebook *notebook,
                       GtkWidget   *child);
void my_notebook_set_tab_detachable      (MyNotebook *notebook,
                       GtkWidget   *child,
                       gboolean     detachable);

GtkWidget* my_notebook_get_action_widget (MyNotebook *notebook,
                                           GtkPackType  pack_type);
void       my_notebook_set_action_widget (MyNotebook *notebook,
                                           GtkWidget   *widget,
                                           GtkPackType  pack_type);

GType my_notebook_tab_get_type (void) G_GNUC_CONST;
#define MY_TYPE_NOTEBOOK_TAB (my_notebook_tab_get_type ())

#ifndef GTK_DISABLE_DEPRECATED
#define	my_notebook_current_page               my_notebook_get_current_page
#define my_notebook_set_page                   my_notebook_set_current_page
#endif /* GTK_DISABLE_DEPRECATED */

G_END_DECLS

#endif /* __MY_NOTEBOOK_H__ */
