#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "notebook.h"


int main( int   argc,
          char *argv[])
{
  GtkWidget *window;
  GtkWidget *notebook;

  gtk_init (&argc, &argv);

  const char *rc_style = " \
    style \"my_style\" { \
          MyNotebook::bar-padding-top = 15 \
    } \
    \
    widget_class \"*<MyNotebook>\" style \"notebook_bg\" \
    widget_class \"*<MyNotebook>*<GtkEventBox>\" style \"notebook_bg\" \
    widget_class \"*<MyNotebook>*<GtkDrawingArea>\" style \"notebook_bg\" \
    widget_class \"*<MyNotebook>*<GtkLayout>\" style \"notebook_bg\" \
    widget_class \"*<MyNotebook>*<GtkLabel>\" style \"notebook_bg\" \
    widget_class \"*<MyNotebook>\" style \"notebook\" \
    widget_class \"*<MyNotebook>*<GtkButton>\" style \"notebook_button\" \
    widget_class \"*<MyNotebook>*<GtkButton>*<GtkLabel>\" style \"notebook_button\" \
    \
    widget_class \"*.<MyNotebook>\" style \"my_style\"";
    gtk_rc_parse_string (rc_style);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_position(GTK_WINDOW (window), GTK_WIN_POS_CENTER);
  gtk_window_set_default_size(GTK_WINDOW (window), 100, 60);
  //gtk_window_set_default_size(GTK_WINDOW (window), 100, 33);

  gtk_window_set_title (GTK_WINDOW (window), "My Notebook");

  g_signal_connect (window, "delete-event",
            G_CALLBACK (gtk_main_quit), NULL);

  gtk_container_set_border_width (GTK_CONTAINER (window), 10);

  notebook = my_notebook_new ();
  my_notebook_append_page(MY_NOTEBOOK(notebook), gtk_label_new("Hello World"), gtk_label_new("Home"));
  my_notebook_append_page(MY_NOTEBOOK(notebook), gtk_label_new("Hello World"), gtk_label_new("Home"));
  my_notebook_append_page(MY_NOTEBOOK(notebook), gtk_label_new("Hello World"), gtk_label_new("Home"));
  my_notebook_append_page(MY_NOTEBOOK(notebook), gtk_label_new("Hello World"), gtk_label_new("Home"));

  gtk_container_add (GTK_CONTAINER (window), notebook);
  gtk_widget_show_all (notebook);

  gtk_widget_show (window);

  gtk_main ();

  return 0;
}

