#!/bin/bash
#=========================================================================================
# Sauvegarde vers serveur Raspberry en réseau local
# S'appuie sur une communication SSH avec clé
#
# Alain BACH le 08/09/2015 - http://www.alainbach.fr
#=========================================================================================

# echo "Sauvegarde vers Raspberry data commencée"
# echo "Backup DATA commence le "`date "+%d/%m/%Y a %T"`
# Nom de l'utilisateur à sauvegarder
user_rasp=$3

log_svg_rasp=/home/$LOGNAME/scripts/logs/log_rasp.log
logerreur_svg_rasp=/home/$LOGNAME/scripts/logs/log_rasp_erreur.log

cd /home/$LOGNAME/scripts

mpg123 -q /home/$LOGNAME/scripts/sons/sauvegarde_Raspberry_DEBUT.mp3

echo "===============================================================================" >> $logerreur_svg_rasp
echo "ERREURS : Sauvegarde Raspberry vers $dest"                                       >> $logerreur_svg_rasp
echo "Backup  Raspberry commence le "`date "+%d/%m/%Y a %T"`                           >> $logerreur_svg_rasp
echo "===============================================================================" >> $log_svg_rasp
echo "Sauvegarde svg-rasp vers " $dest >> $log_svg_rasp
echo "Backup commence le "`date "+%d/%m/%Y a %T"` >> $log_svg_rasp
echo "===============================================================================" >> $log_svg_rasp

# Sauvegarde DATA
dest=pi@192.168.1.42:/media/usb1/$LOGNAME
echo "Backup DATA commence le "`date "+%d/%m/%Y a %T"` >> $log_svg_rasp
rsync -e ssh -arz --delete-after --files-from=svg-rasp.include --exclude-from=svg-rasp.exclude  /media/$LOGNAME/1to/svg-inc/$LOGNAME/today $dest 2>>$logerreur_svm_rasp 1>>$log_svg_rasp
echo "Backup DATA termine  le "`date "+%d/%m/%Y a %T"` >> $log_svg_rasp

# Sauvegarde DISK
dest=pi@192.168.1.42:/media/usb2/$LOGNAME
echo "." >> $log_svg_rasp
echo "Backup DISK commence le "`date "+%d/%m/%Y a %T"` >> $log_svg_rasp
rsync -e ssh -arz --delete-after --files-from=svg-rasp-disk.include --exclude-from=svg-rasp-disk.exclude  /media/$LOGNAME/1to/svg-inc/$LOGNAME/today $dest 2>>$logerreur_svm_rasp 1>>$log_svg_rasp
echo "Backup DISK termine  le "`date "+%d/%m/%Y a %T"` >> $log_svg_rasp

mpg123 -q /home/$LOGNAME/scripts/sons/sauvegarde_Raspberry_FIN.mp3

echo "Fin de log"                                                                      >> $logerreur_svg_rasp
echo "===============================================================================" >> $log_svg_rasp
echo "fin de la sauvegarde vers Raspberry"                                             >> $log_svg_rasp
echo "===============================================================================" >> $log_svg_rasp

cat $log_svg_rasp >> $1
cat $logerreur_svg_rasp >> $2
