#!/bin/bash
#=========================================================================================
# sauvegarde incrementale sur support USB
# Origine http://godefroy.me/faire-un-backup-incremental-avec-un-simple-bash-a335207
#=========================================================================================
# Adaptation Alain BACH le 08/09/2015
#=========================================================================================
# La sauvegarde se fait sur un volume USB, formaté en EXT4 et appelé "SVG-INC"
#=========================================================================================

echo "Sauvegarde incrémentale commencée"
echo "Sauvegarde commencee le "`date "+%d/%m/%Y a %T"`

# Nom de l'utilisateur à sauvegarder
user_inc=$3

# Destination du backup si Ubuntu supérieur à 12.04
dest=/media/$LOGNAME/1to/svg-inc/$LOGNAME

log_svg_inc=/home/$LOGNAME/scripts/logs/log_svg_inc.log
logerreur_svg_inc=/home/$LOGNAME/scripts/logs/log_svg_inc_erreur.log

cd /home/$LOGNAME/scripts

mpg123 -q /home/$LOGNAME/scripts/sons/sauvegarde_incrémentale_DEBUT.mp3 

# Date de la forme année-mois-jour-timestamp
# (le timestamp %s sert si on veut faire plusieurs sauvegardes dans la même journée)
DATE=`date +%Y%m%d_%H%M%S`

# Création du répertoire temporaire
mkdir $dest/tmp
echo "===============================================================================" >> $logerreur_svg_inc
echo "ERREURS : Sauvegarde incrementale vers $dest"                                    >> $logerreur_svg_inc
echo "Backup  incrementale commence le "`date "+%d/%m/%Y a %T"`                        >> $logerreur_svg_inc
echo "===============================================================================" >> $log_svg_inc
echo "Sauvegarde incrementale vers " $dest >> $log_svg_inc
echo "Sauvegarde commencee le "`date "+%d/%m/%Y a %T"` >> $log_svg_inc
# echo "Copie de la dernière sauvegarde..."
# echo -ne "\033]0;Copie de la dernière sauvegarde\007"
# Si une sauvegarde a déjà été faite précédemment
# Procédure d'archivage de cette sauvegarde précédente
if test -d $dest/today ; then
    # Et si le fichier contenant la date de la dernière sauvegarde existe
    if test -f $dest/last_date ; then
        LASTDATE=`cat $dest/last_date`
        # Alors on fait un copie en hardlinks de la sauvegarde d'hier
        cp -al $dest/today $dest/tmp/ 2>> $logerreur_svg_inc
        # Puis on renomme la copie pour qu'elle devienne la sauvegarde d'hier
        mv $dest/tmp/today $dest/$LASTDATE
    fi
# Sinon, on crée le premier dossier
else
    mkdir $dest/today 2>> $logerreur_svg_inc
fi
rm -rf $dest/tmp
# Fin de l'archivage de la sauvegarde précédente

# On sauvegarde la date actuelle pour le prochain backup
echo $DATE > $dest/last_date

# Création de la sauvegarde du jour
# echo -ne "\033]0;Sauvegarde incrémentale\007"
rsync -ar --delete-after --files-from=svg-inc.include --exclude-from=svg-inc.exclude /home/$LOGNAME/ $dest/today/ 2>>$logerreur_svg_inc 1>>$logerreur_svg_inc

# Procédure de purge automatique des anciennes sauvegardes
INTERVAL=9
for ((i=120; i >= 4; i--)) ; do
        if test $i -eq 17 ; then
                INTERVAL=6
        fi
        if test $i -eq 7 ; then
                INTERVAL=3
        fi
     if test $((`date -d "-$i days" "+%s"` / 86400 % $INTERVAL)) -ne 0 ; then
                rm -rf $dest/`date -d "-$i days" "+%Y%m%d_"`*
        fi
done
echo "Fin de log"                                                                      >> $logerreur_svg_inc
echo "Sauvegarde terminee  le "`date "+%d/%m/%Y a %T"`                                 >> $log_svg_inc
echo "===============================================================================" >> $log_svg_inc
echo "fin de la sauvegarde incrementale"                                               >> $log_svg_inc
echo "===============================================================================" >> $log_svg_inc

mpg123 -q /home/$LOGNAME/scripts/sons/sauvegarde_incrémentale_FIN.mp3 

cat $log_svg_inc >> $1
cat $logerreur_svg_inc >> $2

