#!/bin/bash
# ============================================================================================================================
# SCRIPT GENERIQUE DE SAUVEGARDE
# Alain BACH le 08/09/2015 - http://www.alainbach.fr
# ============================================================================================================================
# Les différentes combinaisons possibles pour la sauvegarde
# L : Sauvegarde locale
# R : Sauvegarde vers Raspberry
# C : Sauvegarde vers Cloud
# V : Sauvegarde des machines virtuelles
# S : Récupérations des sites Internet
#
# D : DRY-RUN - lANCEMENT SANS AUCUNE ACTION SI CE N'EST LA CRÉATION ET L'ENVOI DE LA LOG GÉNÉRALE
# ============================================================================================================================
# EXEMPLES : L
#            LR
#            LRCVAS
# ============================================================================================================================
# REMARQUES : l'absence de paramètre lance la TOTALITE du job (equivalent à aucun paramètre)
#             Aucune importance à respecter les MAJUSCULES
#             Les différents paramètres doivent être placés concomitament dans la chaine de paramètres
# ============================================================================================================================

clear

cd /home/$LOGNAME/scripts

parametres=${1^^}

_dow="$(date +'%u')"

echo "============================================================================================================================"
echo "SCRIPT GENERIQUE DE SAUVEGARDE"
echo " "
echo "Alain BACH le 08/09/2015 - http://www.alainbach.fr"
echo "============================================================================================================================"
echo "Les différentes combinaisons possibles pour la sauvegarde"
echo "L : Sauvegarde locale"
echo "R : Sauvegarde vers Raspberry"
echo "A : Sauvegarde vers Adrive"
echo "C : Sauvegarde vers Cloud"
echo "V : Sauvegarde des machines virtuelles"
echo "S : Récupérations des sites Internet"
echo " "
echo "D : DRY-RUN - LANCEMENT SANS AUCUNE ACTION SI CE N'EST LA CRÉATION ET L'ENVOI DE LA LOG GÉNÉRALE"
echo "============================================================================================================================"
echo "EXEMPLES : L"
echo "           LR"
echo "           LRCVAS"
echo "============================================================================================================================"
echo "REMARQUES : l'absence de paramètre lance la TOTALITE du job (equivalent à aucun paramètre)"
echo "            L'ordre des paramètres n'a aucune importance"
echo " "

if [ "${1^^}" = "D" ]
then
	dr="D"
	ofFset="oui"
	echo "DRY RUN"
elif [ -z "$1" ]
then
	dr=""
	offset="oui"
	echo "Pas de DRY RUN"
else
	offset="non"
fi

if [ "$offset" != "non" ]
then
case $_dow in
	1)
		echo "Nous sommes Lundi"
		xxxx="LR"
		parametres="$xxxx $dr"
	;;
	2)
		echo "Nous sommes Mardi"
		xxxx="LR"
		parametres="$xxxx $dr"
	;;
	3)
		xxxx="LR"		
		echo "Nous sommes Mercredi"
		parametres="$xxxx $dr"
	;;
	4)
		xxxx="LRVSC"
		echo "Nous sommes jeudi"
		parametres="$xxxx $dr"
	;;
	5)
		xxxx="LR"
		echo "Nous sommes Vendredi"
		parametres="$xxxx $dr"
	;;
	6)
		xxxx="LR"
		echo "Nous sommes Samedi"
		parametres="$xxxx $dr"
	;;
	7)
		xxxx="LRVSC"
		echo "Nous sommes Dimanche"
		parametres="$xxxx $dr"
	;;
	*)
	esac
fi

mainuser=$LOGNAME
fichierlog_sauvegarde=/home/$mainuser/scripts/logs/log.log
fichierlog_erreurs=/home/$mainuser/scripts/logs/log_erreurs.log
fichierlog_mail=/home/$mainuser/scripts/logs/log_mail.log

# Destinataire du mail contenant la log de la sauvegarde
maildest=alain.bach@gmail.com

DATE_SITE=`date "+%d/%m/%Y a %T"`

rm /home/$mainuser/scripts/logs/log*.log

message1="*******************************************************************************\n
Sauvegarde de type $parametres pour $mainuser commencee a $DATE_SITE\n           
*******************************************************************************\n
 \n"
echo -e $message1
echo -e $message1 >> $fichierlog_sauvegarde
echo -e $message1 >> $fichierlog_erreurs
sleep 5

dryrun=$(echo $parametres | grep -c "D")

if [[ $dryrun -ne 0 ]]
then
	echo "*******************************************************************************" >> $fichierlog_sauvegarde
	echo "                                D R Y - R U N"                                   >> $fichierlog_sauvegarde
	echo "*******************************************************************************" >> $fichierlog_sauvegarde
	echo " "                                                                               >> $fichierlog_sauvegarde
fi

[[ -z `dpkg --get-selections | grep -w ^mpg123[^-]` ]] && sudo apt-get install mpg123 -y

mpg123 -q /home/$LOGNAME/scripts/sons/sauvegarde_générale_DEBUT.mp3

NB1=$(echo $parametres | grep -c "L")
if [[ $NB1 -eq 0 ]]
then
	echo "Pas de sauvegarde locale"
else
	echo "Lancement de la sauvegarde locale"
	if [[ $dryrun -eq 0 ]]
	then
		echo "L - Lancement de la sauvegarde locale" >>$fichierlog_sauvegarde && /home/$mainuser/scripts/svg-inc.sh $fichierlog_sauvegarde $fichierlog_erreurs $mainuser && echo " " >>$fichierlog_sauvegarde && echo "L - Fin       de la sauvegarde locale" >>$fichierlog_sauvegarde &
		pid1=$!
	fi
fi

wait $pid1

NB2=$(echo $parametres | grep -c "R")
if [[ $NB2 -eq 0 ]]
then
	echo "Pas de sauvegarde vers Raspberry"
else
	echo "Lancement de la sauvegarde vers Raspberry"
	if [[ $dryrun -eq 0 ]]
	then
		echo "R - Lancement de la sauvegarde vers Raspberry" >>$fichierlog_sauvegarde && /home/$mainuser/scripts/svg-rasp.sh $fichierlog_sauvegarde $fichierlog_erreurs $mainuser $mainuser && echo " " >>$fichierlog_sauvegarde && echo "R - Fin       de la sauvegarde vers Raspberry" >>$fichierlog_sauvegarde &
	pid2=$!
	fi
fi

NB3=$(echo $parametres | grep -c "A")
if [[ $NB3 -eq 0 ]]
then
	echo "Pas de sauvegarde vers Adrive"
else
	echo "Lancement de la sauvegarde vers Adrive"
	if [[ $dryrun -eq 0 ]]
	then
		echo "C - Lancement de la sauvegarde vers Adrive" >>$fichierlog_sauvegarde && /home/$mainuser/scripts/adrive.sh $fichierlog_sauvegarde $fichierlog_erreurs $mainuser && echo " " >>$fichierlog_sauvegarde && echo "C - Fin       de la sauvegarde vers Adrive" >>$fichierlog_sauvegarde &
		pid22=$!
	fi
fi

NB4=$(echo $parametres | grep -c "C")
if [[ $NB4 -eq 0 ]]
then
	echo "Pas de sauvegarde vers cloud"
else
	echo "Lancement de la sauvegarde vers cloud"
	if [[ $dryrun -eq 0 ]]
	then
		echo "C - Lancement de la sauvegarde vers cloud" >>$fichierlog_sauvegarde && /home/$mainuser/scripts/cloud.sh $fichierlog_sauvegarde $fichierlog_erreurs $mainuser && echo " " >>$fichierlog_sauvegarde && echo "C - Fin       de la sauvegarde vers cloud" >>$fichierlog_sauvegarde &
		pid22=$!
	fi
fi

NB5=$(echo $parametres | grep -c "V")
if [[ $NB5 -eq 0 ]]
then
	echo "Pas de sauvegarde de machines virtuelles"
else
	echo "Lancement de la sauvegarde des machines virtuelles"
	if [[ $dryrun -eq 0 ]]
	then
		echo "V - Lancement de la sauvegarde des machines virtuelles" >>$fichierlog_sauvegarde && /home/$mainuser/scripts/svg-vm.sh $fichierlog_sauvegarde $fichierlog_erreurs $mainuser && echo " " >>$fichierlog_sauvegarde && echo "V - Fin       de la sauvegarde des machines virtuelles" >>$fichierlog_sauvegarde &
	pid3=$!
	fi
fi

NB6=$(echo $parametres | grep -c "S")
if [[ $NB6 -eq 0 ]]
then
	echo "Pas de sauvegarde des sites Internet"
else
	echo "Lancement de la sauvegarde des sites Internet"
	if [[ $dryrun -eq 0 ]]
	then
		echo "S - Lancement de la sauvegarde des sites Internet" >>$fichierlog_sauvegarde && /home/$mainuser/scripts/recup_sites.sh $fichierlog_sauvegarde $fichierlog_erreurs $mainuser && echo " " >>$fichierlog_sauvegarde && echo "S - Fin       de la sauvegarde des sites Internet" >>$fichierlog_sauvegarde &
	pid4=$!
	fi
fi

# Attendre la fin de la plus lente des tâches
wait $pid2 $pid22 $pid3 $pid4

DATE_SITE=`date "+%d/%m/%Y a %T"`

message2=" \n
*******************************************************************************\n
Sauvegarde de type $parametres pour $mainuser terminee a $DATE_SITE\n
*******************************************************************************"
mpg123 -q /home/$LOGNAME/scripts/sons/sauvegarde_générale_FIN.mp3

echo -e $message2

echo "*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*" > $fichierlog_mail
echo " " >> $fichierlog_mail
echo "                  L O G  D E  L A  S A U V E G A R D E" >> $fichierlog_mail
echo " " >> $fichierlog_mail
echo "*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*" >> $fichierlog_mail
echo " " >> $fichierlog_mail
echo "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" >> $fichierlog_mail
echo "S A U V E G A R D E" >> $fichierlog_mail
echo "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" >> $fichierlog_mail
cat $fichierlog_sauvegarde >> $fichierlog_mail
echo "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" >> $fichierlog_mail
echo "E R R E U R S" >> $fichierlog_mail
echo "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" >> $fichierlog_mail
cat $fichierlog_erreurs >> $fichierlog_mail 
echo "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" >> $fichierlog_mail

# Envoi de la log générée via smtp
/home/$mainuser/scripts/sendlog.sh $fichierlog_mail $maildest
