#!/bin/bash
site-ssh()
{
	repertoirelocal=$1
	site=$2
	repertoiredistant=$3
	ainclure=$4
	aexclure=$5

	echo " " >> $6
	echo "rsync -e ssh -arz --delete-after --exclude-from=$5 $3 $1/" >> $6
	echo " " >> $7
	echo "rsync -e ssh -arz --delete-after --exclude-from=$5 $3 $1/" >> $7
	echo " "
	echo "rsync -e ssh -arz --delete-after --exclude-from=$5 $3 $1/"

	rsync -e ssh -arz --delete-after --exclude-from=$5 $3 $1/  2>>$7 1>>$6
}

recup-site() 
{
   # Fonction de recuperation des sites via lftp
   # DATE_SITE=`date +%Y%m%d_%H%M%S`

   echo "=========================================================" >> $5
   echo "Recuperation de $2 depuis $4 vers $1" >> $5
   echo "=========================================================" >> $5
   echo "Recuperation de $2 commencee a $DATE" >> $5
   echo " " >> $5
   
   echo "=========================================================" >> $6
   echo "Recuperation de $2 depuis $4 vers $1" >> $6
   echo "=========================================================" >> $6
   echo "Recuperation de $2 commencee a $DATE" >> $6
   echo " " >> $6
   
   # mkdir $1
   
   lftp ftp://$2:$3@$4 -e "mirror -e /www/ $1/ ; quit" 2>>$6 1>>$5
   
   echo "Recuperation de $2 terminee a $DATE" >> $5
}

#=========================================================================================
# Recuperer les sites Internet
# Alain BACH le 08/09/2015 - http://www.alainbach.fr
#=========================================================================================

clear

mpg123 -q /home/$LOGNAME/scripts/sons/sauvegarde_sites_DEBUT.mp3

# svgtype="lftp"
log_recup_sites="/home/$LOGNAME/scripts/logs/log_recup_sites.log"
logerreur_recup_sites="/home/$LOGNAME/scripts/logs/log_recup_sites_erreur.log"
svgtype="rsync"

DATE_SITE=`date +%Y%m%d_%H%M%S`
DATE=`date +%d%m%Y_%H%M%S`
recup_site_user=$3

listfile="/home/$LOGNAME/scripts/recup_site.list"
destracine=/home/$recup_site_user/En-cours
destracinelftp=$destracine/lftp
destracinersync=$destracine/rsync
inclure=cloud.include
exclure=cloud.exclude
timestamp=`date +%Y%m%d_%H%M%S`

DATENOW=`date '+%d/%m/%Y a %H:%M:%S'`

if test -d $destracinersync/today ; then
	echo "today existe"
	    # Et si le fichier contenant la date de la dernière sauvegarde existe
		if test -f $destracine/last_date ; then
		echo "$destracine/last_date"
		echo "$destracinersync"
			LASTDATE=`cat $destracine/last_date`
			# Alors on fait un copie en hardlinks de la sauvegarde d'hier
			cp -al $destracinersync/today $destracinersync/tmp/ >> $logerreur_recup_sites
			# Puis on renomme la copie pour qu'elle devienne la sauvegarde d'hier
			mv $destracinersync/tmp $destracinersync/$LASTDATE
		fi
	# Sinon, on crée le premier dossier
else
    mkdir $destracinersync/today >> $logerreur_recup_sites
fi

if test -d $destracinelftp/today ; then
	echo "today existe"
	    # Et si le fichier contenant la date de la dernière sauvegarde existe
		if test -f $destracine/last_date ; then
		echo "$destracine/last_date"
		echo "$destracinelftp"
			LASTDATE=`cat $destracine/last_date`
			# Alors on fait un copie en hardlinks de la sauvegarde d'hier
			cp -al $destracinelftp/today $destracinelftp/tmp/ >> $logerreur_recup_sites
			# Puis on renomme la copie pour qu'elle devienne la sauvegarde d'hier
			mv $destracinelftp/tmp $destracinelftp/$LASTDATE
		fi
	# Sinon, on crée le premier dossier
else
    mkdir $destracinerlftp/today >> $logerreur_recup_sites
fi

while IFS=";" read site identifiant password serveur_ftp protocole
	do
		echo "recup-site $site $identifiant $passord $serveur_ftp" 
		DATENOW=`date '+%d/%m/%Y a %H:%M:%S'`
		echo "Recuperation de $site en $protocole commencee le $DATENOW"
		echo "Recuperation de $site en $protocole commencee le $DATENOW" >> $log_recup_sites 		
		echo "Recuperation de $site en $protocole commencee le $DATENOW" >> $logerreur_recup_sites 
		if [ "$protocole" = "lftp" ] 
		then
			recup-site $destracinelftp/today/$site $identifiant $password $serveur_ftp/ $log_recup_site $logerreur_recup_sites $site
		else
			site-ssh $destracinersync/today/$site $site $identifiant@$serveur_ftp:www $inclure $exclure $log_recup_sites $logerreur_recup_sites
		fi
done <$listfile

echo $DATE_SITE > $destracine/last_date

DATENOW=`date '+%d/%m/%Y a %H:%M:%S'`
echo "Recuperation de $site terminee le $" >> $log_recup_sites

mpg123 -q /home/$LOGNAME/scripts/sons/sauvegarde_sites_FIN.mp3

echo "Fin de log"                                                                      >> $logerreur_recup_sites
echo "===============================================================================" >> $log_recup_sites
echo "fin de la recuperation des sites Internet"                                       >> $log_recup_sites
echo "===============================================================================" >> $log_recup_sites

cat $log_recup_sites             >> $1
cat $logerreur_recup_sites       >> $2
