#!/bin/bash
#=========================================================================================
# SAUVEGARDE VERS CLOUD SUR SITE PERSONNEL
# 
# Cette procédure s'appuie sur SSH avec clé pour éviter la saisie d'un mot de passe de connexion
#
# Alain BACH le 08/09/2015 - http://www.alainbach.fr
#=========================================================================================

cloud_user=$3
log_cloud=/home/$cloud_user/scripts/logs/log_cloud.log
logerreur_cloud=/home/$cloud_user/scripts/logs/log_cloud_erreur.log

dest=alainbac@ftp.alainbach.fr:cloud

cd /home/$cloud_user/scripts

mpg123 -q /home/$LOGNAME/scripts/sons/sauvegarde_cloud_DEBUT.mp3 

maintenant=`date "+%d/%m/%Y a %T"`
echo "===============================================================================" >> $logerreur_cloud
echo "ERREURS : Sauvegarde cloud vers $dest"                                           >> $logerreur_cloud
echo "Backup  cloud commence le $maintenant"                                           >> $logerreur_cloud
echo "===============================================================================" >> $log_cloud
echo "Sauvegarde cloud vers " $dest                                                    >> $log_cloud
echo "Backup  cloud commence le $maintenant"                                           >> $log_cloud
echo " "

rsync -e ssh -arvz --delete-after --files-from=cloud.include --exclude-from=cloud.exclude  /media/$cloud_user/1to/svg-inc/$cloud_user/today $dest 2>>$logerreur_cloud 1>>$log_cloud
maintenant=`date "+%d/%m/%Y a %T"`
echo "Fin de log"                                                                      >> $logerreur_cloud
echo "Backup adrive termine  le $maintenant"                                           >> $log_cloud
echo "===============================================================================" >> $log_cloud
echo "fin de la sauvegarde vers le cloud $dest"                                        >> $log_cloud
echo "===============================================================================" >> $log_cloud

mpg123 -q /home/$LOGNAME/scripts/sons/sauvegarde_cloud_FIN.mp3 

cat $log_cloud >> $1
cat $logerreur_cloud >> $2
