#!/bin/bash
#=========================================================================================
# SAUVEGARDE VERS CLOUD ADRIVE
#
# Alain BACH le 07/08/2015 - http://www.alainbach.fr
#=========================================================================================
echo "Sauvegarde vers adrive commencée le "`date "+%d/%m/%Y a %T"`
adrive_user=$3
log_adrive=/home/$adrive_user/scripts/logs/log_adrive.log
logerreur_adrive=/home/$adrive_user/scripts/logs/log_adrive_erreur.log

dest=alainbach@alainbach.fr@rsync.adrive.com:

cd /home/$adrive_user/scripts
maintenant=`date "+%d/%m/%Y a %T"`
message1="===============================================================================\n
ERREURS : Sauvegarde adrive vers $dest\n
Backup  adrive commence le $maintenant\n
===============================================================================\n
 "
mpg123 -q /home/$LOGNAME/scripts/sons/sauvegarde_adrive_DEBUT.mp3
echo -e $message1
echo -e $message1 >> $logerreur_adrive
echo -e $message1 >> $log_adrive

sleep 10

echo "rsync -e ssh -arz --delete-after --files-from=adrive.include --exclude-from=adrive.exclude  /media/$adrive_user/1to/svg-inc/$adrive_user/today $dest"
rsync -e ssh -arz --delete-after --files-from=adrive.include --exclude-from=adrive.exclude  /media/$adrive_user/1to/svg-inc/$adrive_user/today $dest 2>>$logerreur_adrive 1>>$log_adrive
maintenant=`date "+%d/%m/%Y a %T"`
echo "Fin de log"                                                                      >> $logerreur_adrive
echo "Backup adrive termine  le $maintenant"

message2="Backup adrive termine  le $maintenant\n
===============================================================================\n
fin de la sauvegarde vers adrive\n
==============================================================================="

mpg123 -q /home/$LOGNAME/scripts/sons/sauvegarde_adrive_FIN.mp3
echo -e $message2
echo -e $message2 >> $logerreur_adrive
echo -e $message2 >> $log_adrive
 
cat $log_adrive >> $1
cat $logerreur_adrive  >> $2

