package ui;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JMenu;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;

import ihm.Controleur;
import nf.test;

public class FenetreUI extends JFrame {

	private static final long serialVersionUID = 1L;
	/*
	 * Composants
	 */
	private JMenuBar barreMenu;

	private JMenuItem [] menuFichier;
	private JMenuItem [] menuRecherche;
	private JMenuItem [] menuParametres;  

	private Controleur controleur;
	private test test;
	
	private JTextField motcle1;
	private JTextField motcle2;
	private JTextField motcle3;
	
	private JButton boutonValider;
	
	/**
	 * Constructeur de la fenetre principale
	 */
	public FenetreUI(Controleur controleur) {
		super("Gestion de la recherche des fichiers");
		
		this.controleur = controleur;
		this.getContentPane().setBackground(Color.black);

		menuFichier = new JMenuItem[2];
		menuRecherche = new JMenuItem[2];
		menuParametres = new JMenuItem[4];
		
		initMenus();
		initComposants();
	}

	/**
	 * Cre les menus de la fentre
	 */
	private void initMenus() {    
		barreMenu = new JMenuBar();
		barreMenu.add(initMenuFichier());
		barreMenu.add(initMenuRecherche());
		barreMenu.add(initMenuParametres());    
		setJMenuBar(barreMenu);
	}

	private JMenu initMenuFichier() {
		
		JMenu menu = new JMenu("Fichier");

		menuFichier[0] = new JMenuItem("Sauvegarder Rapports");
		menuFichier[0].addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {	
				test.fenetre();		
				//setVisible(true);
			}
		});
		
		menu.add(menuFichier[0]);
		
		
		/* Quitter */
		menuFichier[1] = new JMenuItem("Quitter");
		menuFichier[1].addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.quitter();
			}
		});
		
		menu.add(menuFichier[1]);

		return menu;
	}

	private JMenu initMenuRecherche() {
		JMenu menu = new JMenu("Recherche");

		menuRecherche[0] = new JMenuItem("Recherche dans LAB");
		menuRecherche[0].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.rechercherLAB();
			}
		});
		menu.add(menuRecherche[0]);

		menuRecherche[1] = new JMenuItem("Recherche dans LAT");
		menuRecherche[1].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.rechercherLAT();
			}
		});
		menu.add(menuRecherche[1]);

		return menu;
	}

	private JMenu initMenuParametres() {
		JMenu menu = new JMenu("Paramtres");
		menuParametres[0] = new JMenuItem("Charger le dossier LAB");
		menuParametres[0].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.chargerLAB();
			}
		});
		menu.add(menuParametres[0]);

		menuParametres[1] = new JMenuItem("Charger le dossier LAT");
		menuParametres[1].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.chargerLAT();
			}
		});
		menu.add(menuParametres[1]);
		
		menuParametres[2] = new JMenuItem("Afficher le dossier actuel de recherche LAT");
		menuParametres[2].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.AfficherDossierLAT();
			}
		});
		menu.add(menuParametres[2]);
		
		menuParametres[3] = new JMenuItem("Afficher le dossier actuel de recherche LAB");
		menuParametres[3].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.AfficherDossierLAB();
			}
		});
		menu.add(menuParametres[3]);

		return menu;
	}  
	
private void initComposants(){
		
		this.setLayout(new BorderLayout());
		
		JPanel groupemotcle = new JPanel();
		
		groupemotcle.add(new JLabel("Mot cl 1 : "));
		motcle1=(new JTextField(30));
		groupemotcle.add(motcle1);
		
		
		groupemotcle.add(new JLabel("Mot cl 2 : "));
		motcle2=(new JTextField(30));
		groupemotcle.add(motcle2);
		
		groupemotcle.add(new JLabel("Mot cl 3 : "));
		motcle3=(new JTextField(30));
		groupemotcle.add(motcle3);
		
		boutonValider=new JButton ("Valider");
		groupemotcle.add(boutonValider);
		   	
		this.add(groupemotcle,BorderLayout.CENTER);	
		
		//this.setBackground(black);
		
		boutonValider.addActionListener(new ActionListener() {
	        public void actionPerformed(ActionEvent e) {
	        	System.out.println("OK");
	        	//rch1.valider();
	        }
	    });
	}



	public JTextField getMotcle1() {
		return motcle1;
	}


	public void setMotcle1(JTextField motcle1) {
		this.motcle1 = motcle1;
	}
	
	public JTextField getMotcle2() {
		return motcle2;
	}


	public void setMotcle2(JTextField motcle2) {
		this.motcle2 = motcle2;
	}
	
	public JTextField getMotcle3() {
		return motcle3;
	}


	public void setMotcle3(JTextField motcle3) {
		this.motcle1 = motcle3;
	}

	/**
	 * Rend visible la fenetre
	 */
	public void afficher() {
		setDefaultCloseOperation(javax.swing.JFrame.EXIT_ON_CLOSE);
		setSize(400, 600);
		setVisible(true);

		addWindowListener(new WindowAdapter() {
			
			@Override
			public void windowClosing(WindowEvent e) {
				controleur.saveConfigFile();
				e.getWindow().dispose();
			}
			
		});
	}  

}
