package nf;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;

import ihm.Controleur;



public class FenetreSauvegarde  extends JFrame{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Controleur controleur;
	
	private JMenuBar barreMenu;
	private JMenuItem [] menuFichier;
	private JMenuItem [] menuRecherche;
	private JMenuItem [] menuParametres; 
	
	private JTextField code_projet;
	private JTextField annee;
	private JTextField incrementation;
	
	private JButton boutonValider;
	
	public FenetreSauvegarde(Controleur controleur) {
		super("Sauvegarde des Fichiers");

		this.controleur = controleur;
		
		menuFichier = new JMenuItem[2];
		menuRecherche = new JMenuItem[2];
		menuParametres = new JMenuItem[4];

		initMenus();
		initComposants();
	}
	
	private void initMenus() {    
		barreMenu = new JMenuBar();
		barreMenu.add(initMenuFichier());
		barreMenu.add(initMenuRecherche());
		barreMenu.add(initMenuParametres());    
		setJMenuBar(barreMenu);
	}

	private JMenu initMenuFichier() {
		
		JMenu menu = new JMenu("Fichier");

		menuFichier[0] = new JMenuItem("Sauvegarder Rapports");
		menuFichier[0].addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				//fenetre1.NouvelFenetre();
			}
		});
		
		menu.add(menuFichier[0]);
		
		
		/* Quitter */
		menuFichier[1] = new JMenuItem("Quitter");
		menuFichier[1].addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.quitter();
			}
		});
		
		menu.add(menuFichier[1]);

		return menu;
	}

	private JMenu initMenuRecherche() {
		JMenu menu = new JMenu("Recherche");

		menuRecherche[0] = new JMenuItem("Recherche dans LAB");
		menuRecherche[0].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.rechercherLAB();
			}
		});
		menu.add(menuRecherche[0]);

		menuRecherche[1] = new JMenuItem("Recherche dans LAT");
		menuRecherche[1].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.rechercherLAT();
			}
		});
		menu.add(menuRecherche[1]);

		return menu;
	}

	private JMenu initMenuParametres() {
		JMenu menu = new JMenu("Paramtres");
		menuParametres[0] = new JMenuItem("Charger le dossier LAB");
		menuParametres[0].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.chargerLAB();
			}
		});
		menu.add(menuParametres[0]);

		menuParametres[1] = new JMenuItem("Charger le dossier LAT");
		menuParametres[1].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.chargerLAT();
			}
		});
		menu.add(menuParametres[1]);
		
		menuParametres[2] = new JMenuItem("Afficher le dossier actuel de recherche LAT");
		menuParametres[2].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.AfficherDossierLAT();
			}
		});
		menu.add(menuParametres[2]);
		
		menuParametres[3] = new JMenuItem("Afficher le dossier actuel de recherche LAB");
		menuParametres[3].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.AfficherDossierLAB();
			}
		});
		menu.add(menuParametres[3]);

		return menu;
	}  
	
	
private void initComposants(){
		
		this.setLayout(new BorderLayout());
		
		JPanel groupemotcle = new JPanel();
		
		groupemotcle.add(new JLabel("Code projet : "));
		code_projet=(new JTextField(10));
		groupemotcle.add(code_projet);
		
		
		groupemotcle.add(new JLabel("Anne : "));
		annee=(new JTextField(4));
		groupemotcle.add(annee);
		
		groupemotcle.add(new JLabel("Incrementation : "));
		incrementation=(new JTextField(3));
		groupemotcle.add(incrementation);
		
		boutonValider=new JButton ("Valider");
		groupemotcle.add(boutonValider);
		   	
		this.add(groupemotcle,BorderLayout.CENTER);	
		
		boutonValider.addActionListener(new ActionListener() {
	        public void actionPerformed(ActionEvent e) {
	        	//carnet.setContactModified(true);
	        	//System.out.println("OK");
	        	//rch1.valider();
	        }
	    });
	}
}
