package ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JMenu;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import ihm.Controleur;

/**
 *
 * @author IUT2
 */
public class FenetreUI extends JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/*
	 * Composants
	 */
	private JMenuBar barreMenu;

	private JMenuItem [] menuFichier;
	private JMenuItem [] menuRecherche;
	private JMenuItem [] menuParametres;  

	private Controleur controleur; 

	/**
	 * Constructeur de la fenêtre principale
	 */
	public FenetreUI(Controleur controleur) {
		super("Gestion de la recherche des fichiers");

		this.controleur = controleur;

		menuFichier = new JMenuItem[1];
		menuRecherche = new JMenuItem[2];
		menuParametres = new JMenuItem[2];

		initMenus();
	}

	/**
	 * Crée les menus de la fenêtre
	 */
	private void initMenus() {    
		barreMenu = new JMenuBar();
		barreMenu.add(initMenuFichier());
		barreMenu.add(initMenuRecherche());
		barreMenu.add(initMenuParametres());    
		setJMenuBar(barreMenu);
	}

	private JMenu initMenuFichier() {
		JMenu menu = new JMenu("Fichier");

		/* Quitter */
		menuFichier[0] = new JMenuItem("Quitter");
		menuFichier[0].addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.quitter();
			}
		});
		menu.add(menuFichier[0]);

		return menu;
	}

	private JMenu initMenuRecherche() {
		JMenu menu = new JMenu("Recherche");

		menuRecherche[0] = new JMenuItem("Recherche dans LAB");
		menuRecherche[0].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.rechercherLAB();
			}
		});
		menu.add(menuRecherche[0]);

		menuRecherche[1] = new JMenuItem("Recherche dans LAT");
		menuRecherche[1].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.rechercherLAT();
			}
		});
		menu.add(menuRecherche[1]);

		return menu;
	}

	private JMenu initMenuParametres() {
		JMenu menu = new JMenu("Paramtres");
		menuParametres[0] = new JMenuItem("Charger le dossier LAB");
		menuParametres[0].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.chargerLAB();
			}
		});
		menu.add(menuParametres[0]);

		menuParametres[1] = new JMenuItem("Charger le dossier LAT");
		menuParametres[1].addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent e) {
				controleur.chargerLAT();
			}
		});
		menu.add(menuParametres[1]);

		return menu;
	}    

	/**
	 * Rend visible la fenetre
	 */
	public void afficher() {
		setDefaultCloseOperation(javax.swing.JFrame.EXIT_ON_CLOSE);
		setSize(400, 200);
		setVisible(true);
		addWindowListener(new WindowAdapter() {
			
			@Override
			public void windowClosing(WindowEvent e) {
				controleur.saveConfigFile();
				e.getWindow().dispose();
			}
			
		});
	}  

}
