package ihm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

import javax.swing.JFileChooser;

import ui.BoiteDialogUI;
import ui.FenetreUI;

public class Controleur implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static final String CONFIG_FILE = "config";


	/*
	 * Composants
	 */

	private FenetreUI fenetre;

	private String labFolder = "";

	private String latFolder = "";

	/**
	 * Constructeur de la fenêtre principale
	 */
	private void initUI() {
		/* Fenêtre principale */
		fenetre = new FenetreUI(this);
		fenetre.afficher();
	}

	public Controleur() {
		initUI();
		loadConfigFile();
	}

	private void loadConfigFile() {
		FileInputStream fis = null;
		ObjectInputStream ois = null;            

		File file = new File(CONFIG_FILE);
		if(file.exists()) {
			try {
				fis = new FileInputStream(file);
				ois = new ObjectInputStream(fis);
				readObject(ois);
			}
			catch (Exception e) {
				// do nothing
			} finally {
				if (ois != null) { 
					try { ois.close(); }
					catch(IOException e) {}
				}

				if (fis != null) { 
					try { fis.close(); }
					catch(IOException e) {}
				}

			}
		}
	}

	public void saveConfigFile() {
		FileOutputStream fos = null;
		ObjectOutputStream oos = null;            

		File file = new File(CONFIG_FILE);
		try {
			fos = new FileOutputStream(file);
			oos = new ObjectOutputStream(fos);
			writeObject(oos);
		}
		catch (Exception e) {
			// do nothing
		} finally {
			if (oos != null) { 
				try { oos.close(); }
				catch(IOException e) {}
			}

			if (fos != null) { 
				try { fos.close(); }
				catch(IOException e) {}
			}
		}
	}

	public ArrayList<String> rechercher(String folder, String text) {
		ArrayList<String> files = new ArrayList<String>();

		return files;
	}

	/**
	 * Action créer un nouveau contact
	 */
	public void rechercherLAB() {
		System.out.println(rechercher(this.labFolder, "file"));
	}

	public void rechercherLAT() {
		System.out.println(rechercher(this.latFolder, "file"));
	}

	public File chargerDossier() {
		JFileChooser chooser = new JFileChooser(); 
		chooser.setCurrentDirectory(new java.io.File("."));
		chooser.setDialogTitle("Slectionner un dossier");
		chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		chooser.setAcceptAllFileFilterUsed(false);

		if (chooser.showOpenDialog(this.fenetre) == JFileChooser.APPROVE_OPTION) {
			return chooser.getSelectedFile();
		}
		return null;
	}

	public void chargerLAB() {
		File folder = chargerDossier();
		if(folder != null) {
			if(folder.isDirectory() && folder.exists()) {
				this.labFolder = folder.getAbsolutePath();
				String message = "Le dossier LAB a t ajout : " + this.labFolder;
				BoiteDialogUI.afficherInformation(this.fenetre, "Mise  jour des paramtres", message);
			} else {
				BoiteDialogUI.afficherErreur(this.fenetre, "Erreur lors de la mise  jour", "Le dossier est invalide");
			}
		}
	}

	public void chargerLAT() {
		File folder = chargerDossier();
		if(folder != null) {
			if(folder.isDirectory() && folder.exists()) {
				this.latFolder = folder.getAbsolutePath();
				String message = "Le dossier LAT a t ajout : " + this.latFolder;
				BoiteDialogUI.afficherInformation(this.fenetre, "Mise  jour des paramtres", message);
			} else {
				BoiteDialogUI.afficherErreur(this.fenetre, "Erreur lors de la mise  jour", "Le dossier est invalide");
			}
		}
	}

	public String getLabFolder() {
		return labFolder;
	}

	public String getLatFolder() {
		return latFolder;
	}

	private  void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
		this.labFolder = ois.readUTF() ;
		this.latFolder = ois.readUTF() ;
	}

	private  void writeObject(ObjectOutputStream oos) throws IOException {
		oos.writeUTF(this.labFolder) ;
		oos.writeUTF(this.latFolder) ;
	}

	/**
	 * Quitter l'application sans enregistrer les modifications
	 */
	public void quitter() {
		saveConfigFile();
		System.exit(0);
	}

}
