﻿Imports System
Imports System.Collections.Generic
Imports System.Diagnostics
Imports System.IO
Imports System.Text
Imports VB = Microsoft.VisualBasic

Module Program

    Sub Main()
        Const fileName = "benchmark.txt"
        If File.Exists(fileName) Then File.Delete(fileName)
        Trace.Listeners.Clear()
        Trace.Listeners.Add(New TextWriterTraceListener(fileName))
        Trace.Listeners.Add(New ConsoleTraceListener(False))
        Trace.AutoFlush = True
        Trace.WriteLine($"Is high resolution : {Stopwatch.IsHighResolution}")
        Trace.WriteLine("")

        JitWarmUp()

        For Each info In Run()
            info.Match(AddressOf Success, AddressOf Failure)
        Next
    End Sub

    Private Sub Success(desc As String, result As Object, avgTicks As Double)
        Trace.WriteLine(desc)
        Trace.Indent()
        Trace.WriteLine($"[{result}] in {avgTicks} ticks")
        Trace.Unindent()
        Trace.WriteLine("")
    End Sub

    Private Sub Failure(desc As String, ex As Exception)
        Trace.WriteLine(desc)
        Trace.Indent()
        Trace.WriteLine(ex.Message)
        Trace.Unindent()
        Trace.WriteLine("")
    End Sub

    Private Sub JitWarmUp()
#Region " Null String Test "
        EqualsNothing_NothingString(0)
        EqualsNothing_EmptyLiteral(0)
        EqualsNothing_EmptyField(0)
        EqualsNothing_VbNullString(0)

        EqualsEmptyLiteral_NothingString(0)
        EqualsEmptyLiteral_EmptyLiteral(0)
        EqualsEmptyLiteral_EmptyField(0)
        EqualsEmptyLiteral_VbNullString(0)

        EqualsEmptyField_NothingString(0)
        EqualsEmptyField_EmptyLiteral(0)
        EqualsEmptyField_EmptyField(0)
        EqualsEmptyField_VbNullString(0)

        EqualsVbNullString_NothingString(0)
        EqualsVbNullString_EmptyLiteral(0)
        EqualsVbNullString_EmptyField(0)
        EqualsVbNullString_VbNullString(0)

        Has0Len_NothingString(0)
        Has0Len_EmptyLiteral(0)
        Has0Len_EmptyField(0)
        Has0Len_VbNullString(0)

        IsNullOrEmpty_NothingString(0)
        IsNullOrEmpty_EmptyLiteral(0)
        IsNullOrEmpty_EmptyField(0)
        IsNullOrEmpty_VbNullString(0)

        Has0Length_NothingString(0)
        Has0Length_EmptyLiteral(0)
        Has0Length_EmptyField(0)
        Has0Length_VbNullString(0)

        IsNothing_NothingString(0)
        IsNothing_EmptyLiteral(0)
        IsNothing_EmptyField(0)
        IsNothing_VbNullString(0)

        IsEmptyLiteral_NothingString(0)
        IsEmptyLiteral_EmptyLiteral(0)
        IsEmptyLiteral_EmptyField(0)
        IsEmptyLiteral_VbNullString(0)

        IsEmptyField_NothingString(0)
        IsEmptyField_EmptyLiteral(0)
        IsEmptyField_EmptyField(0)
        IsEmptyField_VbNullString(0)

        IsVbNullString_NothingString(0)
        IsVbNullString_EmptyLiteral(0)
        IsVbNullString_EmptyField(0)
        IsVbNullString_VbNullString(0)
#End Region

#Region " Null String Creation "
        NothingString(0)
        EmptyLiteral(0)
        EmptyField(0)
        VbNullString(0)
#End Region

#Region " Concating "
        ConcatReassign_EmptyLiteral_EmptyLiteral(0)
        ConcatReassign_EmptyLiteral_ShortLiteral(0)
        ReassignConcat_EmptyLiteral_EmptyLiteral(0)
        ReassignConcat_EmptyLiteral_ShortLiteral(0)
        StringBuilder_EmptyLiteral_EmptyLiteral(0)
        StringBuilder_EmptyLiteral_ShortLiteral(0)
        StringBuilderCapacity_EmptyLiteral_ShortLiteral(0)
#End Region

#Region " Comparison "
        SameLength_Equal_Identic(0)
        SameLength_Equal_Different(0)
        SameLength_Compare_Identic(0)
        SameLength_Compare_Different(0)
        SameLength_CompareOrdinal_Identic(0)
        SameLength_CompareOrdinal_Different(0)
        SameLength_Equals_Identic(0)
        SameLength_Equals_Different(0)
        SameLength_EqualsOrdinal_Identic(0)
        SameLength_EqualsOrdinal_Different(0)
        SameLength_Equal_DifferentLength(0)
        SameLength_Compare_DifferentLength(0)
        SameLength_CompareOrdinal_DifferentLength(0)
        SameLength_Equals_DifferentLength(0)
        SameLength_EqualsOrdinal_DifferentLength(0)
        SameLength_UCase_Identic(0)
        SameLength_UCase_Different(0)
        SameLength_ToUpper_Identic(0)
        SameLength_ToUpper_Different(0)
        SameLength_CompareInsensitive_Identic(0)
        SameLength_CompareInsensitive_Different(0)
        SameLength_CompareOrdinalInsensitive_Identic(0)
        SameLength_CompareOrdinalInsensitive_Different(0)
        SameLength_EqualsInsensitive_Identic(0)
        SameLength_EqualsInsensitive_Different(0)
        SameLength_EqualsOrdinalInsensitive_Identic(0)
        SameLength_EqualsOrdinalInsensitive_Different(0)
        SameLength_UCase_DifferentLength(0)
        SameLength_ToUpper_DifferentLength(0)
        SameLength_CompareInsensitive_DifferentLength(0)
        SameLength_CompareOrdinalInsensitive_DifferentLength(0)
        SameLength_EqualsInsensitive_DifferentLength(0)
        SameLength_EqualsOrdinalInsensitive_DifferentLength(0)
#End Region

#Region " Operators "
        OperateReassign_Add(0)
        OperateReassign_Subtract(0)
        OperateReassign_Mult(0)
        OperateReassign_Div(0)
        OperateReassign_IntDiv(0)
        ReassignOperate_Add(0)
        ReassignOperate_Subtract(0)
        ReassignOperate_Mult(0)
        ReassignOperate_Div(0)
        ReassignOperate_IntDiv(0)
#End Region
    End Sub

    Private Iterator Function Run() As IEnumerable(Of TestInfo)
        Const largeIterations = 100000000
        Const smallIterations = 100000

#Region " Null String Test "
        Yield EqualsNothing_NothingString(largeIterations)
        Yield EqualsNothing_EmptyLiteral(largeIterations)
        Yield EqualsNothing_EmptyField(largeIterations)
        Yield EqualsNothing_VbNullString(largeIterations)

        Yield EqualsEmptyLiteral_NothingString(largeIterations)
        Yield EqualsEmptyLiteral_EmptyLiteral(largeIterations)
        Yield EqualsEmptyLiteral_EmptyField(largeIterations)
        Yield EqualsEmptyLiteral_VbNullString(largeIterations)

        Yield EqualsEmptyField_NothingString(largeIterations)
        Yield EqualsEmptyField_EmptyLiteral(largeIterations)
        Yield EqualsEmptyField_EmptyField(largeIterations)
        Yield EqualsEmptyField_VbNullString(largeIterations)

        Yield EqualsVbNullString_NothingString(largeIterations)
        Yield EqualsVbNullString_EmptyLiteral(largeIterations)
        Yield EqualsVbNullString_EmptyField(largeIterations)
        Yield EqualsVbNullString_VbNullString(largeIterations)

        Yield Has0Len_NothingString(largeIterations)
        Yield Has0Len_EmptyLiteral(largeIterations)
        Yield Has0Len_EmptyField(largeIterations)
        Yield Has0Len_VbNullString(largeIterations)

        Yield IsNullOrEmpty_NothingString(largeIterations)
        Yield IsNullOrEmpty_EmptyLiteral(largeIterations)
        Yield IsNullOrEmpty_EmptyField(largeIterations)
        Yield IsNullOrEmpty_VbNullString(largeIterations)

        Yield Has0Length_NothingString(largeIterations)
        Yield Has0Length_EmptyLiteral(largeIterations)
        Yield Has0Length_EmptyField(largeIterations)
        Yield Has0Length_VbNullString(largeIterations)

        Yield IsNothing_NothingString(largeIterations)
        Yield IsNothing_EmptyLiteral(largeIterations)
        Yield IsNothing_EmptyField(largeIterations)
        Yield IsNothing_VbNullString(largeIterations)

        Yield IsEmptyLiteral_NothingString(largeIterations)
        Yield IsEmptyLiteral_EmptyLiteral(largeIterations)
        Yield IsEmptyLiteral_EmptyField(largeIterations)
        Yield IsEmptyLiteral_VbNullString(largeIterations)

        Yield IsEmptyField_NothingString(largeIterations)
        Yield IsEmptyField_EmptyLiteral(largeIterations)
        Yield IsEmptyField_EmptyField(largeIterations)
        Yield IsEmptyField_VbNullString(largeIterations)

        Yield IsVbNullString_NothingString(largeIterations)
        Yield IsVbNullString_EmptyLiteral(largeIterations)
        Yield IsVbNullString_EmptyField(largeIterations)
        Yield IsVbNullString_VbNullString(largeIterations)
#End Region

#Region " Null String Creation "
        Yield NothingString(largeIterations)
        Yield EmptyLiteral(largeIterations)
        Yield EmptyField(largeIterations)
        Yield VbNullString(largeIterations)
#End Region

#Region " Concating "
        Yield ConcatReassign_EmptyLiteral_EmptyLiteral(smallIterations)
        Yield ConcatReassign_EmptyLiteral_ShortLiteral(smallIterations)
        Yield ReassignConcat_EmptyLiteral_EmptyLiteral(smallIterations)
        Yield ReassignConcat_EmptyLiteral_ShortLiteral(smallIterations)
        Yield StringBuilder_EmptyLiteral_EmptyLiteral(smallIterations)
        Yield StringBuilder_EmptyLiteral_ShortLiteral(smallIterations)
        Yield StringBuilderCapacity_EmptyLiteral_ShortLiteral(smallIterations)
#End Region

#Region " Comparison "
        Yield SameLength_Equal_Identic(smallIterations)
        Yield SameLength_Equal_Different(smallIterations)
        Yield SameLength_Compare_Identic(smallIterations)
        Yield SameLength_Compare_Different(smallIterations)
        Yield SameLength_CompareOrdinal_Identic(smallIterations)
        Yield SameLength_CompareOrdinal_Different(smallIterations)
        Yield SameLength_Equals_Identic(smallIterations)
        Yield SameLength_Equals_Different(smallIterations)
        Yield SameLength_EqualsOrdinal_Identic(smallIterations)
        Yield SameLength_EqualsOrdinal_Different(smallIterations)
        Yield SameLength_Equal_DifferentLength(smallIterations)
        Yield SameLength_Compare_DifferentLength(smallIterations)
        Yield SameLength_CompareOrdinal_DifferentLength(smallIterations)
        Yield SameLength_Equals_DifferentLength(smallIterations)
        Yield SameLength_EqualsOrdinal_DifferentLength(smallIterations)
        Yield SameLength_UCase_Identic(smallIterations)
        Yield SameLength_UCase_Different(smallIterations)
        Yield SameLength_ToUpper_Identic(smallIterations)
        Yield SameLength_ToUpper_Different(smallIterations)
        Yield SameLength_CompareInsensitive_Identic(smallIterations)
        Yield SameLength_CompareInsensitive_Different(smallIterations)
        Yield SameLength_CompareOrdinalInsensitive_Identic(smallIterations)
        Yield SameLength_CompareOrdinalInsensitive_Different(smallIterations)
        Yield SameLength_EqualsInsensitive_Identic(smallIterations)
        Yield SameLength_EqualsInsensitive_Different(smallIterations)
        Yield SameLength_EqualsOrdinalInsensitive_Identic(smallIterations)
        Yield SameLength_EqualsOrdinalInsensitive_Different(smallIterations)
        Yield SameLength_UCase_DifferentLength(smallIterations)
        Yield SameLength_ToUpper_DifferentLength(smallIterations)
        Yield SameLength_CompareInsensitive_DifferentLength(smallIterations)
        Yield SameLength_CompareOrdinalInsensitive_DifferentLength(smallIterations)
        Yield SameLength_EqualsInsensitive_DifferentLength(smallIterations)
        Yield SameLength_EqualsOrdinalInsensitive_DifferentLength(smallIterations)
#End Region

#Region " Operators "
        Yield OperateReassign_Add(largeIterations)
        Yield OperateReassign_Subtract(largeIterations)
        Yield OperateReassign_Mult(largeIterations)
        Yield OperateReassign_Div(largeIterations)
        Yield OperateReassign_IntDiv(largeIterations)
        Yield ReassignOperate_Add(largeIterations)
        Yield ReassignOperate_Subtract(largeIterations)
        Yield ReassignOperate_Mult(largeIterations)
        Yield ReassignOperate_Div(largeIterations)
        Yield ReassignOperate_IntDiv(largeIterations)
#End Region
    End Function

#Region " Null String Test "
#Region " = Nothing "
    Private Function EqualsNothing_NothingString(iterations As Integer) As TestInfo
        Const description = "str = Nothing (str <- Nothing)"

        Dim str As String = Nothing, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = Nothing
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function EqualsNothing_EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "str = Nothing (str <- """")"

        Dim str = "", actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = Nothing
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function EqualsNothing_EmptyField(iterations As Integer) As TestInfo
        Const description = "str = Nothing (str <- String.Empty)"

        Dim str = String.Empty, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = Nothing
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function EqualsNothing_VbNullString(iterations As Integer) As TestInfo
        Const description = "str = Nothing (str <- vbNullString)"

        Dim str = VB.vbNullString, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = Nothing
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " = "" "
    Private Function EqualsEmptyLiteral_NothingString(iterations As Integer) As TestInfo
        Const description = "str = """" (str <- Nothing)"

        Dim str As String = Nothing, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = ""
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function EqualsEmptyLiteral_EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "str = """" (str <- """")"

        Dim str = "", actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = ""
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function EqualsEmptyLiteral_EmptyField(iterations As Integer) As TestInfo
        Const description = "str = """" (str <- String.Empty)"

        Dim str = String.Empty, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = ""
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function EqualsEmptyLiteral_VbNullString(iterations As Integer) As TestInfo
        Const description = "str = """" (str <- vbNullString)"

        Dim str = VB.vbNullString, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = ""
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " = String.Empty "
    Private Function EqualsEmptyField_NothingString(iterations As Integer) As TestInfo
        Const description = "str = String.Empty (str <- Nothing)"

        Dim str As String = Nothing, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = String.Empty
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function EqualsEmptyField_EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "str = String.Empty (str <- "")"

        Dim str = "", actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = String.Empty
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function EqualsEmptyField_EmptyField(iterations As Integer) As TestInfo
        Const description = "str = String.Empty (str <- String.Empty)"

        Dim str = String.Empty, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = String.Empty
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function EqualsEmptyField_VbNullString(iterations As Integer) As TestInfo
        Const description = "str = String.Empty (str <- vbNullString)"

        Dim str = VB.vbNullString, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = String.Empty
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " = vbNullString "
    Private Function EqualsVbNullString_NothingString(iterations As Integer) As TestInfo
        Const description = "str = vbNullString (str <- Nothing)"

        Dim str As String = Nothing, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = VB.vbNullString
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function EqualsVbNullString_EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "str = vbNullString (str <- """")"

        Dim str = "", actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = VB.vbNullString
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function EqualsVbNullString_EmptyField(iterations As Integer) As TestInfo
        Const description = "str = vbNullString (str <- String.Empty)"

        Dim str = String.Empty, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = VB.vbNullString
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function EqualsVbNullString_VbNullString(iterations As Integer) As TestInfo
        Const description = "str = vbNullString (str <- vbNullString)"

        Dim str = VB.vbNullString, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str = VB.vbNullString
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " Len = 0 "
    Private Function Has0Len_NothingString(iterations As Integer) As TestInfo
        Const description = "Len(str) = 0 (str <- Nothing)"

        Dim str As String = Nothing, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = VB.Len(str) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function Has0Len_EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "Len(str) = 0 (str <- """")"

        Dim str = "", actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = VB.Len(str) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function Has0Len_EmptyField(iterations As Integer) As TestInfo
        Const description = "Len(str) = 0 (str <- String.Empty)"

        Dim str = String.Empty, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = VB.Len(str) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function Has0Len_VbNullString(iterations As Integer) As TestInfo
        Const description = "Len(str) = 0 (str <- vbNullString)"

        Dim str = VB.vbNullString, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = VB.Len(str) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " String.IsNullOrEmpty "
    Private Function IsNullOrEmpty_NothingString(iterations As Integer) As TestInfo
        Const description = "String.IsNullOrEmpty(str) (str <- Nothing)"

        Dim str As String = Nothing, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.IsNullOrEmpty(str)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsNullOrEmpty_EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "String.IsNullOrEmpty(str) (str <- """")"

        Dim str = "", actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.IsNullOrEmpty(str)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsNullOrEmpty_EmptyField(iterations As Integer) As TestInfo
        Const description = "String.IsNullOrEmpty(str) (str <- String.Empty)"

        Dim str = String.Empty, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.IsNullOrEmpty(str)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsNullOrEmpty_VbNullString(iterations As Integer) As TestInfo
        Const description = "String.IsNullOrEmpty(str) (str <- vbNullString)"

        Dim str = VB.vbNullString, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.IsNullOrEmpty(str)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " .Length = 0 "
    Private Function Has0Length_NothingString(iterations As Integer) As TestInfo
        Const description = "str.Length = 0 (str <- Nothing)"

        Dim str As String = Nothing, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str.Length = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function Has0Length_EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "str.Length = 0 (str <- """")"

        Dim str = "", actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str.Length = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function Has0Length_EmptyField(iterations As Integer) As TestInfo
        Const description = "str.Length = 0 (str <- String.Empty)"

        Dim str = String.Empty, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str.Length = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function Has0Length_VbNullString(iterations As Integer) As TestInfo
        Const description = "str.Length = 0 (str <- vbNullString)"

        Dim str = VB.vbNullString, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str.Length = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " Is Nothing (IsNothing) "
    Private Function IsNothing_NothingString(iterations As Integer) As TestInfo
        Const description = "str Is Nothing (str <- Nothing)"

        Dim str As String = Nothing, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is Nothing
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsNothing_EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "str Is Nothing (str <- """")"

        Dim str = "", actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is Nothing
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsNothing_EmptyField(iterations As Integer) As TestInfo
        Const description = "str Is Nothing (str <- String.Empty)"

        Dim str = String.Empty, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is Nothing
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsNothing_VbNullString(iterations As Integer) As TestInfo
        Const description = "str Is Nothing (str <- vbNullString)"

        Dim str = VB.vbNullString, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is Nothing
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " Is "" "
    Private Function IsEmptyLiteral_NothingString(iterations As Integer) As TestInfo
        Const description = "str Is "" (str <- Nothing)"

        Dim str As String = Nothing, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is ""
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsEmptyLiteral_EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "str Is """" (str <- """")"

        Dim str = "", actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is ""
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsEmptyLiteral_EmptyField(iterations As Integer) As TestInfo
        Const description = "str Is """" (str <- String.Empty)"

        Dim str = String.Empty, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is ""
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsEmptyLiteral_VbNullString(iterations As Integer) As TestInfo
        Const description = "str Is """" (str <- vbNullString)"

        Dim str = VB.vbNullString, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is ""
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " Is String.Empty "
    Private Function IsEmptyField_NothingString(iterations As Integer) As TestInfo
        Const description = "str Is String.Empty (str <- Nothing)"

        Dim str As String = Nothing, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is String.Empty
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsEmptyField_EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "str Is String.Empty (str <- """")"

        Dim str = "", actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is String.Empty
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsEmptyField_EmptyField(iterations As Integer) As TestInfo
        Const description = "str Is String.Empty (str <- String.Empty)"

        Dim str = String.Empty, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is String.Empty
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsEmptyField_VbNullString(iterations As Integer) As TestInfo
        Const description = "str Is String.Empty (str <- vbNullString)"

        Dim str = VB.vbNullString, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is String.Empty
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " Is vbNullString "
    Private Function IsVbNullString_NothingString(iterations As Integer) As TestInfo
        Const description = "str Is vbNullString (str <- Nothing)"

        Dim str As String = Nothing, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is VB.vbNullString
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsVbNullString_EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "str Is vbNullString (str <- """")"

        Dim str = "", actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is VB.vbNullString
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsVbNullString_EmptyField(iterations As Integer) As TestInfo
        Const description = "str Is vbNullString (str <- String.Empty)"

        Dim str = String.Empty, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is VB.vbNullString
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function IsVbNullString_VbNullString(iterations As Integer) As TestInfo
        Const description = "str Is vbNullString (str <- vbNullString)"

        Dim str = VB.vbNullString, actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str Is VB.vbNullString
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region
#End Region

#Region " Null String Creation "
    Private Function NothingString(iterations As Integer) As TestInfo
        Const description = "str = Nothing"

        Dim str As String = Nothing

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                str = Nothing
            Next
            chrono.Stop()

            Return TestInfo.Success(description, str, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "str = """""

        Dim str As String = Nothing

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                str = ""
            Next
            chrono.Stop()

            Return TestInfo.Success(description, str, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function EmptyField(iterations As Integer) As TestInfo
        Const description = "str = String.Empty"

        Dim str As String = Nothing

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                str = String.Empty
            Next
            chrono.Stop()

            Return TestInfo.Success(description, str, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function VbNullString(iterations As Integer) As TestInfo
        Const description = "str = vbNullString"

        Dim str As String = Nothing

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                str = VB.vbNullString
            Next
            chrono.Stop()

            Return TestInfo.Success(description, str, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " Concating "
#Region " Concat Reassign (= &) "
    Private Function ConcatReassign_EmptyLiteral_EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "str = str & """""

        Dim str = ""

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                str = str & ""
            Next
            chrono.Stop()

            Return TestInfo.Success(description, str, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function ConcatReassign_EmptyLiteral_ShortLiteral(iterations As Integer) As TestInfo
        Const description = "str = str & ""."""

        Dim str = ""

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                str = str & "."
            Next
            chrono.Stop()

            Return TestInfo.Success(description, "...(...)...", chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " Reassign Concat (&=) "
    Private Function ReassignConcat_EmptyLiteral_EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "str &= """""

        Dim str = ""

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                str &= ""
            Next
            chrono.Stop()

            Return TestInfo.Success(description, str, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function ReassignConcat_EmptyLiteral_ShortLiteral(iterations As Integer) As TestInfo
        Const description = "str &= ""."""

        Dim str = ""

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                str &= "."
            Next
            chrono.Stop()

            Return TestInfo.Success(description, "...(...)...", chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " StringBuilder "
    Private Function StringBuilder_EmptyLiteral_EmptyLiteral(iterations As Integer) As TestInfo
        Const description = "builder.Append("""")"

        Dim builder As New StringBuilder

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                builder.Append("")
            Next
            chrono.Stop()

            Return TestInfo.Success(description, builder.ToString, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function StringBuilder_EmptyLiteral_ShortLiteral(iterations As Integer) As TestInfo
        Const description = "builder.Append(""."")"

        Dim builder As New StringBuilder

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                builder.Append(".")
            Next
            chrono.Stop()

            Return TestInfo.Success(description, "...(...)...", chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function StringBuilderCapacity_EmptyLiteral_ShortLiteral(iterations As Integer) As TestInfo
        Const description = "builder.Append(""."") (with capacity)"

        Dim builder As New StringBuilder(iterations)

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                builder.Append(".")
            Next
            chrono.Stop()

            Return TestInfo.Success(description, "...(...)...", chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region
#End Region

#Region " Comparison "
#Region " Case Sensitive "
#Region " Same Length "
    Private Function SameLength_Equal_Identic(iterations As Integer) As TestInfo
        Const description = "str1 = str2 (identic strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str1 = str2
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_Equal_Different(iterations As Integer) As TestInfo
        Const description = "str1 = str2 (different strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat!",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str1 = str2
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_Compare_Identic(iterations As Integer) As TestInfo
        Const description = "String.Compare(str1, str2) = 0 (identic strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Compare(str1, str2) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_Compare_Different(iterations As Integer) As TestInfo
        Const description = "String.Compare(str1, str2) = 0 (different strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat!",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Compare(str1, str2) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_CompareOrdinal_Identic(iterations As Integer) As TestInfo
        Const description = "String.CompareOrdinal(str1, str2) = 0 (identic strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.CompareOrdinal(str1, str2) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_CompareOrdinal_Different(iterations As Integer) As TestInfo
        Const description = "String.CompareOrdinal(str1, str2) = 0 (different strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat!",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.CompareOrdinal(str1, str2) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_Equals_Identic(iterations As Integer) As TestInfo
        Const description = "String.Equals(str1, str2) (identic strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Equals(str1, str2)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_Equals_Different(iterations As Integer) As TestInfo
        Const description = "String.Equals(str1, str2) (different strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat!",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Equals(str1, str2)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_EqualsOrdinal_Identic(iterations As Integer) As TestInfo
        Const description = "String.Equals(str1, str2, StringComparison.Ordinal) (identic strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Equals(str1, str2, StringComparison.Ordinal)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_EqualsOrdinal_Different(iterations As Integer) As TestInfo
        Const description = "String.Equals(str1, str2, StringComparison.Ordinal) (different strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat!",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Equals(str1, str2, StringComparison.Ordinal)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " Different Length "
    Private Function SameLength_Equal_DifferentLength(iterations As Integer) As TestInfo
        Const description = "str1 = str2 (different length strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat...",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str1 = str2
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_Compare_DifferentLength(iterations As Integer) As TestInfo
        Const description = "String.Compare(str1, str2) = 0 (different length strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat...",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Compare(str1, str2) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_CompareOrdinal_DifferentLength(iterations As Integer) As TestInfo
        Const description = "String.CompareOrdinal(str1, str2) = 0 (different length strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat...",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.CompareOrdinal(str1, str2) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_Equals_DifferentLength(iterations As Integer) As TestInfo
        Const description = "String.Equals(str1, str2) (different length strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat...",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Equals(str1, str2)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_EqualsOrdinal_DifferentLength(iterations As Integer) As TestInfo
        Const description = "String.Equals(str1, str2, StringComparison.Ordinal) (different length strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat...",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Equals(str1, str2, StringComparison.Ordinal)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region
#End Region

#Region " Case Insensitive "
#Region " Same Length "
    Private Function SameLength_UCase_Identic(iterations As Integer) As TestInfo
        Const description = "UCase(str1) = UCase(str2) (identic strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = VB.UCase(str1) = VB.UCase(str2)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_UCase_Different(iterations As Integer) As TestInfo
        Const description = "UCase(str1) = UCase(str2) (different strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat!",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = VB.UCase(str1) = VB.UCase(str2)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_ToUpper_Identic(iterations As Integer) As TestInfo
        Const description = "str1.ToUpper = str2.ToUpper (identic strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str1.ToUpper = str2.ToUpper
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_ToUpper_Different(iterations As Integer) As TestInfo
        Const description = "str1.ToUpper = str2.ToUpper (different strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat!",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str1.ToUpper = str2.ToUpper
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_CompareInsensitive_Identic(iterations As Integer) As TestInfo
        Const description = "String.Compare(str1, str2, True) = 0 (identic strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Compare(str1, str2, True) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_CompareInsensitive_Different(iterations As Integer) As TestInfo
        Const description = "String.Compare(str1, str2, True) = 0 (different strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat!",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Compare(str1, str2, True) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_CompareOrdinalInsensitive_Identic(iterations As Integer) As TestInfo
        Const description = "String.Compare(str1, str2, StringComparison.OrdinalIgnoreCase) = 0 (identic strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Compare(str1, str2, StringComparison.OrdinalIgnoreCase) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_CompareOrdinalInsensitive_Different(iterations As Integer) As TestInfo
        Const description = "String.Compare(str1, str2, StringComparison.OrdinalIgnoreCase) = 0 (different strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat!",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Compare(str1, str2, StringComparison.OrdinalIgnoreCase) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_EqualsInsensitive_Identic(iterations As Integer) As TestInfo
        Const description = "String.Equals(str1, str2, StringComparison.CurrentCultureIgnoreCase) (identic strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Equals(str1, str2, StringComparison.CurrentCultureIgnoreCase)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_EqualsInsensitive_Different(iterations As Integer) As TestInfo
        Const description = "String.Equals(str1, str2, StringComparison.CurrentCultureIgnoreCase) (different strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat!",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Equals(str1, str2, StringComparison.CurrentCultureIgnoreCase)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_EqualsOrdinalInsensitive_Identic(iterations As Integer) As TestInfo
        Const description = "String.Equals(str1, str2, StringComparison.OrdinalIgnoreCase) (identic strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Equals(str1, str2, StringComparison.OrdinalIgnoreCase)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_EqualsOrdinalInsensitive_Different(iterations As Integer) As TestInfo
        Const description = "String.Equals(str1, str2, StringComparison.OrdinalIgnoreCase) (different strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat!",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Equals(str1, str2, StringComparison.OrdinalIgnoreCase)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " Different Length "
    Private Function SameLength_UCase_DifferentLength(iterations As Integer) As TestInfo
        Const description = "UCase(str1) = UCase(str2) (different length strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat...",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = VB.UCase(str1) = VB.UCase(str2)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_ToUpper_DifferentLength(iterations As Integer) As TestInfo
        Const description = "str1.ToUpper = str2.ToUpper (different length strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat...",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = str1.ToUpper = str2.ToUpper
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_CompareInsensitive_DifferentLength(iterations As Integer) As TestInfo
        Const description = "String.Compare(str1, str2, True) = 0 (different length strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat...",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Compare(str1, str2, True) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_CompareOrdinalInsensitive_DifferentLength(iterations As Integer) As TestInfo
        Const description = "String.Compare(str1, str2, StringComparison.OrdinalIgnoreCase) = 0 (different length strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat...",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Compare(str1, str2, StringComparison.OrdinalIgnoreCase) = 0
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_EqualsInsensitive_DifferentLength(iterations As Integer) As TestInfo
        Const description = "String.Equals(str1, str2, StringComparison.CurrentCultureIgnoreCase) (different length strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat...",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Equals(str1, str2, StringComparison.CurrentCultureIgnoreCase)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function SameLength_EqualsOrdinalInsensitive_DifferentLength(iterations As Integer) As TestInfo
        Const description = "String.Equals(str1, str2, StringComparison.OrdinalIgnoreCase) (different length strings)"

        Dim str1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat.",
            str2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent bibendum sem id nunc varius, eget dignissim mi tempor. Ut justo magna, porttitor a justo ut, mollis cursus leo. Pellentesque id euismod urna. In justo nisl, pellentesque ut metus sed, pellentesque tincidunt augue. Nulla suscipit maximus purus, ut bibendum tortor mollis sit amet. Nulla neque est, lacinia eget tincidunt venenatis, fermentum vel ligula. Nullam aliquet, elit at vehicula mollis, elit lorem viverra ante, sit amet commodo diam lectus vel ante. Aliquam mollis pharetra risus, quis pharetra ipsum. Sed tincidunt convallis felis sit amet congue. Phasellus posuere diam sit amet tempor varius. Sed id euismod ante. Nam ac lacus metus. Donec ac turpis non enim molestie feugiat. Donec lobortis tristique leo, a sollicitudin nunc vehicula at. Morbi rutrum purus sapien, eget commodo metus gravida quis. Donec rhoncus vulputate nisi vitae porttitor. Curabitur eleifend lacinia efficitur. Vivamus in lobortis elit, eget volutpat...",
            actual As Boolean

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                actual = String.Equals(str1, str2, StringComparison.OrdinalIgnoreCase)
            Next
            chrono.Stop()

            Return TestInfo.Success(description, actual, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region
#End Region
#End Region

#Region " Operators "
#Region " Operate Reassign (= + ; = -; = *; = /; = \) "
    Private Function OperateReassign_Add(iterations As Integer) As TestInfo
        Const description = "n = n + 7"

        Dim n = 0

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                n = n + 7
            Next
            chrono.Stop()

            Return TestInfo.Success(description, n, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function OperateReassign_Subtract(iterations As Integer) As TestInfo
        Const description = "n = n - 7"

        Dim n = 0

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                n = n - 7
            Next
            chrono.Stop()

            Return TestInfo.Success(description, n, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function OperateReassign_Mult(iterations As Integer) As TestInfo
        Const description = "n = n * 7"

        Dim n = 1

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                n = n * 7
            Next
            chrono.Stop()

            Return TestInfo.Success(description, n, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function OperateReassign_Div(iterations As Integer) As TestInfo
        Const description = "d = d / 7"

        Dim d = 1.0

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                d = d / 7
            Next
            chrono.Stop()

            Return TestInfo.Success(description, d, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function OperateReassign_IntDiv(iterations As Integer) As TestInfo
        Const description = "n = n \ 7"

        Dim n = 1

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                n = n \ 7
            Next
            chrono.Stop()

            Return TestInfo.Success(description, n, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region

#Region " Reassign Operate (+= ; -=; *=; /=; \=) "
    Private Function ReassignOperate_Add(iterations As Integer) As TestInfo
        Const description = "n += 7"

        Dim n = 0

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                n += 7
            Next
            chrono.Stop()

            Return TestInfo.Success(description, n, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function ReassignOperate_Subtract(iterations As Integer) As TestInfo
        Const description = "n -= 7"

        Dim n = 0

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                n -= 7
            Next
            chrono.Stop()

            Return TestInfo.Success(description, n, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function ReassignOperate_Mult(iterations As Integer) As TestInfo
        Const description = "n *= 7"

        Dim n = 1

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                n *= 7
            Next
            chrono.Stop()

            Return TestInfo.Success(description, n, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function ReassignOperate_Div(iterations As Integer) As TestInfo
        Const description = "d /= 7"

        Dim d = 1.0

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                d /= 7
            Next
            chrono.Stop()

            Return TestInfo.Success(description, d, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function

    Private Function ReassignOperate_IntDiv(iterations As Integer) As TestInfo
        Const description = "n \= 7"

        Dim n = 1

        GC.Collect(GC.MaxGeneration, GCCollectionMode.Forced, True, True)

        Try
            Dim chrono = Stopwatch.StartNew
            For i = 1 To iterations
                n \= 7
            Next
            chrono.Stop()

            Return TestInfo.Success(description, n, chrono.ElapsedTicks / iterations)
        Catch ex As Exception
            Return TestInfo.Failure(description, ex)
        End Try
    End Function
#End Region
#End Region

End Module

#Region " TestInfo "
MustInherit Class TestInfo
    ReadOnly description As String

    Private Sub New(description As String)
        Me.description = description
    End Sub

    Shared Function Success(description As String, result As Object, averageTicks As Double) As TestInfo
        Return New TestSuccess(description, result, averageTicks)
    End Function

    Shared Function Failure(description As String, exception As Exception) As TestInfo
        Return New TestFailure(description, exception)
    End Function

    MustOverride Sub Match(success As Action(Of String, Object, Double), failure As Action(Of String, Exception))

    Private NotInheritable Class TestSuccess
        Inherits TestInfo

        ReadOnly result As Object
        ReadOnly averageTicks As Double

        Sub New(description As String, result As Object, averageTicks As Double)
            MyBase.New(description)
            Me.result = result
            Me.averageTicks = averageTicks
        End Sub

        Overrides Sub Match(success As Action(Of String, Object, Double), failure As Action(Of String, Exception))
            success(description, result, averageTicks)
        End Sub
    End Class

    Private Class TestFailure
        Inherits TestInfo

        ReadOnly exception As Exception

        Sub New(description As String, exception As Exception)
            MyBase.New(description)
            Me.exception = exception
        End Sub

        Overrides Sub Match(success As Action(Of String, Object, Double), failure As Action(Of String, Exception))
            failure(description, exception)
        End Sub
    End Class
End Class
#End Region
