#!/usr/bin/python3
# -*- coding: utf-8 -*-

 # Chercher plus d'info sur la commande unicode

from PyQt4 import QtGui, QtCore
import sys
import random

import PyTestsUI


class PyTests(QtGui.QMainWindow, PyTestsUI.Ui_MainWindow):
    def __init__(self, parent=None):
        super(PyTests, self).__init__(parent)
        self.setupUi(self) # Lance la fonction defenissant tous les widgets du fichier UI
        self.connectActions() # Lance la fonction faisant les connexions
        size_ecran = QtGui.QDesktopWidget().screenGeometry() # Taille de l'ecran
        size_fenetre = self.geometry() # Taille de la fenetre
        self.move((size_ecran.width()-size_fenetre.width())/2, (size_ecran.height()-size_fenetre.height())/2) # Place la fenetre en fonction de sa taille et de la taille de l'ecran

        self.model = QtGui.QStandardItemModel()
        item1 = QtGui.QStandardItem("Vidéos")
        item1.appendRow(QtGui.QStandardItem("Angle superieur"))
        item1.appendRow(QtGui.QStandardItem("Angle inferieur"))
        item2 = QtGui.QStandardItem("Audio")
        item2.appendRow(QtGui.QStandardItem("AC3 FR"))
        item2.appendRow(QtGui.QStandardItem("DTS ENG"))

        self.model.appendRow(item1)
        self.model.appendRow(item2)

        self.model.setItem(0, 1, QtGui.QStandardItem(u"Case 0.1 !"))
        self.model.setItem(1, 1, QtGui.QStandardItem(u"Case 1.1"))

        self.ex_treeView.setModel(self.model)
        self.ex_tableView.setModel(self.model)

    def testMode(self):
        selection = self.ex_listView.selectionModel()
        listeSelection = selection.selectedIndexes()
        liste = []
        for element in listeSelection:
            liste += [element.data()]
        QtGui.QMessageBox.information(self, u"Elément sélectionné", '<br>'.join(liste))
        print("Voici les selections :", liste)

    def connectActions(self): # Connections des widgets
        ## Exemple de boite à liste ###
        self.ex_comboBox.activated["QString"].connect(self.liste_1)
        #self.ex_comboBox.activated[int].connect(self.liste_1)
        #self.ex_listWidget.currentTextChanged.connect(self.liste_2)
        self.ex_liste_butt1.clicked.connect(self.liste_3)
        self.ex_liste_butt2.clicked.connect(self.liste_4)
        self.ex_liste_butt3.clicked.connect(self.liste_5)
        self.ex_liste_butt4.clicked.connect(self.liste_6)
        #self.ex_liste_butt5.clicked.connect(self.liste_7)
        self.ex_liste_butt6.clicked.connect(self.liste_8)
        ## Exemple de boite à liste ###

        ### Exemples de boites temporels ###
        self.ex_dateEdit.dateChanged.connect(self.date_1)
        self.ex_dateTimeEdit.dateChanged.connect(self.date_2)
        self.ex_dateTimeEdit.timeChanged.connect(self.date_3)
        self.ex_timeEdit.timeChanged.connect(self.date_4)
        self.ex_calendarWidget.clicked.connect(self.date_5)
        self.ex_temps_butt1.clicked.connect(self.date_6)
        ### Exemples de boites temporels ###

        ### Exemples de boites à chiffres ###
        self.ex_dial.valueChanged.connect(self.chiffres_1)
        self.ex_doubleSpinBox.valueChanged.connect(self.chiffres_2)
        self.ex_spinBox.valueChanged.connect(self.chiffres_3)
        self.ex_horizontalSlider.valueChanged.connect(self.chiffres_4)
        self.ex_verticalSlider.valueChanged.connect(self.chiffres_5)
        self.ex_chiffres_butt1.clicked.connect(self.chiffres_6)
        self.ex_chiffres_butt2.clicked.connect(self.chiffres_7)
        ### Exemples de boites à chiffres ###

        ### Exemple de la boite d'entrée de texte ###
        self.ex_lineEdit_butt1.clicked.connect(self.lineEdit_butt1)
        self.ex_lineEdit_butt2.clicked.connect(self.lineEdit_butt2)
        self.ex_lineEdit_butt3.clicked.connect(self.lineEdit_butt3)
        self.ex_lineEdit_butt4.clicked.connect(self.lineEdit_butt4)
        self.ex_lineEdit_butt5.clicked.connect(self.lineEdit_butt5)
        self.ex_lineEdit_butt6.clicked.connect(self.lineEdit_butt6)
        self.ex_lineEdit_butt7.clicked.connect(self.lineEdit_butt7)
        ### Exemple de la boite d'entrée de texte ###

        ### Exemple de boites de texte ###
        self.ex_textedit_butt1.clicked.connect(self.textedit_butt1)
        self.ex_textedit_butt2.clicked.connect(self.textedit_butt2)
        self.ex_textedit_butt3.clicked.connect(self.textedit_butt3)
        self.ex_textedit_butt4.clicked.connect(self.textedit_butt4)
        self.ex_textedit_butt5.clicked.connect(self.textedit_butt5)
        self.ex_textedit_butt6.clicked.connect(self.textedit_butt6)
        self.ex_textedit_butt7.clicked.connect(self.textedit_butt7)
        self.ex_textedit_butt8.clicked.connect(self.textedit_butt8)
        self.ex_textedit_butt9.clicked.connect(self.textedit_butt9)
        self.ex_textedit_butt11.clicked.connect(self.textedit_butt11)
        self.ex_textedit_butt12.clicked.connect(self.textedit_butt12)
        self.ex_textedit_butt13.clicked.connect(self.textedit_butt13)
        self.ex_textedit_butt14.clicked.connect(self.textedit_butt14)
        self.ex_textedit_butt15.clicked.connect(self.textedit_butt15)
        self.ex_textedit_butt16.clicked.connect(self.textedit_butt16)
        self.ex_textedit_butt17.clicked.connect(self.textedit_butt17)
        self.ex_textedit_butt18.clicked.connect(self.textedit_butt18)
        self.ex_textedit_butt20.clicked.connect(self.textedit_butt20)
        self.ex_textedit_butt21.clicked.connect(self.textedit_butt21)
        ### Exemple de boites de texte ###

        ### Exemple de boutons ###
        self.ex_boutton_butt1.clicked.connect(self.boutton_butt1)
        self.ex_boutton_butt2.clicked.connect(self.boutton_butt2)
        self.buttonBox.clicked.connect(self.buttonBoxDef)
        self.buttonBox.accepted.connect(self.buttonBoxDef2)
        self.buttonBox.rejected.connect(self.buttonBoxDef3)
        self.buttonBox.helpRequested.connect(self.buttonBoxDef4)
        ### Exemple de boutons ###

    ## Exemple de boite à liste ###
    def liste_1(self, valeur):
        if type(valeur) == str:
            nb = self.ex_comboBox.count()
            ligne = self.ex_comboBox.currentIndex()
            self.statusbar.showMessage("Séléction de {}, ligne {} sur {}.".format(valeur, ligne, nb), 5000)

        elif type(valeur) == int:
            print("Séléction de l'index :",valeur)

    def liste_2(self, valeur):
        nb = self.ex_listWidget.count()
        ligne = self.ex_listWidget.currentRow()
        self.statusbar.showMessage("Séléction de {}, ligne {} sur {}.".format(valeur, ligne, nb), 5000)

    def liste_3(self):
        """Fonction nettoyant les widgets."""
        self.ex_comboBox.clear()
        self.ex_listWidget.clear()
        self.ex_treeWidget.clear()

    def liste_4(self):
        """Fonction ajoutant plusieurs lignes avec icone."""
        # Liste des icones à utiliser
        icons = [QtGui.QIcon.fromTheme("text-speak"), QtGui.QIcon.fromTheme("edit-bomb"), QtGui.QIcon.fromTheme("document-decrypt"), QtGui.QIcon.fromTheme("document-encrypt")]

        # Manipulation de la combobox : Ajout direct de l'icon et du texte
        self.ex_comboBox.addItem(icons[0], "Je suis le grand frere d'ordiMini !")
        self.ex_comboBox.addItem(icons[1], "Je suis sur le point d'exploser &@#%!")

        # Manipulation de la combobox : Ajout du texte puis modification des items
        self.ex_comboBox.addItems(["Ohhh comme c'est mignon", "Et ca ! si c'est pas adorable !"]) # Ajout des textes
        idx = self.ex_comboBox.count() # Récupération du nombre d'item -1 (car l'index commence à 1)
        self.ex_comboBox.setItemIcon(idx - 2, icons[2]) # Ajout de l'icone
        self.ex_comboBox.setItemIcon(idx - 1, icons[3]) # Ajout de l'icone

        # Manipulation de la liste : jout du texte puis modification des items
        self.ex_listWidget.addItems(["Je suis le grand frere d'ordiMini !", "Je suis sur le point d'exploser &@#%!"]) # Textes sans icones
        idx = self.ex_listWidget.count() # Récupération du nombre d'item (l'index commence à 1 et non a 0)
        item = self.ex_listWidget.item(idx - 2) # Séléction de l'un des 3 derniers
        item.setIcon(icons[0]) # Affectation de la nouvelle icone
        item = self.ex_listWidget.item(idx - 1) # Séléction de l'un des 3 derniers
        item.setIcon(icons[1]) # Affectation de la nouvelle icone

        # Manipulation de la liste ; creation de sitems puis ajout de ces derniers
        item1 = QtGui.QListWidgetItem(icons[2], "Ohhh comme c'est mignon") # Création de l'item
        item2 = QtGui.QListWidgetItem(icons[3], "Et ca ! si c'est pas adorable !") # Création de l'item
        self.ex_listWidget.addItem(item1) # Envoie de l'item
        self.ex_listWidget.addItem(item2) # Envoie de l'item

    def liste_5(self):
        """Fonction inserant plusieurs lignes avec icone."""
        # Liste des icones à utiliser
        icons = (QtGui.QIcon.fromTheme("call-start"), QtGui.QIcon.fromTheme("call-stop"))

        # Manipulation de la combobox
        idx = self.ex_comboBox.currentIndex() # Récupération de la ligne actuelle
        self.ex_comboBox.insertItem(idx + 1, icons[0], "Telephone content :)") # Insertion de l'icone et du texte
        self.ex_comboBox.insertItem(idx + 2, icons[1], "Telephone pascontent :(") # Insertion de l'icone et du texte

        # Manipulation de la liste
        idx =  self.ex_listWidget.currentRow() # Récupération de la ligne actuelle
        item1 = QtGui.QListWidgetItem(icons[0], "Telephone content :)") # Création de l'item
        item2 = QtGui.QListWidgetItem(icons[1], "Telephone pascontent :(") # Création de l'item
        self.ex_listWidget.insertItem(idx + 1, item1) # Envoie de l'item
        self.ex_listWidget.insertItem(idx + 2, item2) # Envoie de l'item

    def liste_6(self):
        """Déscend les séléctions au plus bas."""
        self.ex_listWidget.scrollToBottom()

        idx = self.ex_comboBox.count() # Récupération du nombre d'item -1 (car l'index commence à 1)
        self.ex_comboBox.setCurrentIndex(idx - 1)

    def liste_7(self):
        """Monte les séléctions au plus bas."""
        self.ex_listWidget.scrollToTop()
        self.ex_comboBox.setCurrentIndex(0)

    def liste_8(self):
        """Deplace la selection au centre."""
        nb_item = self.ex_comboBox.count() # Nombre d'item

        if nb_item % 2 == 1: # On divise par 2 pour avoir le milieu
            item = ( nb_item + 1 ) / 2
        else:
            item = nb_item / 2

        self.ex_comboBox.setCurrentIndex(item) # Selection de l'item central

        item = self.ex_listWidget.item(item) # Séléction de l'item du milieu
        self.ex_listWidget.scrollToItem(item, 3) # Centrage de l'item
    ## Exemple de boite à liste ###

    ### Exemples de boites temporels ###
    def affichage_date(self, sauf_widget, date):
        # Blocage des signaux
        for widget in [self.ex_dateEdit, self.ex_dateTimeEdit, self.ex_calendarWidget]:
            widget.blockSignals(True)

        if sauf_widget is not "ex_dateEdit":
            self.ex_dateEdit.setDate(date)

        if sauf_widget is not "ex_dateTimeEdit":
            self.ex_dateTimeEdit.setDate(date)

        if sauf_widget is not "ex_calendarWidget":
            self.ex_calendarWidget.setSelectedDate(date)

        # Deblocage des signaux
        for widget in [self.ex_dateEdit, self.ex_dateTimeEdit, self.ex_calendarWidget]:
            widget.blockSignals(False)

    def affichage_time(self, sauf_widget, time):
        if sauf_widget is not "ex_dateTimeEdit":
            self.ex_dateTimeEdit.blockSignals(True) # Blocage du signal
            self.ex_dateTimeEdit.setTime(time)
            self.ex_dateTimeEdit.blockSignals(False) # Déblocage du signal

        if sauf_widget is not "ex_timeEdit":
            self.ex_timeEdit.blockSignals(True) # Blocage du signal
            self.ex_timeEdit.setTime(time)
            self.ex_timeEdit.blockSignals(False) # Déblocage du signal

    def date_1(self, date):
        self.affichage_date("ex_dateEdit", date)

    def date_2(self, date):
        self.affichage_date("ex_dateTimeEdit", date)

    def date_3(self, time):
        self.affichage_time("ex_dateTimeEdit", time)

    def date_4(self, time):
        self.affichage_time("ex_timeEdit", time)

    def date_5(self, date):
        self.affichage_date("ex_calendarWidget", date)

    def date_6(self):
        jour = random.randint(1, 28)
        mois = random.randint(1, 12)
        annee = random.randint(1752, 7999)
        heure = random.randint(1, 23)
        minute = random.randint(1, 59)
        self.statusbar.showMessage("Il est {}:{} et nous sommes le {}/{}/{}".format(heure, minute, jour, mois, annee), 7000)

        # Blocage du signal
        for widget in [self.ex_dateTimeEdit, self.ex_timeEdit, self.ex_dateEdit, self.ex_calendarWidget]:
            widget.blockSignals(True)

        self.ex_dateTimeEdit.setDateTime(QtCore.QDateTime(annee, mois, jour, heure, minute))
        self.ex_timeEdit.setTime(QtCore.QTime(heure, minute))
        self.ex_dateEdit.setDate(QtCore.QDate(annee, mois, jour))
        self.ex_calendarWidget.setSelectedDate(QtCore.QDate(annee, mois, jour))

        # Deblocage du signal
        for widget in [self.ex_dateTimeEdit, self.ex_timeEdit, self.ex_dateEdit, self.ex_calendarWidget]:
            widget.blockSignals(False)
    ### Exemples de boites temporels ###

    ### Exemple de boutons ###
    def buttonBoxDef(self, button):
        print(self.buttonBox.standardButton(button))

    def buttonBoxDef2(self):
        self.statusbar.showMessage("Un bouton accepted a ete cliqué.", 4000)

    def buttonBoxDef3(self):
        self.statusbar.showMessage("Un bouton rejected a ete cliqué.", 4000)

    def buttonBoxDef4(self):
        self.statusbar.showMessage("Un bouton help a ete cliqué.", 4000)

    def boutton_butt1(self):
        """Fonction activant/Desactivant les widgets à presser."""
        for widget in [self.pushButton_5, self.checkBox_3, self.checkBox_2, self.checkBox_5, self.radioButton_2, self.radioButton_4, self.radioButton_3, self.radioButton_5, self.checkBox_6]:
            widget.toggle()

    def boutton_butt2(self):
        self.pushButton_3.animateClick(300)
        self.pushButton_4.animateClick(300)
        self.commandLinkButton.animateClick(300)
    ### Exemple de boutons ###

    ### Exemple de boites de texte ###
    def textedit_butt1(self):
       self.ex_plainTextEdit.clear()
       self.ex_textEdit.clear()

    def textedit_butt2(self):
       self.ex_plainTextEdit.selectAll()
       self.ex_textEdit.selectAll()

    def textedit_butt3(self):
       self.ex_plainTextEdit.copy()
       self.ex_textEdit.copy()

    def textedit_butt4(self):
       self.ex_plainTextEdit.cut()
       self.ex_textEdit.cut()

    def textedit_butt5(self):
       self.ex_plainTextEdit.paste()
       self.ex_textEdit.paste()

    def textedit_butt6(self):
       self.ex_plainTextEdit.undo()
       self.ex_textEdit.undo()

    def textedit_butt7(self):
       self.ex_plainTextEdit.redo()
       self.ex_textEdit.redo()

    def textedit_butt8(self):
       self.ex_plainTextEdit.setPlainText("Ceci est super test.\n\nSi si je vous assure !")
       self.ex_textEdit.setPlainText("Ceci est super test.\n\nSi si je vous assure !")

    def textedit_butt9(self):
        fileName = QtGui.QFileDialog.getOpenFileName(
                        self,
                        "Séléctionner le fichier texte à ouvrir",
                        QtCore.QDir.homePath(),
                        "Fichiers texte (*.txt)"
                    )
        if fileName: # Si le fichier existe (different de None)
            fichier_choisi = open(fileName, "r") # Ouverture du fichier
            contenu = fichier_choisi.read() # Lecture du contenu
            self.statusbar.showMessage("Ouverture du fichier : {}".format(fileName), 7000)
            self.ex_plainTextEdit.setPlainText(contenu)
            self.ex_textEdit.setPlainText(contenu)

    def textedit_butt11(self):
       self.ex_plainTextEdit.insertPlainText("Mode infiltration !\n\nFaites gaffe les mecs !")
       self.ex_textEdit.insertPlainText("Mode infiltration !\n\nFaites gaffe les mecs !")

    def textedit_butt12(self):
       self.ex_plainTextEdit.appendHtml("""Ne fonctionne pas après l'utilisation de <span style=" font-weight:600;">setText</span>.""")

    def textedit_butt13(self):
       self.ex_plainTextEdit.appendPlainText("\nCeci est un ajout de derniere minute !")

    def textedit_butt14(self):
       self.ex_plainTextEdit.centerCursor()

    def textedit_butt15(self):
       self.ex_textEdit.append("""\n\nCeci est un ajout de\n\n <span style=" font-weight:600;">dérniere</span>. minute !""")

    def textedit_butt16(self):
       self.ex_textEdit.insertHtml("""\nCeci est un ajout de <span style=" font-weight:600;">sérniere</span>. minute !""")

    def textedit_butt17(self):
       self.ex_textEdit.setHtml("""Je vous envoie un <span style=" font-weight:600;">nouveau</span> texte en remplacement de l'<span style=" font-weight:600;">ancien</span> !""")

    def textedit_butt18(self):
       self.ex_textEdit.setPlainText("""De nombreuses options sont disponibles :
setAlignment
setCurrentFont
setFontFamily
setFontItalic
setFontPointSize
setFontUnderline
setFontWeight
setTextBackgroundColor
setTextColor""")

    def textedit_butt20(self):
       self.ex_textEdit.zoomOut(5)

    def textedit_butt21(self):
       self.ex_textEdit.zoomIn(5)
    ### Exemple de boites de texte ###

    ### Exemple de la boite d'entrée de texte ###
    def lineEdit_butt1(self):
        self.ex_lineEdit.clear()

    def lineEdit_butt2(self):
        self.ex_lineEdit.selectAll()

    def lineEdit_butt3(self):
        self.ex_lineEdit.undo()

    def lineEdit_butt4(self):
        self.ex_lineEdit.redo()

    def lineEdit_butt5(self):
        self.ex_lineEdit.copy()

    def lineEdit_butt6(self):
        self.ex_lineEdit.paste()

    def lineEdit_butt7(self):
        self.ex_lineEdit.setText(self.ex_lineEdit_lineedit.text())

    def lineEdit_butt8(self):
        self.ex_lineEdit.cut()
    ### Exemple de la boite d'entrée de texte ###

    ### Exemples de boites à chiffres ###
    def affichage_valeur(self, valeur, sauf_widget): # Fonction evitant la répétitions des actions
        # Blocage des signaux
        for widget in [self.ex_spinBox, self.ex_doubleSpinBox, self.ex_horizontalSlider, self.ex_verticalSlider, self.ex_dial]:
            widget.blockSignals(True)

        # Envoie des valeurs
        for widget in [self.progressBar, self.progressBar_2, self.progressBar_3, self.ex_spinBox, self.ex_doubleSpinBox, self.ex_horizontalSlider, self.ex_verticalSlider, self.ex_dial]:
            widget.setValue(valeur)

        # Envoie de la valeur au LCD
        self.lcdNumber.display(valeur)

        # Deblocage des signaux
        for widget in [self.ex_spinBox, self.ex_doubleSpinBox, self.ex_horizontalSlider, self.ex_verticalSlider, self.ex_dial]:
            widget.blockSignals(False)

    def chiffres_1(self, valeur):
        self.affichage_valeur(valeur, "ex_dial")

    def chiffres_2(self, valeur):
        self.affichage_valeur(valeur, "ex_doubleSpinBox")

    def chiffres_3(self, valeur):
        self.affichage_valeur(valeur, "ex_spinBox")

    def chiffres_4(self, valeur):
        self.affichage_valeur(valeur, "ex_horizontalSlider")

    def chiffres_5(self, valeur):
        self.affichage_valeur(valeur, "ex_verticalSlider")

    def chiffres_6(self):
        min = random.randrange(-100, 46, 5)
        max = random.randrange(55, 200, 5)
        valeur = random.randint(min, max)
        self.statusbar.showMessage("Le minimum passe à {}, le maximum à {} et la nouvelle valeur est {}".format(min, max, valeur), 7000)
        self.progressBar.setRange(min, max)
        self.progressBar_2.setRange(min, max)
        self.progressBar_3.setRange(min, max)
        self.ex_dial.setRange(min, max)
        self.ex_spinBox.setRange(min, max)
        self.ex_doubleSpinBox.setRange(min, max)
        self.ex_horizontalSlider.setRange(min, max)
        self.ex_verticalSlider.setRange(min, max)
        self.affichage_valeur(valeur, "progressbar")

    def chiffres_7(self):
        self.progressBar.reset()
        self.progressBar_2.reset()
        self.progressBar_3.reset()
        self.statusbar.showMessage("Les barres sont toutes propres.", 7000)
    ### Exemples de boites à chiffres ###

    def main(self): # Necessaire pour lancer l'application graphique
        self.show() # Affiche la fenetre

if __name__=='__main__':
    app = QtGui.QApplication(sys.argv)
    PyTests = PyTests()
    PyTests.main()
    app.exec_()