﻿Public Class Visu3D
    Public Objets3D As New ListeObjets3D
    Dim monStopWatch As New Stopwatch

    Private Sub VueX_M_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles VueX_M.Click
        VueX.Text = Format$(Val(VueX.Text) - Pas)
    End Sub

    Private Sub VueY_M_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles VueY_M.Click
        VueY.Text = Format$(Val(VueY.Text) - Pas)
    End Sub

    Private Sub VueZ_M_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles VueZ_M.Click
        VueZ.Text = Format$(Val(VueZ.Text) - Pas)
    End Sub

    Private Sub VueX_P_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles VueX_P.Click
        VueX.Text = Format$(Val(VueX.Text) + Pas)
    End Sub

    Private Sub VueY_P_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles VueY_P.Click
        VueY.Text = Format$(Val(VueY.Text) + Pas)
    End Sub

    Private Sub VueZ_P_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles VueZ_P.Click
        VueZ.Text = Format$(Val(VueZ.Text) + Pas)
    End Sub

    Private Sub D_M_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles D_M.Click
        D.Text = Format$(Val(D.Text) - Pas)
    End Sub

    Private Sub D_P_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles D_P.Click
        D.Text = Format$(Val(D.Text) + Pas)
    End Sub

    Private Sub K_M_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles K_M.Click
        K.Text = Format$(Val(K.Text) - Pas)
    End Sub

    Private Sub K_P_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles K_P.Click
        K.Text = Format$(Val(K.Text) + Pas)
    End Sub

    Private Sub RAY_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles RAY.ValueChanged
        LabelRAY.Text = Format$(-RAY.Value)
    End Sub

    Private Sub RAX_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles RAX.ValueChanged
        LabelRAX.Text = Format$(-RAX.Value)
    End Sub

    Private Sub AngleX_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles AngleX.ValueChanged
        LabelX.Text = Format$(-AngleX.Value)
    End Sub

    Private Sub AngleY_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles AngleY.ValueChanged
        LabelY.Text = Format$(AngleY.Value)
    End Sub

    Private Sub RAR_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles RAR.ValueChanged
        LabelRAR.Text = Format$(-RAR.Value)
    End Sub

    Private Sub LAX_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles LAX.ValueChanged
        LabelLAX.Text = Format$(-LAX.Value)
    End Sub

    Private Sub LAY_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles LAY.ValueChanged
        LabelLAY.Text = Format$(-LAY.Value)
    End Sub

    Private Sub LI_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles LI.ValueChanged
        LabelLI.Text = Format$(Int(LI.Value * 100 / 255)) + "%"
    End Sub

    Private Sub Option1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Option1.CheckedChanged
        Explications.Text = "Faites glisser la souris en maintenant appuyé le bouton gauche pour régler X et Y, ou le bouton droit pour régler Z et D"
    End Sub

    Private Sub Option2_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Option2.CheckedChanged
        Explications.Text = "Faites glisser la souris en maintenant appuyé le bouton gauche pour régler les deux angles de vue."
    End Sub

    Private Sub Option3_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Option3.CheckedChanged
        Explications.Text = "Faites glisser la souris en maintenant appuyé le bouton gauche pour régler l'angle de rotation, ou le bouton droit pour régler l'axe de rotation."
    End Sub

    Private Sub Option4_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Option4.CheckedChanged
        Explications.Text = "Faites glisser la souris en maintenant appuyé le bouton gauche pour régler l'intensité de l'effet lumière, ou le bouton droit pour régler la direction de la lumière." + vbCrLf + "Le réglage de la lumière n'agit que sur les volumes."
    End Sub

    Private Sub ButReset_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButReset.Click
        Dim temp As Boolean
        temp = AffAuto.Checked
        AffAuto.Checked = False
        AngleY.Value = 0
        AngleX.Value = 0
        RAX.Value = 0
        RAY.Value = 90
        RAR.Value = 0
        LAX.Value = 0
        LAY.Value = 0
        VueX.Text = "0"
        VueY.Text = "0"
        VueZ.Text = "0"
        D.Text = "15"
        K.Text = "35"
        AffAuto.Checked = temp
    End Sub

    Private Sub ButTrace_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButTrace.Click
        Call Tracer()
    End Sub

    Public Sub Tracer()
        Dim tempsExecution As Long
        If Autorisation Then 'Différence entre le DoEvents de .NET et de VB5
            Autorisation = False
            monStopWatch.Reset()
            monStopWatch.Start()
            System.Windows.Forms.Application.DoEvents()
            If Not (Visu3D2.Visible) Then
                Visu3D2.Visible = True
                System.Windows.Forms.Application.DoEvents()
                Call Objets3D.InitImage()
            End If
            'Call Objets3D.InitImage()
            Call Objets3D.EffacerImage()
            Objets3D.Tourner(-RAX.Value * 3.14 / 180, -RAY.Value * 3.14 / 180, -RAR.Value * 3.14 / 180)
            Objets3D.Projection(Val(VueX.Text), Val(VueY.Text), Val(VueZ.Text), -AngleX.Value * 3.14 / 180, -AngleY.Value * 3.14 / 180, Val(D.Text), Val(K.Text))
            If Visu1.Checked Or Visu3.Checked Then
                Objets3D.TraceLignes(Visu3D2.Image3D)
            End If
            If Not Visu1.Checked Then
                Objets3D.TraceSurfaces(Visu3D2.Image3D, -LAX.Value * 3.14 / 180, -LAY.Value * 3.14 / 180, LI.Value)
            End If
            If Visu4.Checked Then
                Objets3D.TraceLignes(Visu3D2.Image3D)
            End If
            monStopWatch.Stop()
            tempsExecution = monStopWatch.ElapsedMilliseconds
            ListeTempsExec.Add(tempsExecution)
            Autorisation = True
        End If
        'MsgBox("OK")
    End Sub

    Private Sub ButQuitter_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButQuitter.Click
        End
    End Sub

    Private Sub Visu3D_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Pas = 1
        ListeTempsExec = New Collection
        Autorisation = True
        Dim cube As Volume, tore As Volume, cylindre As Volume
        Dim axes As New Volume

        'On définit les axes :
        axes.Init3D(0, 0, 30)
        axes.Coul = &HFF
        axes.AddPoint(0, 0, 0)
        axes.AddPoint(3, 0, 0)
        axes.AddPoint(0, 3, 0)
        axes.AddPoint(0, 0, 3)
        axes.AddLigne(1, 2)
        axes.AddLigne(1, 3)
        axes.AddLigne(1, 4)

        'Cube :
        cube = NvCube(3, -9.5, 0, 30)
        cube.Coul = RGB(255, 0, 0)

        'Cylindre :
        'Set cylindre = NvCylindre(6, 5, 0, 0, 30, 15)
        cylindre = NvCylindre(6, 5, 0, 0, 30, 30)
        cylindre.Coul = RGB(128, 128, 128)

        cylindre.Tourner(0, 1, 1, (30 * 3.14 / 180))
        axes.Tourner(0, 1, 1, (30 * 3.14 / 180))

        'Tore :
        'Set tore = NvTore(6, 2, 9, 0, 30, 12, 8)
        tore = NvTore(6, 2, 9, 0, 30, 48, 24)
        tore.Coul = RGB(100, 100, 255)

        Objets3D.Objets.Add(cube)
        Objets3D.Objets.Add(cylindre)
        Objets3D.Objets.Add(axes)
        Objets3D.Objets.Add(tore)

        tore = NvTore(5, 2, 0, 8, 30, 48, 24)
        tore.Coul = RGB(255, 0, 255)
        tore.Tourner(0, 0, 1, 90 * 3.14 / 180)
        Objets3D.Objets.Add(tore)
    End Sub

    Private Sub PasA_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PasA.TextChanged
        Dim i As Integer
        i = Val(PasA.Text)
        If i > 0 Then
            AngleY.LargeChange = i
            AngleX.LargeChange = i
            RAX.LargeChange = i
            RAY.LargeChange = i
            RAR.LargeChange = i
            LAX.LargeChange = i
            LAY.LargeChange = i
        End If
    End Sub

    Private Sub Inc_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Inc.TextChanged
        Dim i As Integer
        i = Val(Inc.Text)
        If i > 0 Then
            Pas = i
        End If
    End Sub

    Private Sub ButRazPerf_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButRazPerf.Click
        ListeTempsExec.Clear()
    End Sub

    Private Sub ButAffPerf_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButAffPerf.Click
        Dim t As Long
        Dim tmoy As Double
        Dim n As Integer
        tmoy = 0
        n = ListeTempsExec.Count
        If n = 0 Then
            MsgBox("Il faut avoir lancé quelques affichages d'abord")
        Else
            For Each t In ListeTempsExec
                tmoy = tmoy + CDbl(t) / n
            Next
            MsgBox("Nombre d'affichages = " + Format(n) + vbCrLf + "Temps moyen d'éxecution = " + Format(tmoy) + " ms")
        End If
    End Sub
End Class
