Attribute VB_Name = "ModuleVolume"
Option Explicit
    Public Pas As Integer

Public ListeTempsExec As Collection

Public Const NUM_POINTS_API As Integer = 4
Public Declare Function Polygon Lib "gdi32" (ByVal hdc As Long, lpPoint As POINTAPI, ByVal nCount As Long) As Long
Public Type POINTAPI
    X As Long
    Y As Long
End Type

Function NvCube(Cote As Single, Xcentre As Single, Ycentre As Single, Zcentre As Single) As Volume
    Dim cube As New Volume
'On dfinit un pav
    'Position du centre :
    cube.Init3D Xcentre, Ycentre, Zcentre
    
    'Points
    Cote = Cote / 2
    cube.AddPoint -Cote, -Cote, -Cote
    cube.AddPoint Cote, -Cote, -Cote
    cube.AddPoint Cote, Cote, -Cote
    cube.AddPoint -Cote, Cote, -Cote
    cube.AddPoint -Cote, -Cote, Cote
    cube.AddPoint Cote, -Cote, Cote
    cube.AddPoint Cote, Cote, Cote
    cube.AddPoint -Cote, Cote, Cote
    
    cube.AddLigne 1, 2, 0
    cube.AddLigne 2, 3, 0
    cube.AddLigne 3, 4, 0
    cube.AddLigne 4, 1, 0
    cube.AddLigne 5, 6, 0
    cube.AddLigne 6, 7, 0
    cube.AddLigne 7, 8, 0
    cube.AddLigne 8, 5, 0
    cube.AddLigne 1, 5, 0
    cube.AddLigne 2, 6, 0
    cube.AddLigne 3, 7, 0
    cube.AddLigne 4, 8, 0

    cube.AddTriangle 1, 2, 4, 0
    cube.AddTriangle 2, 3, 4, 0
    cube.AddTriangle 1, 2, 6, 0
    cube.AddTriangle 1, 5, 6, 0
    cube.AddTriangle 3, 4, 8, 0
    cube.AddTriangle 3, 7, 8, 0
    cube.AddTriangle 1, 4, 5, 0
    cube.AddTriangle 4, 5, 8, 0
    cube.AddTriangle 2, 3, 6, 0
    cube.AddTriangle 3, 6, 7, 0
    cube.AddTriangle 5, 6, 7, 0
    cube.AddTriangle 5, 7, 8, 0
    
    Set NvCube = cube
End Function
Function NvPave(Longueur As Single, Hauteur As Single, Profondeur As Single, Xcentre As Single, Ycentre As Single, Zcentre As Single) As Volume
    Dim cube As New Volume
'On dfinit un pav
    'Position du centre :
    cube.Init3D Xcentre, Ycentre, Zcentre
    
    'Points
    Longueur = Longueur / 2
    Hauteur = Hauteur / 2
    Profondeur = Profondeur / 2
    cube.AddPoint -Longueur, -Hauteur, -Profondeur
    cube.AddPoint Longueur, -Hauteur, -Profondeur
    cube.AddPoint Longueur, Hauteur, -Profondeur
    cube.AddPoint -Longueur, Hauteur, -Profondeur
    cube.AddPoint -Longueur, -Hauteur, Profondeur
    cube.AddPoint Longueur, -Hauteur, Profondeur
    cube.AddPoint Longueur, Hauteur, Profondeur
    cube.AddPoint -Longueur, Hauteur, Profondeur
    
    cube.AddLigne 1, 2, 0
    cube.AddLigne 2, 3, 0
    cube.AddLigne 3, 4, 0
    cube.AddLigne 4, 1, 0
    cube.AddLigne 5, 6, 0
    cube.AddLigne 6, 7, 0
    cube.AddLigne 7, 8, 0
    cube.AddLigne 8, 5, 0
    cube.AddLigne 1, 5, 0
    cube.AddLigne 2, 6, 0
    cube.AddLigne 3, 7, 0
    cube.AddLigne 4, 8, 0

    cube.AddTriangle 1, 2, 4, 0
    cube.AddTriangle 2, 3, 4, 0
    cube.AddTriangle 1, 2, 6, 0
    cube.AddTriangle 1, 5, 6, 0
    cube.AddTriangle 3, 4, 8, 0
    cube.AddTriangle 3, 7, 8, 0
    cube.AddTriangle 1, 4, 5, 0
    cube.AddTriangle 4, 5, 8, 0
    cube.AddTriangle 2, 3, 6, 0
    cube.AddTriangle 3, 6, 7, 0
    cube.AddTriangle 5, 6, 7, 0
    cube.AddTriangle 5, 7, 8, 0
    
    Set NvPave = cube
End Function
Function NvTube(Hauteur As Single, Diametre As Single, Xcentre As Single, Ycentre As Single, Zcentre As Single, Nb As Integer) As Volume
    Dim cube As New Volume
    Dim A As Single, X As Single, Z As Single
    Dim i As Integer
    
    'Position du centre :
    cube.Init3D Xcentre, Ycentre, Zcentre
    Hauteur = Hauteur / 2
    Diametre = Diametre / 2
    
    For i = 0 To Nb - 1
        'Points :
        A = i * 6.282 / Nb
        X = Diametre * Sin(A)
        Z = Diametre * Cos(A)
        cube.AddPoint X, Hauteur, Z
        cube.AddPoint X, -Hauteur, Z
        'Lignes (gnratrices) :
        cube.AddLigne i * 2 + 1, i * 2 + 2, 0
        'Triangles (sur le tour) :
        If i < Nb - 1 Then
            cube.AddTriangle i * 2 + 1, i * 2 + 3, i * 2 + 4, 0
            cube.AddTriangle i * 2 + 1, i * 2 + 2, i * 2 + 4, 0
        End If
    Next i
    cube.AddTriangle Nb * 2 - 1, 1, 2, 0
    cube.AddTriangle Nb * 2 - 1, Nb * 2, 2, 0
    
    'Lignes (cercles) :
    For i = 1 To Nb - 1
        cube.AddLigne 2 * i, 2 * i + 2, 0
        cube.AddLigne 2 * i - 1, 2 * i + 1, 0
    Next i
    cube.AddLigne Nb * 2, 2, 0
    cube.AddLigne Nb * 2 - 1, 1, 0

    Set NvTube = cube
End Function
Function NvCylindre(Hauteur As Single, Diametre As Single, Xcentre As Single, Ycentre As Single, Zcentre As Single, Nb As Integer) As Volume
    Dim cube As New Volume
    Dim A As Single, X As Single, Z As Single
    Dim i As Integer
    
    'Position du centre :
    cube.Init3D Xcentre, Ycentre, Zcentre
    Hauteur = Hauteur / 2
    Diametre = Diametre / 2
    
    For i = 0 To Nb - 1
        'Points :
        A = i * 6.282 / Nb
        X = Diametre * Sin(A)
        Z = Diametre * Cos(A)
        cube.AddPoint X, Hauteur, Z
        cube.AddPoint X, -Hauteur, Z
        'Lignes (gnratrices) :
        cube.AddLigne i * 2 + 1, i * 2 + 2, 0
        'Triangles (sur le tour) :
        If i < Nb - 1 Then
            cube.AddTriangle i * 2 + 1, i * 2 + 3, i * 2 + 4, 0
            cube.AddTriangle i * 2 + 1, i * 2 + 2, i * 2 + 4, 0
        End If
    Next i
    cube.AddTriangle Nb * 2 - 1, 1, 2, 0
    cube.AddTriangle Nb * 2 - 1, Nb * 2, 2, 0
    
    'Lignes (cercles) :
    For i = 1 To Nb - 1
        cube.AddLigne 2 * i, 2 * i + 2, 0
        cube.AddLigne 2 * i - 1, 2 * i + 1, 0
    Next i
    cube.AddLigne Nb * 2, 2, 0
    cube.AddLigne Nb * 2 - 1, 1, 0

    'Lignes (rayons) :
    cube.AddPoint 0, Hauteur, 0
    cube.AddPoint 0, -Hauteur, 0
    For i = 1 To Nb - 1
        cube.AddLigne 2 * i, Nb * 2 + 2, 0
        cube.AddLigne 2 * i - 1, Nb * 2 + 1, 0
        cube.AddTriangle 2 * i, 2 * i + 2, Nb * 2 + 2, 0
        cube.AddTriangle 2 * i - 1, 2 * i + 1, Nb * 2 + 1, 0
    Next i
    cube.AddLigne 2 * Nb, Nb * 2 + 2, 0
    cube.AddLigne 2 * Nb - 1, Nb * 2 + 1, 0
    cube.AddTriangle 2 * Nb, 2, Nb * 2 + 2, 0
    cube.AddTriangle 2 * Nb - 1, 1, Nb * 2 + 1, 0
    
    Set NvCylindre = cube
End Function
Function NvTore(DiametreG As Single, DiametreP As Single, Xcentre As Single, Ycentre As Single, Zcentre As Single, NbG As Integer, NbP As Integer) As Volume
    Dim cube As New Volume
    Dim X2 As Single, Y As Single, A As Single
    Dim i As Integer, j As Integer
    Dim p1 As Integer, p2 As Integer, p3 As Integer, P4 As Integer
       
    'Position du centre :
    cube.Init3D Xcentre, Ycentre, Zcentre
    
    DiametreG = DiametreG / 2
    DiametreP = DiametreP / 2
    
    For i = 1 To NbP
        A = i * 6.282 / NbP
        X2 = DiametreG + DiametreP * Sin(A)
        Y = DiametreP * Cos(A)
        For j = 1 To NbG
            A = j * 6.282 / NbG
            cube.AddPoint X2 * Cos(A), Y, X2 * Sin(A)
            'Calcul des indices des points :
            p1 = (i - 1) * NbG + j
            If i = NbP Then
                p2 = j
            Else
                p2 = i * NbG + j
            End If
            If j = NbG Then
                p3 = (i - 1) * NbG + 1
                P4 = p2 + 1 - NbG
            Else
                p3 = (i - 1) * NbG + j + 1
                P4 = p2 + 1
            End If
            'Lignes autour du gros diametre :
            cube.AddLigne p1, p3, 0
            'Lignes autour des sections :
            cube.AddLigne p1, p2, 0
            'Triangles :
            cube.AddTriangle p1, p3, P4, 0
            cube.AddTriangle p1, p2, P4, 0
        Next j
    Next i
    Set NvTore = cube
End Function

