VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "ListeObjets3D"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Objets As New Collection

Public Sub Tourner(AngleX As Single, AngleY As Single, AngleR As Single)
    'Cette procdure tourne l'ensemble d'objets sur lui mme :
    Dim ob As Volume
    Dim pts As Point
    If AngleR = 0 Then
        'On ne tourne pas :
        For Each ob In Objets
            ob.X = ob.vrai_X
            ob.Y = ob.vrai_Y
            ob.Z = ob.vrai_Z
            For Each pts In ob.Les_points
                pts.X = pts.vrai_X
                pts.Y = pts.vrai_Y
                pts.Z = pts.vrai_Z
            Next pts
        Next ob
    Else
        Dim A As Single, B As Single, C As Single
        Dim SINAX As Single, COSAX As Single, SINAY As Single, COSAY As Single
        
        Dim GX As Single, GY As Single, GZ As Single
        Dim i As Integer
        
        Dim S As Single
        Dim SQRS As Single
        Dim E As Single
        Dim xx As Single, yy As Single, zz As Single
        Dim WX As Single, WY As Single, WZ As Single
        Dim WPX As Single, WPY As Single, WPZ As Single
        Dim COSR As Single, SINR2 As Single
    
        'Calcul du vecteur axe de rotation A,B,C :
        COSAY = Cos(AngleY)
        SINAY = Sin(AngleY)
        COSAX = Cos(AngleX)
        SINAX = Sin(AngleX)
        A = -SINAY * COSAX
        B = SINAX
        C = COSAY * COSAX
    
        'Calcul du Barycentre GX,GY,GZ de l'ensemble :
        xx = 0
        yy = 0
        zz = 0
        i = 0
        For Each ob In Objets
            xx = xx + ob.vrai_X
            yy = yy + ob.vrai_Y
            zz = zz + ob.vrai_Z
            i = i + 1
            'For Each pts In ob.Les_points
            '    xx = xx + pts.vrai_X + ob.vrai_X
            '    yy = yy + pts.vrai_Y + ob.vrai_Y
            '    zz = zz + pts.vrai_Z + ob.vrai_Z
            '    i = i + 1
            'Next pts
        Next ob
        GX = xx / i
        GY = yy / i
        GZ = zz / i
        
        S = A * A + B * B + C * C
        SQRS = Sqr(S)
        COSR = Cos(AngleR)
        SINR2 = Sin(AngleR) / SQRS
        For Each ob In Objets
            For Each pts In ob.Les_points
                xx = pts.vrai_X + ob.vrai_X - GX
                yy = pts.vrai_Y + ob.vrai_Y - GY
                zz = pts.vrai_Z + ob.vrai_Z - GZ
                E = (A * xx + B * yy + C * zz) / S
                WX = A * E
                WY = B * E
                WZ = C * E
                WPX = xx - WX
                WPY = yy - WY
                WPZ = zz - WZ
                xx = WX + WPX * COSR + (WPY * C - WPZ * B) * SINR2
                yy = WY + WPY * COSR + (WPZ * A - WPX * C) * SINR2
                zz = WZ + WPZ * COSR + (WPX * B - WPY * A) * SINR2
                pts.X = xx + GX - ob.vrai_X
                pts.Y = yy + GY - ob.vrai_Y
                pts.Z = zz + GZ - ob.vrai_Z
            Next pts
        Next ob
        
    End If
End Sub

Public Sub Projection(VueX As Single, VueY As Single, VueZ As Single, AngleX As Single, AngleY As Single, D As Single, K As Single, Image1)
'Point de vue :
    'Angles de vue : AngleX, AngleY
    'Distance de l'cran : D
    'Position du point de vue : VueX, VueY, VueZ
    'Coefficient d'ajustment  l'cran : K
    'Image o tracer les solides : Image1

    Dim ob As Volume
    Dim pts As Point
   
    'Rsultats intermdiaires :
    Dim H As Integer, L As Integer
    Dim H2 As Integer, L2 As Integer
    Dim COSAY As Single, SINAY As Single, COSAX As Single, SINAX As Single
    Dim PX As Single, PZ As Single        'Nouveau vecteur X
    Dim QX As Single, QY As Single, QZ As Single    'Nouveau vecteur Y
    Dim RX As Single, RY As Single, RZ As Single    'Nouveau vecteur Z
    Dim E As Single, F As Single
    Dim OLX As Single, OLY As Single, OLZ As Single
    'Dim xx As Single, yy As Single, zz As Single
    
    L = Image1.ScaleWidth
    H = Image1.ScaleHeight
        
    COSAY = Cos(AngleY)
    SINAY = Sin(AngleY)
    COSAX = Cos(AngleX)
    SINAX = Sin(AngleX)
    PX = COSAY
    PZ = SINAY
    QX = SINAY * SINAX
    QY = COSAX
    QZ = -COSAY * SINAX
    RX = -SINAY * COSAX
    RY = SINAX
    RZ = COSAY * COSAX
    L2 = L / 2
    H2 = H / 2
      
    For Each ob In Objets
        For Each pts In ob.Les_points
            'Les coordonnes des points sont relatives au centre du volume
            pts.X = pts.X + ob.X - VueX
            pts.Y = pts.Y + ob.Y - VueY
            pts.Z = pts.Z + ob.Z - VueZ

On Error GoTo ErreurProjection
            
            E = RX * pts.X + RY * pts.Y + RZ * pts.Z
            F = D / E
            OLX = pts.X * F - RX * D
            OLY = pts.Y * F - RY * D
            OLZ = pts.Z * F - RZ * D
            pts.XE = L2 + K * (OLX * PX + OLZ * PZ)
            pts.YE = H2 - K * (OLX * QX + OLY * QY + OLZ * QZ)
            
            If E > D Then
                pts.Status = 0
            Else
                'Le point est devant l'cran :
                pts.Status = 2
            End If

FinErreurProjection:
On Error GoTo 0

        Next pts
    Next ob

    'On marque les points qui sortent de l'cran :
    For Each ob In Objets
        For Each pts In ob.Les_points
            If pts.Status = 0 Then
                If pts.XE > 0 And pts.XE < L And pts.YE > 0 And pts.YE < H Then
                    pts.Status = 0
                Else
                    pts.Status = 1
                End If
            End If
        Next pts
    Next ob

    Exit Sub
ErreurProjection:
    pts.Status = 3
    Resume FinErreurProjection
End Sub

Public Sub TraceLignes(Image1)
    Dim ob As Volume
    Dim pts As Point
    Dim LI As Ligne
    Dim pts2 As New Point
    Dim i As Integer
    For Each ob In Objets
        Image1.ForeColor = ob.Coul
        For Each LI In ob.Les_lignes
            Image1.DrawStyle = LI.style
            i = LI.pt1
            Set pts = ob.Les_points(i)
            i = LI.pt2
            Set pts2 = ob.Les_points(i)
            If pts.Status = 0 Or pts2.Status = 0 Then
                Image1.Line (pts.XE, pts.YE)-(pts2.XE, pts2.YE)
            End If
        Next LI
    Next ob
End Sub


Public Sub TraceSurfaces(Image1 As PictureBox, LumAngleX As Single, LumAngleY As Single, LumI As Integer)
    Dim ob As Volume
    Dim pts As Point, pts2 As Point, pts3 As Point
    Dim tr As Triangle
    Dim i As Integer
    Dim j As Integer, Nb As Integer
    Dim cpto As Integer, cptt As Integer
    Dim SX As Single, SY As Single, SZ As Single
    'Variables pour le calcul de la couleur :
    Dim SINAX As Single, COSAX As Single, SINAY As Single, COSAY As Single
    Dim LX As Single, LY As Single, LZ As Single
    Dim Coul As Long
    'Pourquoi LONG alors que INTEGER devrai suffir ?
    Dim CR As Long, CG As Long, cb As Long '???
    Dim P1P2x As Single, P1P2y As Single, P1P2z As Single
    Dim P1P3x As Single, P1P3y As Single, P1P3z As Single
    Dim PPx As Single, PPy As Single, PPz As Single 'Produit vectoriel de P1P2 et P1P3
    Dim GainCoul As Single

    Dim m_Points(1 To 3) As POINTAPI

    'Variables pour trier les triangles :
    Nb = 0
    For Each ob In Objets
        Nb = Nb + ob.Les_triangles.Count
    Next ob
    ReDim T_P(Nb) As Single 'Profondeur des triangles
    ReDim T_OBJ(Nb) As Integer 'Index de l'objet auquel appartient le triangle
    ReDim T_TRI(Nb) As Integer 'Index du triangle dans l'objet

    'Calcul du vecteur lumire :
    COSAY = Cos(LumAngleY)
    SINAY = Sin(LumAngleY)
    COSAX = Cos(LumAngleX)
    SINAX = Sin(LumAngleX)
    LX = -SINAY * COSAX
    LY = SINAX
    LZ = COSAY * COSAX

    'Stockage des triangles :
    j = 0
    cpto = 0
    For Each ob In Objets
        cpto = cpto + 1
        cptt = 0
        For Each tr In ob.Les_triangles
            cptt = cptt + 1
            T_OBJ(j) = cpto
            T_TRI(j) = cptt
            i = tr.pt1
            Set pts = ob.Les_points(i)
            i = tr.pt2
            Set pts2 = ob.Les_points(i)
            i = tr.pt3
            Set pts3 = ob.Les_points(i)
            'T_P est la distance (au carr) entre l'observateur et le centre du triangle :
            SX = pts.X + pts2.X + pts3.X
            SY = pts.Y + pts2.Y + pts3.Y
            SZ = pts.Z + pts2.Z + pts3.Z
            T_P(j) = SX * SX + SY * SY + SZ * SZ
            j = j + 1
        Next tr
    Next ob

    'Tri des triangles (tri  bulles) :
    Dim Maxi As Single
    Dim Temp_P As Single
    Dim Temp_OBJ As Integer
    Dim Temp_TRI As Integer
    Dim i_Maxi As Integer

    For j = 0 To Nb - 1
        'On cherche le maximun dans la fin du tableau :
        Maxi = T_P(j)
        i_Maxi = j
        For i = j To Nb - 1
            If T_P(i) > Maxi Then
                Maxi = T_P(i)
                i_Maxi = i
            End If
        Next i
        'On change le maximum et la place courante :
        Temp_P = T_P(j)
        Temp_OBJ = T_OBJ(j)
        Temp_TRI = T_TRI(j)
        T_P(j) = T_P(i_Maxi)
        T_OBJ(j) = T_OBJ(i_Maxi)
        T_TRI(j) = T_TRI(i_Maxi)
        T_P(i_Maxi) = Temp_P
        T_OBJ(i_Maxi) = Temp_OBJ
        T_TRI(i_Maxi) = Temp_TRI
    Next j

    For j = 0 To Nb - 1
        Set ob = Objets.Item(T_OBJ(j))
        Set tr = ob.Les_triangles.Item(T_TRI(j))
        i = tr.pt1
        Set pts = ob.Les_points(i)
        i = tr.pt2
        Set pts2 = ob.Les_points(i)
        i = tr.pt3
        Set pts3 = ob.Les_points(i)
        Image1.DrawStyle = tr.style
        'Calcul de la couleur :
        Coul = ob.Coul
        CR = (Coul Mod 65536) Mod 256
        CG = ((Coul - CR) / 256) Mod 256
        cb = (Coul - CR - CG * 256) / 65536
        P1P2x = pts2.X - pts.X
        P1P2y = pts2.Y - pts.Y
        P1P2z = pts2.Z - pts.Z
        P1P3x = pts3.X - pts.X
        P1P3y = pts3.Y - pts.Y
        P1P3z = pts3.Z - pts.Z
        PPx = P1P2y * P1P3z - P1P2z * P1P3y
        PPy = P1P2z * P1P3x - P1P2x * P1P3z
        PPz = P1P2x * P1P3y - P1P2y * P1P3x
        GainCoul = Abs(LX * PPx + LY * PPy + LZ * PPz)
        GainCoul = GainCoul / (Sqr(LX * LX + LY * LY + LZ * LZ) * Sqr(PPx * PPx + PPy * PPy + PPz * PPz))
        GainCoul = LumI * (GainCoul - 0.5)
        CR = CR + GainCoul
        CG = CG + GainCoul
        cb = cb + GainCoul
        If CR > 255 Then CR = 255
        If CG > 255 Then CG = 255
        If cb > 255 Then cb = 255
        If CR < 0 Then CR = 0
        If CG < 0 Then CG = 0
        If cb < 0 Then cb = 0
        Coul = RGB(CR, CG, cb)
        'Traage du triangle :
        If pts.Status = 0 Or pts2.Status = 0 Or pts3.Status = 0 Then
            m_Points(1).X = pts.XE
            m_Points(1).Y = pts.YE
            m_Points(2).X = pts2.XE
            m_Points(2).Y = pts2.YE
            m_Points(3).X = pts3.XE
            m_Points(3).Y = pts3.YE
            Image1.ForeColor = Coul
            Image1.FillColor = Coul
            Polygon Image1.hdc, m_Points(1), 3
        End If
    Next j
End Sub

