import QtQuick 2.4
import QtQuick.Window 2.2
import "test.js" as Test

Window {
    visible: true
    width: 500
    height: 400

    TestQml{
        id : testQml
    }

    Rectangle {
        anchors.fill: parent

        Column {
            anchors.centerIn: parent
            spacing: 10

            Text {
                text : titre
            }

            LineRow {
                text: "Test QML/JS A"
                onClicked: result = Test.testObjetsTypeA() + " msecs";
            }

            LineRow {
                text: "Test QML/JS B"
                onClicked: result = Test.testObjetsTypeB() + " msecs";
            }
            LineRow {
                text: "Test QML"
                onClicked: result = testQml.testObjetsTypeA() + " msecs";
            }

            LineRow {
                text: "Test C++"
                onClicked: result = tester.runCppTest() + " msecs";
            }

            LineRow {
                text: "Test QtScript A"
                onClicked: result = tester.runQtScriptTestA() + " msecs";
            }

            LineRow {
                text: "Test QtScript B"
                onClicked: result = tester.runQtScriptTestB() + " msecs";
            }

            LineRow {
                text: "Test Python"
                onClicked: result = TestPy.lance() + " msecs";
            }
        }
    }
}
