#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys
from PyQt5.QtCore import pyqtSlot, QVariant, QObject
from PyQt5.QtWidgets import QApplication
from PyQt5.QtQml import QQmlApplicationEngine
import time


class Tester(QObject):
    def __init__(self, parent=None):
        super(Tester, self).__init__(parent)

        self.a = 3
        self.b = 2

    def somme(self):
        return self.a+self.b

    def diff(self):
        return self.a-self.b

    def multiplie(self):
        return self.a*self.b

    def divise(self):
        return self.a/self.b

    def test(self):
        if self.a < self.b:
            return self.b
        else:
            return self.a


    @pyqtSlot(result=QVariant)
    def lance(self):

        tps1 = time.clock()
        for i in range(2000000):
            self.somme()
            self.diff()
            self.multiplie()
            self.divise()
            self.test()

        tps2 = time.clock()
        tps = "%.f"%((tps2 - tps1)*1000)
        return tps







if __name__ == "__main__":
    app = QApplication(sys.argv)
    engine = QQmlApplicationEngine()
    ctx = engine.rootContext()

    engine.load("main.qml")

    ctx.setContextProperty("titre", "QML lancé avec Python")

    win = engine.rootObjects()[0]
    tester = Tester()
    ctx.setContextProperty("TestPy", tester)
    win.show()

    sys.exit(app.exec_())

