import QtQuick 2.2

Rectangle {
    width: 100
    height: 27

    property bool editable: true
    property alias textInput: input
    property alias text: input.text
    property alias placeholder: placeholderArea.text
    signal editingFinished()

    function setValue(value) {
        text = value ? value : "";
    }

    color: input.activeFocus ? "#828282" : "#545454"
    radius: 3
    smooth: true

    Rectangle {
        id: content
        anchors.fill: parent
        anchors.margins: 2
        radius: 2
        color: "#FFFFFF"
        smooth: true
        clip: true

        TextInput {
            id: input
            anchors {
                left: parent.left
                right: parent.right
                verticalCenter: parent.verticalCenter
                margins: 4
            }
            readOnly: !editable
            opacity: enabled ? 1 : 0.5
            selectByMouse: true
            smooth: true
            font.bold: enabled
            font.pixelSize: 13
            font.italic: false
            renderType: Text.NativeRendering

            Keys.onPressed: {
                if (event.key == Qt.Key_Return || event.key == Qt.Key_Enter) {
                    parent.parent.editingFinished();
                }
            }
        }

        Text {
            id: placeholderArea
            anchors.fill: input
            visible: input.text == ""
            opacity: 0.4
            smooth: true
            font.pixelSize: 13
            font.italic: true
            renderType: Text.NativeRendering
        }
    }
}
