<?php
	// Import d'un fichier xml dont le nom est pass en argument
	function xml_in($file) {
	
		// Ouverture du fichier
		if (!$fh= @fopen($file, "r")) return false;
		
		// Lecture et stockage
		$raw = @fread($fh, filesize($file));
		@fclose($fh);
		return xml_in_r($raw);
	}
	
	// Fonction rcursive qui analyse la structure du fichier xml
	function xml_in_r($raw) {
		// Pattern matching des lments xml
		preg_match_all("/<([^>]+)>(.*?)<\/\\1>/s", $raw, $matches);
		
		if (!count($matches[0])) {
			return html_entity_decode($raw);
		}
		
		$balises = Array();
		
		for ($i = 0; $i < min(count($matches[1]), count($matches[2])); ++$i) {
			$j = "";
			
			// Si cette entre existe dj, on incrmente jusqu' trouver la premire de libre.
			while (isset($balises[$matches[1][$i] . $j])) {
				($j) ? ++$j : ($j = 2);
			}
			
			$balises[$matches[1][$i] . $j] = xml_in_r($matches[2][$i]);
		}
		
		return $balises;	
	}
	
	// Export dans un fichier xml dont le nom est pass en argument ainsi que le contenu
	function xml_out($file, $content, $encoding = "ISO-8859-1", $version = "1.0") {
		$entete_xml = "<?xml version=\"$version\" encoding=\"$encoding\"?>\n";
		$xml = $entete_xml . xml_out_r($content);
		
		if (!$fh = @fopen($file, "w")) {
			return false;
		}

		@fwrite($fh, $xml);
		@fclose($fh);
		return true;
	}
	
	// Lecture de l'imbrication de tableaux, fonction rcursive
	function xml_out_r($content, $indent = "") {
	
		if (!is_array($content) and !is_object($content)) return $content;
		
		$xml = "";
		
		foreach ($content as $key => $value) {
			$key = htmlentities($key);
			
			if (is_array($value)) {
				$xml .= "\n$indent<$key>" . xml_out_r($value, $indent . "  ") . "\n$indent</$key>";
			}
			else {
				$value = htmlentities($value);
				$xml .= "\n$indent<$key>$value</$key>";
			}
		}
		
		return $xml;
	}
?>