<?php
	include("f_Articles.php");
	// Fonctions crivant les fichiers temporaires

	// Cr le fichier d'information utilisateur
	function save_inscrit(session $session, $login, $mdp, $nom, $prenom,
		$membre = "", $civilite = "",$titre = "", $profession = "", $date_naissance = "",
		$id_inscrit = "", $structure = "", $motivations = "", $statut_non_smv = "",
		$mode_exercice = "", $complement_profession = "", $complement_secteur_prive = "", $cotisation = "") {

		$file_path = TEMPORARY_DIR . "inscrit_" . $session->id_session . ".xml";

		$info_inscrit = Array(
			"inscrit" => Array(
				"login" => $login,
				"mdp" => (($mdp) ? md5($mdp) : ""),
				"nom" => $nom,
				"prenom" => $prenom,
				"membre" => $membre,
				"civilite" => $civilite,
				"titre" => $titre,
				"statut_non_smv" => $statut_non_smv,
				"profession" => $profession,
				"mode_exercice" => $mode_exercice,
				"complement_profession" => $complement_profession,
				"complement_secteur_prive" => $complement_secteur_prive,
				"date_naissance" => $date_naissance,
				"structure" => $structure,
				"motivations" => $motivations,
				"id_inscrit" => $id_inscrit,
				"id_session" => $session->id_session,
				"ref_inscrit" => $session->id_inscrit,
				"cotisation" => $cotisation,
				"date_soumission" => date("U")
			)
		);

		return xml_out($file_path, $info_inscrit);
	}

	// Cr le fichier des structures
	function save_structures(session $session, $nom, $numero,
		$type = STRUCT_PERSONNELLE, $id_structure = "", $url = "", $telephone = "", $fax = "", $email = "") {

		$file_path = TEMPORARY_DIR . "structures_" . $session->id_session . ".xml";
		$structures = Array();

		if (file_exists($file_path)) {
			$structures = xml_in($file_path);
			@unlink($file_path);
		}

		$structure = Array(
			"nom" => $nom,
			"id_structure_temp" => $numero, // identifiant temporaire
			"type_structure" => $type,
			"url" => $url,
			"telephone" => $telephone,
			"fax" => $fax,
			"email" => $email,
			"id_structure" => $id_structure,
			"ref_inscrit" => $session->id_inscrit,
			"date_soumission" => date("U")
		);

		$suffixe = 1;

		while (isset($structures["structures"]["structure$suffixe"])) {
			++$suffixe;
		}

		$structures["structures"]["structure$suffixe"] = $structure;
		return xml_out($file_path, $structures);
	}

	// Cr le fichier des fonctions
	function save_fonctions(session $sessionf, $id_fonction_temp,	$ref_structure_temp,	$fonction = "",
		$tel_mobile = "", $service = "", $ref_structure = "", $id_fonction = "", $type_adresse = COORD_NO_FLAG) {

		// Utilis pour pouvoir avoir une session factice avec id non logg (modif admin) et l'id de la personne modifiant l'info
		global $session;
		$file_path = TEMPORARY_DIR . "fonctions_" . $session->id_session . ".xml";
		$fonctions = Array();

		if (file_exists($file_path)) {
			$fonctions = xml_in($file_path);
			@unlink($file_path);
		}

		$fonction = Array(
			"id_fonction_temp" => $id_fonction_temp, // identifiant temporaire
			"ref_structure_temp" => $ref_structure_temp, // FK temporaire
			"ref_structure" => $ref_structure, // FK existant, si non nul prends le pas sur ref_temp_structure
			"fonction" => $fonction,
			"tel_mobile" => $tel_mobile,
			"service" => $service,
			"id_fonction" => $id_fonction,
			"type_adresse" => $type_adresse,
			"ref_membre" => $sessionf->id_inscrit,
			"ref_inscrit" => $session->id_inscrit,
			"date_soumission" => date("U")
		);

		$suffixe = 1;

		while (isset($fonctions["fonctions"]["fonction$suffixe"])) ++$suffixe;

		$fonctions["fonctions"]["fonction$suffixe"] = $fonction;
		return xml_out($file_path, $fonctions);
	}

	// Cr le fichier des adresses
	function save_adresses(session $session, $ref_fonction_temp, $num_voie = "",
		$type_voie = "",	$adresse = "", $CP = "", $ville = "", $cedex = "", $BP = "", $pays = "",
		$type = COORD_PRINCIPALE, $ref_fonction = "", $id_adresse = "", $id_structure = "", $adresse2 = "", $num_voie_plus = "") {

		$file_path = TEMPORARY_DIR . "adresses_" . $session->id_session . ".xml";
		$adresses = Array();

		if (file_exists($file_path)) {
			$adresses = xml_in($file_path);
			@unlink($file_path);
		}

		$adresse = Array(
			"ref_fonction_temp" => $ref_fonction_temp, // FK temporaire
			"ref_fonction" => $ref_fonction, // FK existant, si non nul prends le pas sur ref_temp_structure
			"num_voie" => $num_voie,
			"num_voie_plus" => $num_voie_plus,
			"type_voie" => $type_voie,
			"adresse" => $adresse,
			"adresse2" => $adresse2,
			"CP" => $CP,
			"ville" => $ville,
			"cedex" => $cedex,
			"BP" => $BP,
			"pays" => $pays,
			"type_adresse" => $type,
			"id_adresse" => $id_adresse,
			"ref_structure" => $id_structure,
			"ref_inscrit" => $session->id_inscrit,
			"date_soumission" => date("U")
		);

		$suffixe = 1;

		while (isset($adresses["adresses"]["adr$suffixe"])) {
			++$suffixe;
		}

		$adresses["adresses"]["adr$suffixe"] = $adresse;
		return xml_out($file_path, $adresses);
	}

	// Cr le fichier des tlphones
	function save_telephones(session $session, $ref_fonction_temp,
		$tel, $type = COORD_PRINCIPALE, $ref_fonction = "", $id_telephone = "") {

		$file_path = TEMPORARY_DIR . "telephones_" . $session->id_session . ".xml";
		$telephones = Array();

		if (file_exists($file_path)) {
			$telephones = xml_in($file_path);
			@unlink($file_path);
		}

		$telephone = Array(
			"ref_fonction_temp" => $ref_fonction_temp, // FK temporaire
			"ref_fonction" => $ref_fonction, // FK existant, si non nul prends le pas sur ref_temp_structure
			"numero" => $tel,
			"type_telephone" => $type,
			"id_telephone" => $id_telephone,
			"ref_inscrit" => $session->id_inscrit,
			"date_soumission" => date("U")
		);

		$suffixe = 1;

		while (isset($telephones["telephones"]["telephone$suffixe"])) {
			++$suffixe;
		}

		$telephones["telephones"]["telephone$suffixe"] = $telephone;
		return xml_out($file_path, $telephones);
	}

	// Cr le fichier des emails
	function save_emails(session $session, $numero_fonction, $email,
		$NL = 0, $type = COORD_PUBLIQUE, $ref_fonction = "", $id_email = "") {

		$file_path = TEMPORARY_DIR . "emails_" . $session->id_session . ".xml";
		$emails = Array();

		if (file_exists($file_path)) {
			$emails = xml_in($file_path);
			@unlink($file_path);
		}

		// Si on coche "courriel public"
		if (isset($_POST['type_email'])) {
			$type = $_POST['type_email'];
		}

		$email = Array(
			"ref_fonction_temp" => $numero_fonction, // FK temporaire
			"ref_fonction" => $ref_fonction, // FK existant, si non nul prends le pas sur ref_fonction_temp
			"email" => $email,
			"NL" => $NL,
			"type_email" => $type,
			"id_email" => $id_email,
			"ref_inscrit" => $session->id_inscrit,
			"date_soumission" => date("U")
		);

		$suffixe = 1;

		while (isset($emails["emails"]["email$suffixe"])) ++$suffixe;

		$emails["emails"]["email$suffixe"] = $email;
		return xml_out($file_path, $emails);
	}

	// Cr le fichier d'un article
	function save_article(DB $db, session $session, display $dpl, $id_categorie,
		$titre, $contenu, $resume = "", $type = 1, $droits = DROITS_VISITEUR,
		$id_article = "", $date_debut_affichage = "", $date_fin_affichage = "",
		$date_debut = "", $date_fin = "", $nom_contact = "", $email_contact = "", $lieux = "") {

		$path = "article_" . $session->id_session . ".xml";
		$file_path =  TEMPORARY_DIR . "article_" . $session->id_session . ".xml";
		$file_path_R =  TEMPORARY_DIR .'ART/'. "article_" . $session->id_session . ".xml";
		$error = false;
		$droits_courant = $session->droits;

		if (file_exists($file_path)) {
			@unlink($file_path); // Suppression du fichier prcdent
		}

		$info_article = Array(
			"article" => Array(
				"ref_categorie" => $id_categorie,
				"titre" => $titre,
				"contenu" => $contenu,
				"resume" => $resume,
				"type_article" => $type,
				"droits" => $droits,
				"ref_auteur" => $session->id_inscrit,
				"id_article" => $id_article,
				"date_debut_affichage" => $date_debut_affichage,
				"date_fin_affichage" => $date_fin_affichage,
				"date_debut" => $date_debut,
				"date_fin" => $date_fin,
				"nom_contact" => $nom_contact,
				"email_contact" => $email_contact,
				"lieux" => $lieux,
				"ref_inscrit" => $session->id_inscrit,
				"date_soumission" => date("U")
			)
		);
		f_OutArticles( $path );
		xml_out($file_path, $info_article);
		xml_out($file_path_R, $info_article);
		return true;
	}

	// Cr le fichier des articles
	function save_articles(DB $db, session $session, display $dpl, $id_categorie,
		$titre, $contenu, $resume = "", $type = 1, $droits = DROITS_VISITEUR,
		$id_article = "", $date_debut_affichage = "", $date_fin_affichage = "",
		$date_debut = "", $date_fin = "", $nom_contact = "", $email_contact = "", $lieux = "") {

		$file_path =  TEMPORARY_DIR . "articles_" . $session->id_session . ".xml";
		$error = false;
		$droits_courant = $session->droits;

		if (file_exists($file_path)) {
			$articles = xml_in($file_path);
			@unlink($file_path); // Suppression du fichier prcdent
		}

		$article = Array(
			"ref_categorie" => $id_categorie,
			"titre" => $titre,
			"contenu" => $contenu,
			"resume" => $resume,
			"type_article" => $type,
			"droits" => $droits,
			"ref_auteur" => $session->id_inscrit,
			"id_article" => $id_article,
			"date_debut_affichage" => $date_debut_affichage,
			"date_fin_affichage" => $date_fin_affichage,
			"date_debut" => $date_debut,
			"date_fin" => $date_fin,
			"nom_contact" => $nom_contact,
			"email_contact" => $email_contact,
			"lieux" => $lieux,
			"ref_inscrit" => $session->id_inscrit,
			"date_soumission" => date("U")
		);

		$suffixe = 1;

		while (isset($articles["articles"]["article$suffixe"])) ++$suffixe;

		$articles["articles"]["article$suffixe"] = $article;

		//f_OutArticles( $file_path );
		return xml_out($file_path, $articles);
	}

	// Cr le fichier d'une structure personnelle et de sa fonction fictive associe
	function save_structure_personnelle(session $session, $nom, $prenom, $tel_mobile, $id_structure = "", $id_fonction = "") {
		$id_structure_temp = (!$id_structure) ? last_id_structure_temp($session) + 1 : "";
		save_structures($session, $nom . "_" . $prenom, $id_structure_temp, STRUCT_PERSONNELLE, $id_structure);
		$id_fonction_temp = (!$id_fonction) ? last_id_fonction_temp($session) + 1 : "";
		save_fonctions($session, $id_fonction_temp, $id_structure_temp, "", $tel_mobile, "",	$id_structure, $id_fonction);
	}

	// Cr le fichier de fiche cvi
	function save_cvi(session $session, $id_structure, $nom, $description = "", $horaires = "", $num_voie = "",
		$num_voie_plus = "", $type_voie = "", $adresse = "", $adresse2 = "", $BP = "", $CP = "", $ville = "", $cedex = "",
		$pays = "", $telephone = "", $fax = "", $email = "", $url = "", $remarques_horaires = "", $acces = "", $RDV = 0, $responsable = "") {

		$file_path = TEMPORARY_DIR . "fiche_cvi_" . $session->id_session . ".xml";

		$info_cvi = Array(
			"cvi" => Array(
				"id_structure" => $id_structure,
				"nom" => $nom,
				"contenu" => $description,
				"resume" => $horaires,
				"num_voie" => $num_voie,
				"num_voie_plus" => $num_voie_plus,
				"type_voie" => $type_voie,
				"adresse" => $adresse,
				"adresse2" => $adresse2,
				"BP" => $BP,
				"CP" => $CP,
				"ville" => $ville,
				"cedex" => $cedex,
				"pays" => $pays,
				"responsable" => $responsable,
				"telephone" => $telephone,
				"fax" => $fax,
				"email" => $email,
				"url" => $url,
				"remarques_horaires" => $remarques_horaires,
				"acces" => $acces,
				"RDV" => $RDV,
				"ref_inscrit" => $session->id_inscrit,
				"date_soumission" => date("U")
			)
		);

		return xml_out($file_path, $info_cvi);
	}

	// Efface l'article dont le nom est pass en argument
	function wipe_article(DB $db, session $session, Display $dpl, $name) {
		$articles = get_articles($session);
		$articles = $articles['articles'];

		del_articles($session);
		$i = 1;

		foreach ($articles as $name_article => $article) {
			if ($name_article == $name) {
				continue;
			}

			save_articles($db, $session, $dpl, $article['ref_categorie'],
				$article['titre'], $article['contenu'], $article['resume'], $article['type_article'], $article['droits'],
				$article['id_article'], $article['date_debut_affichage'], $article['date_fin_affichage'],
				$article['date_debut'], $article['date_fin'], $article['nom_contact'], $article['email_contact'], $article['lieux']);

			if ($name_article == "article$i") {
				continue;
			}

			$path_src = TEMPORARY_FILES_DIR . $session->id_session . "_piece_jointe_${name_article}_";
			$path_dest = TEMPORARY_FILES_DIR . $session->id_session . "_piece_jointe_article${i}_";

			for ($i = 1; $i < 100; ++$i) {
				$path_jpg_src = $path_src . $i . ".jpg";
				$path_jpg_dest = $path_dest . $i . ".jpg";
				$path_pdf_src = $path_src . $i . ".pdf";
				$path_pdf_dest = $path_dest . $i . ".pdf";
				$path_doc_src = $path_src . $i . ".doc";
				$path_doc_dest = $path_dest . $i . ".doc";
				$path_rtf_src = $path_src . $i . ".rtf";
				$path_rtf_dest = $path_dest . $i . ".rtf";
				$path_ppt_src = $path_src . $i . ".ppt";
				$path_ppt_dest = $path_dest . $i . ".ppt";

				if (file_exists($path_jpg_src) && @copy($path_jpg_src, $path_jpg_dest)) {
					@unlink($path_jpg_src);
				}

				if (file_exists($path_pdf_src) && @copy($path_pdf_src, $path_pdf_dest)) {
					@unlink($path_pdf_src);
				}

				if (file_exists($path_doc_src) && @copy($path_doc_src, $path_doc_dest)) {
					@unlink($path_doc_src);
				}

				if (file_exists($path_rtf_src) && @copy($path_rtf_src, $path_rtf_dest)) {
					@unlink($path_rtf_src);
				}

				if (file_exists($path_ppt_src) && @copy($path_ppt_src, $path_ppt_dest)) {
					@unlink($path_ppt_src);
				}
			}
		}
	}

	// Efface toutes les donnes temporaire lies  une structure personnelle
	function wipe_donnees_personnelles(session $session) {
		$structures = get_structures($session);
		$structures = $structures['structures'];
		$id_structure_temp = "";
		$id_fonction_temp = "";
		del_structures($session);

		if (!$structures) {
			return;
		}

		foreach ($structures as $structure) {

			if ($structure['type_structure'] & STRUCT_PERSONNELLE) {
				$id_structure_temp = $structure['id_structure_temp'];
				continue;
			}

			save_structures($session, $structure['nom'],
				$structure['id_structure_temp'],	$structure['type_structure'], $structure['id_structure']);
		}

		$fonctions = get_fonctions($session);
		$fonctions = $fonctions['fonctions'];
		del_fonctions($session);

		if (!($id_structure_temp && $fonctions)) {
			return;
		}

		foreach ($fonctions as $fonction) {

			if ($fonction['ref_structure_temp'] == $id_structure_temp) {
				$id_fonction_temp = $fonction['id_fonction_temp'];
				continue;
			}

			save_fonctions($session, $fonction['id_fonction_temp'], $fonction['ref_structure_temp'],
				$fonction['fonction'],	$tel_mobile = $fonction['tel_mobile'], $fonction['service'],
				$fonction['ref_structure'], $fonction['id_fonction'], $fonction['type_adresse']);
		}

		if (!$id_fonction_temp) {
			return;
		}

		// Nouvel id de fonction temporaire
		$adresses = get_adresses($session);
		$adresses = ($adresses) ? $adresses['adresses'] : "";
		$telephones = get_telephones($session);
		$telephones = ($telephones) ? $telephones['telephones'] : "";
		$emails = get_emails($session);
		$emails = ($emails) ? $emails['emails'] : "";
		del_adresses($session);
		del_telephones($session);
		del_emails($session);

		if ($adresses) {

			foreach ($adresses as $adresse) {

				if ($adresse['ref_fonction_temp'] == $id_fonction_temp) {
					continue;
				}

				save_adresses($session, $adresse['ref_fonction_temp'], $adresse['num_voie'], $adresse['type_voie'],
					$adresse['adresse'], $adresse['CP'], $adresse['ville'], $adresse['cedex'], $adresse['BP'], $adresse['pays'],
					$adresse['type_adresse'], $adresse['ref_fonction'], $adresse['id_adresse'], $adresse['ref_structure']);
			}
		}

		if ($telephones) {

			foreach ($telephones as $telephone) {

				if ($telephone['ref_fonction_temp'] == $id_fonction_temp) {
					continue;
				}

				save_telephones($session, $telephone['ref_fonction_temp'], $telephone['numero'],
					$telephone['type_telephone'], $telephone['ref_fonction'], $telephone['id_telephone']);
			}
		}

		if ($emails) {

			foreach ($emails as $email) {

				if ($email['ref_fonction_temp'] == $id_fonction_temp) {
					continue;
				}

				save_emails($session, $email['ref_fonction_temp'], $email['email'], $email['NL'],
					$email['type_email'], $email['ref_fonction'], $email['id_email']);
			}
		}
	}

	// Efface la structure temporaire passe en argument
	function wipe_structure_only_by_id(session $session, $id_structure_temp, $existante = false) {
		$structures = get_structures($session);
		del_structures($session);

		if (!$structures) {
			return;
		}

		$structures = $structures['structures'];

		foreach ($structures as $structure) {

			if (($structure['id_structure'] == $id_structure_temp && $existante)
				|| ($structure['id_structure_temp'] == $id_structure_temp && !$existante)) {

				continue;
			}

			save_structures($session, $structure['nom'], $structure['id_structure_temp'], $structure['type_structure'], $structure['id_structure'], $structure['url']);
		}
	}

	// Efface toutes les donnes temporaire lies  la structure pass en argument
	function wipe_structure_by_id(session $session, $id_structure_temp, $existante = false) {
		$id_fonction_temp = "";
		$fonctions = get_fonctions($session);
		del_fonctions($session);

		if (!$fonctions) {
			return;
		}

		$fonctions = $fonctions['fonctions'];

		foreach ($fonctions as $fonction) {

			if (($fonction['ref_structure'] == $id_structure_temp && $existante)
				|| ($fonction['ref_structure_temp'] == $id_structure_temp && !$existante)) {

				$id_fonction_temp = $fonction['id_fonction_temp'];
				continue;
			}

			save_fonctions($session, $fonction['id_fonction_temp'], $fonction['ref_structure_temp'],
				$fonction['fonction'],	$tel_mobile = $fonction['tel_mobile'], $fonction['service'],
				$fonction['ref_structure'], $fonction['id_fonction'], $fonction['type_adresse']);
		}

		if (!$id_fonction_temp) {
			return;
		}

		// Nouvel id temporaire
		$adresses = get_adresses($session);
		$adresses = ($adresses) ? $adresses['adresses'] : "";
		$telephones = get_telephones($session);
		$telephones = ($telephones) ? $telephones['telephones'] : "";
		$emails = get_emails($session);
		$emails = ($emails) ? $emails['emails'] : "";
		del_adresses($session);
		del_telephones($session);
		del_emails($session);

		if ($adresses) {

			foreach ($adresses as $adresse) {

				if ($adresse['ref_fonction_temp'] == $id_fonction_temp) {
					continue;
				}

				save_adresses($session, $adresse['ref_fonction_temp'], $adresse['num_voie'], $adresse['type_voie'],
					$adresse['adresse'], $adresse['CP'], $adresse['ville'], $adresse['cedex'], $adresse['BP'], $adresse['pays'],
					$adresse['type_adresse'], $adresse['ref_fonction'], $adresse['id_adresse'], $adresse['ref_structure']);
			}
		}

		if ($telephones) {

			foreach ($telephones as $telephone) {

				if ($telephone['ref_fonction_temp'] == $id_fonction_temp) {
					continue;
				}

				save_telephones($session, $telephone['ref_fonction_temp'], $telephone['numero'],
					$telephone['type_telephone'], $telephone['ref_fonction'], $telephone['id_telephone']);
			}
		}

		if ($emails) {

			foreach ($emails as $email) {

				if ($email['ref_fonction_temp'] == $id_fonction_temp) {
					continue;
				}

				save_emails($session, $email['ref_fonction_temp'], $email['email'],
					$email['NL'], $email['type_email'], $email['ref_fonction'], $email['id_email']);
			}
		}
	}

	// Cr le fichier des questions
	function save_questions(session $session, $id_question_temp, $texte = "", $presentation = 1, $id_question = "") {
		$file_path = TEMPORARY_DIR . "questions_" . $session->id_session . ".xml";
		$questions = Array();

		if (file_exists($file_path)) {
			$questions = xml_in($file_path);
			@unlink($file_path);
		}

		$question = Array(
			"id_question_temp" => $id_question_temp, // identifiant temporaire
			"id_question" => $id_question,
			"texte" => $texte,
			"presentation" => $presentation,
			"ref_inscrit" => $session->id_inscrit,
			"date_soumission" => date("U")
		);

		$suffixe = 1;

		while (isset($questions["questions"]["question$suffixe"])) {
			++$suffixe;
		}

		$questions["questions"]["question$suffixe"] = $question;
		return xml_out($file_path, $questions);
	}

	// Cr le fichier des options
	function save_options(session $session, $ref_question_temp, $libelle = "", $id_option = "") {
		$file_path = TEMPORARY_DIR . "options_" . $session->id_session . ".xml";
		$options = Array();

		if (file_exists($file_path)) {
			$options = xml_in($file_path);
			@unlink($file_path);
		}

		$option = Array(
			"ref_question_temp" => $ref_question_temp, // identifiant temporaire
			"id_option" => $id_option,
			"libelle" => $libelle,
			"ref_inscrit" => $session->id_inscrit,
			"date_soumission" => date("U")
		);

		$suffixe = 1;

		while (isset($options["options"]["option$suffixe"])) {
			++$suffixe;
		}

		$options["options"]["option$suffixe"] = $option;
		return xml_out($file_path, $options);
	}

	// Supprime les questions et les options rattaches dont l'id temporaire est pass en argument
	function wipe_question_by_id(session $session, $id_question_temp) {
		$questions = get_questions($session);
		del_questions($session);

		if ($questions) {
			$questions = $questions['questions'];

			foreach ($questions as $question) {

				if ($question['id_question_temp'] == $id_question_temp) {
					continue;
				}

				save_questions($session, $question['id_question_temp'], $question['texte'], $question['presentation'], $question['id_question']);
			}
		}

		$options = get_options($session);
		del_options($session);

		if ($options) {
			$options = $options['options'];

			foreach ($options as $option) {

				if ($option['ref_question_temp'] == $id_question_temp) {
					continue;
				}

				save_options($session, $option['ref_question_temp'], $option['libelle'], $option['id_option']);
			}
		}
	}
	
	// Sauvegarde le rapport d'alerte pidmiologique en cours
	function save_alertes(session $session) {
		$file_path = TEMPORARY_DIR . "alerte_" . $session->id_session . ".srl";
		$_SESSION['alerte'] = array();
		
		// Reconstruction du tableau POST
		foreach ($_POST as $key => $value) {
			if (substr($key, 0, 5) == "pays_") {
				$continent = substr($key, 5);
				$continent = str_replace("_", " ", $continent);
				
				if (!isset($_POST['pays'][$continent])) {
					$_POST['pays'][$continent] = array();
				}
				
				$_POST['pays'][$continent] = $value;
			}
			
			if (substr($key, 0, 7) == "source_") {
				$continent = substr($key, 7);
				$continent = str_replace("_", " ", $continent);
				
				if (!isset($_POST['source'][$continent])) {
					$_POST['source'][$continent] = array();
				}
				
				$_POST['source'][$continent] = $value;
			}
			
			if (substr($key, 0, 12) == "description_") {
				$continent = substr($key, 12);
				$continent = str_replace("_", " ", $continent);
				
				if (!isset($_POST['description'][$continent])) {
					$_POST['description'][$continent] = array();
				}
				
				$_POST['description'][$continent] = $value;
			}
			
			if (substr($key, 0, 16) == "date_soumission_") {
				$continent = substr($key, 16);
				$continent = str_replace("_", " ", $continent);
				
				if (!isset($_POST['date_soumission'][$continent])) {
					$_POST['date_soumission'][$continent] = array();
				}
				
				$_POST['date_soumission'][$continent] = $value;
			}
			
			if (substr($key, 0, 12) == "ref_article_") {
				$continent = substr($key, 12);
				$continent = str_replace("_", " ", $continent);
				
				if (!isset($_POST['ref_article'][$continent])) {
					$_POST['ref_article'][$continent] = array();
				}
				
				$_POST['ref_article'][$continent] = $value;
			}
		}

		// Rcupration des donnes du formulaire
		if (isset($_POST['pays'])) {	
			foreach ($_POST['pays'] as $continent => $pays) {
				$_SESSION['alerte'][$continent] = array();
				
				for ($i = 0; $i < count($pays); ++$i) {
					$_SESSION['alerte'][$continent][$i] = array();
					$_SESSION['alerte'][$continent][$i]['pays'] = $pays[$i];
					$_SESSION['alerte'][$continent][$i]['continent'] = $continent;
				}
			}
			
			foreach ($_POST['source'] as $continent => $sources) {
				for ($i = 0; $i < count($sources); ++$i) {
					$_SESSION['alerte'][$continent][$i]['source'] = $sources[$i];
				}
			}
			
			foreach ($_POST['description'] as $continent => $descriptions) {
				for ($i = 0; $i < count($descriptions); ++$i) {
					$_SESSION['alerte'][$continent][$i]['description'] = $descriptions[$i];
				}
			}
			
			foreach ($_POST['date_soumission'] as $continent => $dates) {
				for ($i = 0; $i < count($dates); ++$i) {
					$_SESSION['alerte'][$continent][$i]['date_soumission'] = $dates[$i];
				}
			}
			
			foreach ($_POST['ref_article'] as $continent => $articles) {
				for ($i = 0; $i < count($articles); ++$i) {
					$_SESSION['alerte'][$continent][$i]['ref_article'] = $articles[$i];
				}
			}
		}

		@file_put_contents($file_path, serialize($_SESSION['alerte']));
	}
?>