<?php
	// Fonctions lisant les fichiers temporaires
	// Retourne le fichier des informations utilisateur
	function get_inscrit(session $session) {
		return get_temp($session, "inscrit");
	}
	
	// Retourne le fichier des structures
	function get_structures(session $session) {
		return get_temp($session, "structures");
	}
	
	// Retourne le fichier des fonctions
	function get_fonctions(session $session) {
		return get_temp($session, "fonctions");
	}
	
	// Retourne le fichier des adresses
	function get_adresses(session $session) {
		return get_temp($session, "adresses");
	}
	
	// Retourne le fichier des tlphones
	function get_telephones(session $session) {
		return get_temp($session, "telephones");
	}

	// Retourne le fichier des emails
	function get_emails(session $session) {
		return get_temp($session, "emails");
	}

	// Retourne le fichier d'un article
	function get_article(session $session) {
		return get_temp($session, "article");
	}
	
	// Retourne le fichier d'un article
	function get_articles(session $session) {
		return get_temp($session, "articles");
	}
	
	// Retourne le fichier d'une fiche CVI
	function get_cvi(session $session) {
		return get_temp($session, "fiche_cvi");
	}
	
	// Retourne le fichier des Questions
	function get_questions(session $session, $name = false) {
		if ($name !== false) {
			$file_path = TEMPORARY_DIR . "questions_" . $session->id_session . "_${name}.xml";
			return xml_in($file_path);
		}
		else {
			return get_temp($session, "questions");
		}
	}
	
	// Retourne le fichier des Options
	function get_options(session $session, $name = false) {
		if ($name !== false) {
			$file_path = TEMPORARY_DIR . "options_" . $session->id_session . "_${name}.xml";
			return xml_in($file_path);
		}
		else {
			return get_temp($session, "options");
		}
	}
	
	// Retourne le fichier temporaire pass en argument
	function get_temp(session $session, $type) {
		$file_path = TEMPORARY_DIR . $type . "_" . $session->id_session . ".xml";
		return xml_in($file_path);
	}
	
	// Retourne l'identifiant de la fiche cvi temporaire actuelle
	function get_cvi_id(session $session) {
	
		if (!cvi_pending($session)) return 0;
		
		$cvi = get_cvi($session);
		
		if (isset($cvi['cvi'])) {
			return	$cvi['cvi']['id_structure'];
		}
	}
	
	// Retourne l'email principal
	function get_email_principal(session $session) {
		$emails = get_emails($session);
		
		if (!$emails) {
			return;
		}
		
		$emails = $emails['emails'];
		
		foreach ($emails as $email) {		
			if ($email['type_email'] & COORD_PRINCIPALE) {
				return $email;
			}
		}
	}
	
	// Retourne l'adresse principale
	function get_adresse_principale(session $session) {
		$adresses = get_adresses($session);
		
		if (!$adresses) {
			return 'Ville non renseigne';
		}
		
		$adresses = $adresses['adresses'];
		
		foreach ($adresses as $adresse) {		
			if ($adresse['type_adresse'] & COORD_PRINCIPALE) {
				return $adresse;
			}
		}
		
		return $adresse;
	}
	
	// Retourne l'email personnel
	function get_email_personnel(session $session) {
		$ref_structure_perso = "";
		$ref_fonction_perso = "";
		$structures = get_structures($session);
		$fonctions = get_fonctions($session);
		$emails = get_emails($session);
		$email_perso = "";
		
		if ($structures) {
			
			$structures = $structures['structures'];
			
			foreach ($structures as $structure) {
				
				if ($structure['type_structure'] & STRUCT_PERSONNELLE) {
					$ref_structure_perso = $structure['id_structure_temp'];
					break;
				}
			}
		}
		
		if ($ref_structure_perso && $fonctions) {
			$fonctions = $fonctions['fonctions'];
			
			foreach ($fonctions as $fct) {
				
				if ($fct['ref_structure_temp'] == $ref_structure_perso) {
					$ref_fonction_perso = $fct['id_fonction_temp'];
					break;
				}
			}
		}
		
		if ($ref_fonction_perso && $emails) {
			$emails = $emails['emails'];
			
			foreach ($emails as $eml) {
				if ($eml['ref_fonction_temp'] == $ref_fonction_perso) {
					$email_perso = $eml;
					break;
				}
			}
		}
		
		return $email_perso;
	}
	
	// Retourne le dernier id temporaire du fichier de structures
	function last_id_structure_temp(session $session) {
		$structures = get_structures($session);
		$last_id = 0;
		
		if (!$structures || !is_array($structures['structures'])) {
			return 0;
		}
		
		foreach ($structures['structures'] as $key => $value) {
		
			if ($value['id_structure_temp'] > $last_id) {
				$last_id = $value['id_structure_temp'];
			}
		}
		
		return $last_id;
	}
	
	// Retourne le dernier id temporaire du fichier de fonctions
	function last_id_fonction_temp(session $session) {
		$fonctions = get_fonctions($session);
		$last_id = 0;
		
		if (!isset($fonctions['fonctions'])) {
			return 0;
		}
		
		foreach ($fonctions['fonctions'] as $key => $value) {
		
			if ($value['id_fonction_temp'] > $last_id) {
				$last_id = $value['id_fonction_temp'];
			}
		}
		
		return $last_id;
	}
	
	// Rcupre le rapport d'alerte pidmiologique en cours
	function get_alertes(session $session) {
		$file_path = TEMPORARY_DIR . "alerte_" . $session->id_session . ".srl";
		
		if (!file_exists($file_path)) {
			$_SESSION['alerte'] = array();
			return false;
		}
		else {		
			$_SESSION['alerte'] = unserialize(@file_get_contents($file_path));
			return $_SESSION['alerte'];
		}
	}
?>