<?php
	// Fonctions de manipulations des fichiers temporaires
	// Supprime les informations utilisateur temporaires pour la session passe en argument
	function del_inscrit(session $session) {
		return del_temp($session, "inscrit");
	}

	// Supprime les structures temporaires pour la session passe en argument
	function del_structures(session $session) {
		return del_temp($session, "structures");
	}

	// Supprime les fonctions temporaires pour la session passe en argument
	function del_fonctions(session $session) {
		return del_temp($session, "fonctions");
	}

	// Supprime les adresses temporaires pour la session passe en argument
	function del_adresses(session $session) {
		return del_temp($session, "adresses");
	}

	// Supprime les tlphones temporaires pour la session passe en argument
	function del_telephones(session $session) {
		return del_temp($session, "telephones");
	}

	// Supprime les emails temporaires pour la session passe en argument
	function del_emails(session $session) {
		return del_temp($session, "emails");
	}

	// Supprime la confirmation d'adresse principale pour la session passe en argument
	function del_adresse_principale_ok(session $session) {
		return del_temp($session, "adresse_principale_ok");
	}
	
	// Supprime la confirmation d'adresse facturation pour la session passe en argument
	function del_adresse_facturation_ok(session $session) {
		return del_temp($session, "adresse_facturation_ok");
	}

	// Supprime la confirmation de telephone principal pour la session passe en argument
	function del_telephone_principal_ok(session $session) {
		return del_temp($session, "telephone_principal_ok");
	}

	// Supprime la confirmation de finalisation d'inscription pour la session passe en argument
	function del_inscription_ok(session $session) {
		return del_temp($session, "inscription_ok");
	}

	// Supprime la mention de rappel de l'inscription
	function del_rappel_inscription_ok(session $session) {
		return del_temp($session, "rappel_inscription_ok");
	}

	// Supprime la confirmation de finalisation de pr-inscription pour la session passe en argument
	function del_pre_inscription_ok(session $session) {
		return del_temp($session, "pre_inscription_ok");
	}

	// Supprime la validation d'un article pour la session passe en argument
	function del_article_ok(session $session) {
		return del_temp($session, "article_ok");
	}

	// Supprime la confirmation d'email principal pour la session passe en argument
	function del_email_principal_ok(session $session) {
		return del_temp($session, "email_principal_ok");
	}

	// Supprime un article temporaire pour la session passe en argument
	function del_article(session $session) {
		del_temp($session, "article");
	}

	// Supprime les articles temporaires pour la session passe en argument
	function del_articles(session $session) {
		del_temp($session, "articles");
	}

	// Supprime une fiche CVI temporaire pour la session passe en argument
	function del_cvi(session $session) {
		del_temp($session, "fiche_cvi");
	}

	// Supprime les Questions temporaires pour la session passe en argument
	function del_questions(session $session, $name = false) {
		if ($name !== false) {
			$file_path = TEMPORARY_DIR . "questions_" . $session->id_session . "_${name}.xml";
			@unlink($file_path);
		}
		else {
			del_temp($session, "questions");
		}
	}

	// Supprime les Options temporaires pour la session passe en argument
	function del_options(session $session, $name = false) {
		if ($name !== false) {
			$file_path = TEMPORARY_DIR . "options_" . $session->id_session . "_${name}.xml";
			@unlink($file_path);
		}
		else {
			del_temp($session, "options");
		}
	}

	// Supprime un fichier temporaire pour la session passe en argument
	function del_temp(session $session, $type) {
		$file_path = TEMPORARY_DIR . $type . "_" . $session->id_session . ".xml";
		@unlink($file_path);
	}

	// Supprime les pices jointes temporaires
	function del_temp_files($session, $name = false) {
		if ($name !== false) {
			$path = TEMPORARY_FILES_DIR . $session->id_session . "_piece_jointe_${name}_";
		}
		else {
			$path = TEMPORARY_FILES_DIR . $session->id_session . "_piece_jointe_";
		}

		// Suppression des pices jointes
		for ($i = 1; $i < 100; ++$i) {

			$path_jpg = $path . $i . ".jpg";
			$path_pdf = $path . $i . ".pdf";
			$path_doc = $path . $i . ".doc";
			$path_rtf = $path . $i . ".rtf";
			$path_ppt = $path . $i . ".ppt";

			if (file_exists($path_jpg)) {
				@unlink($path_jpg);
				@unlink($path . $i . "jpg.name");
			}

			if (file_exists($path_pdf)) {
				@unlink($path_pdf);
				@unlink($path . $i . "pdf.name");
			}

			if (file_exists($path_doc)) {
				@unlink($path_doc);
				@unlink($path . $i . "doc.name");
			}

			if (file_exists($path_rtf)) {
				@unlink($path_rtf);
				@unlink($path . $i . "rtf.name");
			}
			
			if (file_exists($path_ppt)) {
				@unlink($path_ppt);
				@unlink($path . $i . "ppt.name");
			}
		}
	}

	// Retourne true si l'utilisateur courant  dj un article en cours de validation, false sinon
	function article_pending(session $session) {
		$file_path =  TEMPORARY_DIR . "article_" . $session->id_session . ".xml";
		return(file_exists($file_path));
	}

	// Retourne true si l'utilisateur courant  dj des informations utilisateurs en cours, false sinon
	function inscription_pending(session $session) {
		$file_path =  TEMPORARY_DIR . "inscrit_" . $session->id_session . ".xml";
		return(file_exists($file_path));
	}

	// Retourne true si l'utilisateur courant  dj une fiche cvi en cours, false sinon
	function cvi_pending(session $session) {
		$file_path =  TEMPORARY_DIR . "fiche_cvi_" . $session->id_session . ".xml";
		return(file_exists($file_path));
	}

	// Retourne true si l'utilisateur courant a achev la procdure d'inscription
	function inscription_achieved(session $session) {
		$inscrit_ok = inscription_pending($session);
		$adresse_ok = have_adresse_principale($session);
		$facturation_ok = have_adresse_facturation($session);
		return $inscrit_ok && $adresse_ok && $facturation_ok;
	}

	// Retourne true si l'utilisateur courant a achev et valid la procdure d'inscription
	function inscription_finalized(session $session) {
		$file_path = TEMPORARY_DIR . "inscription_ok_" . $session->id_session . ".xml";
		return file_exists($file_path);
	}

	// Retourne true si l'utilisateur courant a dj eut un rappel d'inscription
	function rappel_inscription_done(session $session) {
		$file_path = TEMPORARY_DIR . "rappel_inscription_ok_" . $session->id_session . ".xml";
		return file_exists($file_path);
	}

	// Retourne true si l'utilisateur courant a valid son article
	function article_finalized(session $session) {
		$file_path = TEMPORARY_DIR . "article_ok_" . $session->id_session . ".xml";
		return file_exists($file_path);
	}

	// Retourne true si l'utilisateur a sa procdure de pr-inscription valide
	function pre_inscription_validate(session $session) {
		$file_path = TEMPORARY_DIR . "pre_inscription_ok_" . $session->id_session . ".xml";
		return file_exists($file_path);
	}

	// Retourne true si l'utilisateur courant a renseign une adresse principale
	function have_adresse_principale(session $session) {
		$file_path = TEMPORARY_DIR . "adresse_principale_ok_" . $session->id_session . ".xml";
		return file_exists($file_path);
	}
	
	// Retourne true si l'utilisateur courant a renseign une adresse de facturation
	function have_adresse_facturation(session $session) {
		$file_path = TEMPORARY_DIR . "adresse_facturation_ok_" . $session->id_session . ".xml";
		return file_exists($file_path);
	}

	// Retourne true si l'utilisateur courant a renseign un tlphone principal
	function have_telephone_principal(session $session) {
		$file_path = TEMPORARY_DIR . "telephone_principal_ok_" . $session->id_session . ".xml";
		return file_exists($file_path);
	}

	// Retourne true si l'utilisateur courant a renseign au moins un email principal
	function have_email_principal(session $session) {
		$file_path = TEMPORARY_DIR . "email_principal_ok_" . $session->id_session . ".xml";
		return file_exists($file_path);
	}

	// Cr le fichier de confirmation d'une adresse principale
	function adresse_principale_ok(session $session) {
		$file_path = TEMPORARY_DIR . "adresse_principale_ok_" . $session->id_session . ".xml";
		$fh = @fopen($file_path, "w");
		@fclose($fh);
	}

	// Cr le fichier de confirmation d'une adresse de facturation
	function adresse_facturation_ok(session $session) {
		$file_path = TEMPORARY_DIR . "adresse_facturation_ok_" . $session->id_session . ".xml";
		$fh = @fopen($file_path, "w");
		@fclose($fh);
	}
	
	// Cr le fichier de confirmation d'inscription valide
	function inscription_ok(session $session) {
		$file_path = TEMPORARY_DIR . "inscription_ok_" . $session->id_session . ".xml";
		$fh = @fopen($file_path, "w");
		@fclose($fh);
	}

	// Cr le fichier de confirmation de rappel d'inscription
	function rappel_inscription_ok(session $session) {
		$file_path = TEMPORARY_DIR . "rappel_inscription_ok_" . $session->id_session . ".xml";
		$fh = @fopen($file_path, "w");
		@fclose($fh);
	}

	// Cr le fichier de confirmation d'un numro de tlphone principal
	function telephone_principal_ok(session $session) {
		$file_path = TEMPORARY_DIR . "telephone_principal_ok_" . $session->id_session . ".xml";
		$fh = @fopen($file_path, "w");
		@fclose($fh);
	}

	// Cr le fichier de confirmation d'un email principal
	function email_principal_ok(session $session) {
		$file_path = TEMPORARY_DIR . "email_principal_ok_" . $session->id_session . ".xml";
		$fh = @fopen($file_path, "w");
		@fclose($fh);
	}

	// Cr le fichier de finalisation de la pr-inscription
	function finalise_pre_inscription(session $session) {
		$file_path = TEMPORARY_DIR . "pre_inscription_ok_" . $session->id_session . ".xml";
		$fh = @fopen($file_path, "w");
		@fclose($fh);
	}

	// Cr le fichier de finalisation de l'inscription
	function finalise_inscription(session $session) {
		$file_path = TEMPORARY_DIR . "inscription_ok_" . $session->id_session . ".xml";
		$fh = @fopen($file_path, "w");
		@fclose($fh);
	}

	// Finalise un article
	function finalise_article(DB $db, session $session, display $dpl) {
		$article = get_article($session);
		$article = $article['article'];
		del_article($session);

		save_articles($db, $session, $dpl, $article['ref_categorie'], $article['titre'], $article['contenu'], $article['resume'], $article['type_article'],
			$article['droits'], $article['id_article'], $article['date_debut_affichage'], $article['date_fin_affichage'],
			$article['date_debut'], $article['date_fin'], $article['nom_contact'], $article['email_contact'], $article['lieux']);

		$articles = get_articles($session);

		foreach ($articles['articles'] as $name_article => $article);

		// Copie des pices jointes
		$path_src = TEMPORARY_FILES_DIR . $session->id_session . "_piece_jointe_";
		$path_dest = TEMPORARY_FILES_DIR . $session->id_session . "_piece_jointe_${name_article}_";

		for ($i = 1; $i < 100; ++$i) {
			$path_jpg_src = $path_src . $i . ".jpg";
			$path_jpg_dest = $path_dest . $i . ".jpg";
			$path_pdf_src = $path_src . $i . ".pdf";
			$path_pdf_dest = $path_dest . $i . ".pdf";
			$path_doc_src = $path_src . $i . ".doc";
			$path_doc_dest = $path_dest . $i . ".doc";
			$path_rtf_src = $path_src . $i . ".rtf";
			$path_rtf_dest = $path_dest . $i . ".rtf";
			$path_ppt_src = $path_src . $i . ".ppt";
			$path_ppt_dest = $path_dest . $i . ".ppt";

			if (file_exists($path_jpg_src) && @copy($path_jpg_src, $path_jpg_dest)) {
				@unlink($path_jpg_src);
				
				$path_src_filename = $path_src . $i . "jpg.name";
				$path_dest_filename = $path_dest . $i . "jpg.name";
				
				@copy($path_src_filename, $path_dest_filename);
				@unlink($path_src_filename);
			}

			if (file_exists($path_pdf_src) && @copy($path_pdf_src, $path_pdf_dest)) {
				@unlink($path_pdf_src);
				
				$path_src_filename = $path_src . $i . "pdf.name";
				$path_dest_filename = $path_dest . $i . "pdf.name";
				
				@copy($path_src_filename, $path_dest_filename);
				@unlink($path_src_filename);
			}

			if (file_exists($path_doc_src) && @copy($path_doc_src, $path_doc_dest)) {
				@unlink($path_doc_src);
				
				$path_src_filename = $path_src . $i . "doc.name";
				$path_dest_filename = $path_dest . $i . "doc.name";
				
				@copy($path_src_filename, $path_dest_filename);
				@unlink($path_src_filename);
			}

			if (file_exists($path_rtf_src) && @copy($path_rtf_src, $path_rtf_dest)) {
				@unlink($path_rtf_src);
				
				$path_src_filename = $path_src . $i . "rtf.name";
				$path_dest_filename = $path_dest . $i . "rtf.name";
				
				@copy($path_src_filename, $path_dest_filename);
				@unlink($path_src_filename);
			}

			if (file_exists($path_ppt_src) && @copy($path_ppt_src, $path_ppt_dest)) {
				@unlink($path_ppt_src);
				
				$path_src_filename = $path_src . $i . "ppt.name";
				$path_dest_filename = $path_dest . $i . "ppt.name";
				
				@copy($path_src_filename, $path_dest_filename);
				@unlink($path_src_filename);
			}
		}

		// Copie des questions, si c'est un sondage
		if ($article['type_article'] & DOC_SONDAGE) {
			$path_quest_src = TEMPORARY_DIR . "questions_" . $session->id_session . ".xml";
			$path_quest_dest = TEMPORARY_DIR . "questions_" . $session->id_session . "_${name_article}.xml";
			$path_options_src = TEMPORARY_DIR . "options_" . $session->id_session . ".xml";
			$path_options_dest = TEMPORARY_DIR . "options_" . $session->id_session . "_${name_article}.xml";

			if (file_exists($path_quest_src) && @copy($path_quest_src, $path_quest_dest)) {
				@unlink($path_quest_src);
			}

			if (file_exists($path_options_src) && @copy($path_options_src, $path_options_dest)) {
				@unlink($path_options_src);
			}
		}
	}
	
	// Supprime un buletin d'alerte srialis.
	function del_alertes(session $session) {
		unset($_SESSION['alerte']);
		$file_path = TEMPORARY_DIR . "alerte_" . $session->id_session . ".srl";
		
		if (file_exists($file_path)) {
			@unlink($file_path);
		}
	}
?>