<?php
	define("TEMPLATE", "backoffice");
	define("PAGE", "suivi_publications"); // Page courante
	require_once("common.inc");

	//echo "LIBXML_VERSION:   ".LIBXML_VERSION."\n";

	restricted_access($session, $dpl, DROITS_MEMBRE_CA);
	$temp_data = list_temporary_submit($session,true);
	//$temp_data = f_list_temporary_submit($session,true);
	//$temp_data = f_InjectArticle($session,true);
	//$temp_data = f_ModiflistArticles($session,true);
	//print_r($temp_data);
	$name = isset($_GET['name']) ? $_GET['name'] : "";


	// Dtail d'une publication
	if (isset($temp_data[$id]['article']['articles']['articles'][$name])) {
		$article = $temp_data[$id]['article']['articles']['articles'][$name];
		$inscrit = select_inscrit_by_id($db, $article['ref_auteur']);

		/***
		*	Permet de faire un rappel
		*	en disant que la publication 
		*	actuel  t annul 
		***/

		// Partie de code commune  la validation et au refus
		if (isset($_POST['valider_publication']) || isset($_POST['refuser_publication'])) {
			// Refus de l'inscription
			$s_factice = new session_factice($id, $article['ref_auteur']);
			$motif = isset($_POST['motif']) ? $_POST['motif'] : "";
			$topic = "Publication SMV: " . $article['titre'];
			$email = select_email_personnel_by_id_inscrit($db, $inscrit->id_inscrit);
			$to = $email->email;
		}

		/***
		*	permet de valid la publication 
		****/

		// Validation de l'inscription
		if (isset($_POST['valider_publication'])) {
			$body = new template("emails/email_validation_publication");
			$id_article = valid_articles($db, $s_factice, $dpl, $name);

			if ($article['type_article'] & DOC_SONDAGE) {
				valid_sondage($db, $s_factice, $id_article, $article['ref_auteur'], $name);
			}

			// Affichage
			$dpl->add_child("CORPS", "validation_publication_ok");
			// Url d'identification
			$t_dir = explode("/", $_SERVER['SCRIPT_NAME']);
			array_pop($t_dir);
			$path = implode("/", $t_dir);
			$url = "http://" . $_SERVER['HTTP_HOST'] .  $path . "/detail_document.php5?id=$id_article";
			$body->add_entity("URL_ARTICLE", $url);
			// Envoi du mail
			$body->add_entity("CIVILITE", $inscrit->civilite);
			$body->add_entity("PRENOM", ucfirst($inscrit->prenom));
			$body->add_entity("NOM", strtoupper($inscrit->nom_inscrit));
			$body->add_entity("MOTIF", $motif);
			@mail($to, $topic, $body->get_display, "From: " . FROM);
		}

		/***
		*	Permet la supression de l'article 
		*	temporaire en cas de refus de l'articles
		***/
		else if (isset($_POST['refuser_publication'])) {
			// Suppression des fichiers temporaires
			wipe_article($db, $s_factice, $dpl, $name);
			del_temp_files($s_factice, $name);

			if ($article['type_article'] & DOC_SONDAGE) {
				del_questions($s_factice);
				del_options($s_factice);
			}

			/***
			*	Envoie de notification par 
			*	couriel pour informer l'auteur
			*	de l'articles 
			***/

			// Envoi du mail
			$body = new template("emails/email_refus_publication");
			$body->add_entity("CIVILITE", $inscrit->civilite);
			$body->add_entity("PRENOM", ucfirst($inscrit->prenom));
			$body->add_entity("NOM", strtoupper($inscrit->nom_inscrit));
			$body->add_entity("MOTIF", $motif);
			@mail($to, $topic, $body->get_display, "From: " . FROM);
			// Affichage
			$dpl->add_child("CORPS", "refus_publication_ok");
		}

		else {
			$s_factice = new session_factice($id, $inscrit->id_inscrit);
			$id_session = htmlentities($id_session);
			$civilite = htmlentities($inscrit->civilite);
			$nom = htmlentities(strtoupper($inscrit->nom_inscrit));
			$prenom = htmlentities(ucfirst($inscrit->prenom));
			$titre = htmlentities($article['titre']);
			$resume = htmlentities($article['resume']);
			$contenu = mepcode_parse($article['contenu'], $article['type_article']);
			$type_article = $article['type_article'];
			$droits = $article['droits'];
			$date_debut_affichage_raw = $article['date_debut_affichage'];
			$date_fin_affichage_raw = $article['date_fin_affichage'];
			$date_debut_raw = $article['date_debut'];
			$date_fin_raw = $article['date_fin'];
			$ref_categorie = $article['ref_categorie'];
			$nom_contact = htmlentities($article['nom_contact']);
			$email_contact = htmlentities($article['email_contact']);
			$lieux = htmlentities($article['lieux']);
			$id_article = htmlentities($article['id_article']);
			$type_document = libelles_types($type_article);

			if ($type_article & DOC_SONDAGE) {
				$dpl->add_child("CORPS", "detail_publication_sondage");
			}
			else {
				$dpl->add_child("CORPS", "detail_publication");
			}

			if ($droits & DROITS_VISITEUR) {
				$dpl->add_entity("VISIBLE_PAR", "Les visiteurs");
			}
			else if ($droits & DROITS_INSCRIT) {
				$dpl->add_entity("VISIBLE_PAR", "Les Invits");
			}
			else if ($droits & DROITS_MEMBRE) {
				$dpl->add_entity("VISIBLE_PAR", "Les membres de la SMV");
			}
			else if ($droits & DROITS_MEMBRE_CA) {
				$dpl->add_entity("VISIBLE_PAR", "Les membres du Conseil d'Administration");
			}
			else if ($droits & DROITS_MODERATEUR) {
				$dpl->add_entity("VISIBLE_PAR", "Les membres du comit de relecture");
			}
			else if ($droits & DROITS_ADMINISTRATEUR) {
				$dpl->add_entity("VISIBLE_PAR", "Les administrateurs");
			}

			// Petit cart de conduite sur le dcouplage texte/traitement... peu de chance de voir un jour un membre du CA non francophone, donc...
			if ($type_article & ALLOW_HTML) {
				$dpl->add_entity("ALLOW_HTML", "Le HTML est activ.");
			}
			else {
				$dpl->add_entity("ALLOW_HTML", "");
			}

			if ($type_article & RESUME_PUBLIQUE) {
				$dpl->add_entity("RESUME_PUBLIQUE", "Le rsum de cet article est visible par les visiteurs.");
			}
			else {
				$dpl->add_entity("RESUME_PUBLIQUE", "");
			}

			$dpl->add_entity("CIVILITE", $civilite);
			$dpl->add_entity("PRENOM", $prenom);
			$dpl->add_entity("NOM_INSCRIT", $nom);
			$dpl->add_entity("TITRE", $titre);
			$dpl->add_entity("RESUME", $resume);
			$dpl->add_entity("CONTENU", $contenu);
			$dpl->add_entity("ID_SESSION", $id);
			$dpl->add_entity("NAME_ARTICLE", htmlentities($name));
			$dpl->add_entity("TYPE_DOCUMENT", $type_document);

			if ($date_debut_affichage_raw && $date_fin_affichage_raw) {
				$dpl->add_child("DATES_AFFICHAGE", "dates_affichage_publication");
				$date_debut_affichage = htmlentities(@date("d/m/Y", $date_debut_affichage_raw));
				$date_fin_affichage = htmlentities(@date("d/m/Y", $date_fin_affichage_raw));
				$dpl->add_entity("DATE_DEBUT_AFFICHAGE", $date_debut_affichage);
				$dpl->add_entity("DATE_FIN_AFFICHAGE", $date_fin_affichage);
			}
			else {
				$dpl->add_child("DATES_AFFICHAGE", "blank");
			}

			if ($id_article) {
				$dpl->add_template("LIEN_ARTICLE_PUBLICATION", "lien_article_publication");
				$dpl->add_entity("ID_ARTICLE", $id_article);
			}
			else {
				$dpl->add_template("LIEN_ARTICLE_PUBLICATION", "blank");
			}

			$path = TEMPORARY_FILES_DIR . $session->id_session . "_piece_jointe_${name}_";
			// Suis-je pass dans la boucle...
			$first = true;

			/***
			*	Affichage des donner
			*	pices jointe
			***/
			for ($i = 1, $j = 1; $i < 100; ++$i) {

				if (file_exists($path . $i . ".jpg")) {

					if ($first) {
						$dpl->add_template("PIECES_JOINTES", "ligne_piece_jointe_publication");
						$first = false;
					}
					else {
						$dpl->append_template("ligne_piece_jointe_publication");
					}

					$dpl->add_entity("LIEN", htmlentities($path . $i . ".jpg"));
					$dpl->add_entity("NUM", htmlentities($j));
					++$j;
				}

				if (file_exists($path . $i . ".pdf")) {

					if ($first) {
						$dpl->add_template("PIECES_JOINTES", "ligne_piece_jointe_publication");
						$first = false;
					}
					else {
						$dpl->append_template("ligne_piece_jointe_publication");
					}

					$dpl->add_entity("LIEN", htmlentities($path . $i . ".pdf"));
					$dpl->add_entity("NUM", htmlentities($j));
					++$j;
				}

				if (file_exists($path . $i . ".doc")) {

					if ($first) {
						$dpl->add_template("PIECES_JOINTES", "ligne_piece_jointe_publication");
						$first = false;
					}
					else {
						$dpl->append_template("pieces_jointes");
					}

					$dpl->add_entity("LIEN", htmlentities($path . $i . ".doc"));
					$dpl->add_entity("LIEN_DEL", htmlentities($i . ".doc"));
					$dpl->add_entity("NUM", htmlentities($j));
					++$j;
				}

				if (file_exists($path . $i . ".rtf")) {

					if ($first) {
						$dpl->add_template("PIECES_JOINTES", "ligne_piece_jointe_publication");
						$first = false;
					}
					else {
						$dpl->append_template("pieces_jointes");
					}

					$dpl->add_entity("LIEN", htmlentities($path . $i . ".rtf"));
					$dpl->add_entity("LIEN_DEL", htmlentities($i . ".rtf"));
					$dpl->add_entity("NUM", htmlentities($j));
					++$j;
				}

				if (file_exists($path . $i . ".ppt")) {

					if ($first) {
						$dpl->add_template("PIECES_JOINTES", "ligne_piece_jointe_publication");
						$first = false;
					}
					else {
						$dpl->append_template("ligne_piece_jointe_publication");
					}

					$dpl->add_entity("LIEN", htmlentities($path . $i . ".ppt"));
					$dpl->add_entity("LIEN_DEL", htmlentities($i . ".ppt"));
					$dpl->add_entity("NUM", htmlentities($j));
					++$j;
				}
			}

			if ($first) {
				$dpl->add_template("PIECES_JOINTES", "blank");
			}

			if ($type_article & DOC_EVENEMENT || $type_article & DOC_FORMATION) {
				$dpl->add_template("CHAMPS_EVENEMENT", "champs_evenement_publication");
				$dpl->add_entity("LIEUX", $lieux);
				$dpl->add_entity("NOM_CONTACT", $nom_contact);
				$dpl->add_entity("EMAIL_CONTACT", $email_contact);

				if ($date_debut_raw && $date_fin_raw) {
					$dpl->add_child("DATES_EVENEMENTS_PUBLICATION", "dates_evenement_publication");
					$date_debut = htmlentities(@date("d/m/Y", $date_debut_affichage_raw));
					$date_fin = htmlentities(@date("d/m/Y", $date_fin_affichage_raw));
					$dpl->add_entity("DATE_DEBUT", $date_debut);
					$dpl->add_entity("DATE_FIN", $date_fin);
				}
				else {
					$dpl->add_entity("DATES_EVENEMENTS_PUBLICATION", "");
				}
			}
			else {
				$dpl->add_template("CHAMPS_EVENEMENT", "blank");
			}

			$first = false;
			// Affichage du sondage
			if ($type_article & DOC_SONDAGE) {
				$first = true;
				$questions = get_questions($s_factice, $name);
				$questions = $questions['questions'];
				$options = get_options($s_factice, $name);
				$options = $options['options'];

				if ($questions) {

					foreach ($questions as $question) {

						if ($first) {
							$dpl->add_template("LIGNES_QUESTIONS", "ligne_question");
							$first = false;
						}
						else {
							$dpl->append_template("ligne_question");
						}

						$texte = htmlentities($question['texte']);
						$dpl->add_entity("TEXTE", $texte);
						$presentation = $question['presentation'];
						$id_question_temp = $question['id_question_temp'];
						$lignes_options = "";

						if ($presentation & QUESTION_CHECKBOX) {
							$tmp = new template("tr_d");
							$lignes_options = $tmp->get_display;
							$col_count = 0;

							if ($options) {

								foreach ($options as $option) {

									if ($option['ref_question_temp'] != $id_question_temp) {
										continue;
									}

									if ($col_count && !($col_count % 4)) {
										$tmp = new template("tr_f");
										$lignes_options .= $tmp->get_display;
										$tmp = new template("tr_d");
										$lignes_options .= $tmp->get_display;
									}

									$id_question = "";
									$id_question_option = "";
									$checked = "";
									$libelle = htmlentities($option['libelle']);
									$tmp = new template("col_option_checkbox");
									$tmp->add_entity("LIBELLE", $libelle);
									$tmp->add_entity("ID_QUESTION", $id_question);
									$tmp->add_entity("ID_QUESTION_OPTION", $id_question_option);
									$tmp->add_entity("CHECKED", $checked);
									$lignes_options .= $tmp->get_display;
									++$col_count;
								}
							}

							$tmp = new template("tr_f");
							$lignes_options .= $tmp->get_display;
						}
						else if ($presentation & QUESTION_RADIO) {
							$tmp = new template("tr_d");
							$lignes_options = $tmp->get_display;
							$col_count = 0;

							if ($options) {

								foreach ($options as $option) {

									if ($option['ref_question_temp'] != $id_question_temp) {
										continue;
									}

									if ($col_count && !($col_count % 4)) {
										$tmp = new template("tr_f");
										$lignes_options .= $tmp->get_display;
										$tmp = new template("tr_d");
										$lignes_options .= $tmp->get_display;
									}

									$id_question = "";
									$checked = "";
									$libelle = htmlentities($option['libelle']);
									$tmp = new template("col_option_radio");
									$tmp->add_entity("LIBELLE", $libelle);
									$tmp->add_entity("ID_QUESTION", $id_question);
									$tmp->add_entity("CHECKED", $checked);
									$lignes_options .= $tmp->get_display;
									++$col_count;
								}
							}

							$tmp = new template("tr_f");
							$lignes_options .= $tmp->get_display;
						}
						else if ($presentation & QUESTION_TEXT) {
							$reponse = "";
							$id_question = "";
							$tmp = new template("ligne_option_text");
							$tmp->add_entity("REPONSE", $reponse);
							$tmp->add_entity("ID_QUESTION", $id_question);
							$lignes_options = $tmp->get_display;
						}
						else if ($presentation & QUESTION_TEXTAREA) {
							$reponse = "";
							$id_question = "";
							$tmp = new template("ligne_option_textarea");
							$tmp->add_entity("REPONSE", $reponse);
							$tmp->add_entity("ID_QUESTION", $id_question);
							$lignes_options = $tmp->get_display;
						}

						$dpl->add_entity("LIGNES_OPTIONS", $lignes_options);
					}
				}
				else {
					$dpl->add_template("LIGNES_QUESTIONS", "blank");
				}
			}
		}
	}
	/***
	*	Liste les publications 
	*	dans peut importe si la 
	*	valeur des information est 
	*	vide ou non 
	***/
	else {
		// Liste des publications
		$dpl->add_child("CORPS", "suivi_publications");
		$first = true;


		foreach ($temp_data as $id_session => $session_data) {
			$articles = isset($session_data['article']['articles']['articles']) ? $session_data['article']['articles']['articles'] : Array();

			foreach ($articles as $name => $article) {

				if ($first) {
					$dpl->add_child("LISTE", "ligne_article_suivi_publications");
					$first = false;

				}
				else {
					$dpl->append_template("ligne_article_suivi_publications");
				}

				$inscrit = select_inscrit_by_id($db, $article['ref_auteur']);
				$id_session = htmlentities($id_session);
				$nom = htmlentities(strtoupper($inscrit->nom_inscrit));
				$prenom = htmlentities(ucfirst($inscrit->prenom));
				$titre = htmlentities($article['titre']);
				$date_publication_raw = $article['date_soumission'];
				$date_publication = "";

				if ($date_publication_raw) {
					$date_publication = htmlentities(@date("\L\e d/m/Y  G:i:s", $date_publication_raw));
				}

				$dpl->add_entity("ID_SESSION", $id_session);
				$dpl->add_entity("NOM", $prenom . " " . $nom);
				$dpl->add_entity("TITRE", $titre);
				$dpl->add_entity("DATE_PUBLICATION", $date_publication);
				$dpl->add_entity("NAME_ARTICLE", htmlentities($name));
			}
		}

		/***
		*	Cas contraire si 
		*	le contennus est pas 
		*	disponible en affiche
		*	en charge le template 
		*	aucune publication disponible
		***/

		if ($first) {
			$dpl->add_child("LISTE", "no_publication");
		}
	}

	$dpl->done();
?>