<?php
	
	/***
	*	Ensemble des méthodes 
	*	pour la gestion du rappel 
	*	de mots de passe
	***/



	/***
	*	Fonction qui génère une clef unique
	*	temporarire de session elle utilise
	*	la methode SH1 pour la sécuriser
	***/

	function f_GenKey(){

		$i 		= 0;
		$Cst 	= 9;   /*	limite de la bonne de clef 	*/
		$ret 	= "";
		$msq 	= "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVVWXYZ";

		$size = strlen( $msq );
		if( $Cst > $size )
			$size = $Cst;

		/*	Génération de la clef unique 	*/
		while( $i++ < $size ){

			$key = substr($msq, mt_rand(0,$size-1), 1);
			if( !strstr( $ret, $key ) ){
				$ret.= $key;
			}
		}

		/***
		*	Utilisation de l'encryptage SH1
		*	& sécurisation de la clef
		***/ 
		return sha1( $ret );
	}

	/***
	*	Fonction création et enregistrement 
	*	de la clef
	***/
	function f_SaveKey( $arg ){

		$strdir = TEMPORARY_DIR.'KEY/';
		$stsave = $strdir;
		$dir = opendir( $strdir );
		if( !$dir )
			return ( false );
		
		else{
			/*	Création de la clef */
			$nFile = $arg.".vld";

			/*	Sauvegarde de la clef */
			$strdir.=$nFile;
			if( !file_exists( $nFile ) ){

				touch( $strdir );
				closedir( $dir );
				return ( true );
			}

			closedir($dir);
			return ( false );
		}
	}

	/***
	*	Fonction qui vérifie 
	*	si une clef n'existe pas 
	*	déja & dans le cas où elle
	*	existe elle renvoie faux
	*	dans l'autre cas elle revoie
	*	vrais
	***/
	function f_KeyExiste( $arg, $key ){

		$i 		= 0;
		$cmpt 	= 0;
		$TabKey = array();

		/*	ouverture du répertoire */
		$dir = opendir( $arg );

		/*	Parcourd du repertoire */
		while ( $nFile = readdir( $dir ) ){
			$cmpt++;
			$TabKey[] = $nFile;
		}
		closedir( $dir );

		/***
		*	Récupération des key
		***/
		$ret = false;
		$TabKey = glob('*.vld');
		for ( $i; $i < $cmpt; $i++ ){ 
			if( $TabKey[$i] == $key )
				$ret = true;
			$ret = false;
		}

		return ( $ret );
	}

	/***
	*	Création & Sauvegarde de la clef
	***/
	function f_Sendkey(){

		@$tmp_key = f_GenKey();
		@$rep_dir = TEMPORARY_DIR.'KEY';
		
		/***	
		*	verification de la clef
		*	si elle n'est pas en double
		***/
		if( ( !$tmp_key ) || ( $tmp_key == "" ) )
			f_Sendkey();

		else{

			if( f_KeyExiste( $rep_dir, $tmp_key ) != true ){
				if( f_SaveKey( $tmp_key ) != true )
					f_Sendkey();
				else
					return ( $tmp_key );
			}
			else
				f_Sendkey();
		}
	}

	/***
	*	Fonction écriture du numéro de id
	*	selon l'utilisateur dans le fichier
	*	Key
	***/
	function f_WriteSession( $pth, $key, $idUser, $hash, $path){

		echo $nFile = $pth.$key.'.vld';
		$fw = fopen( $nFile, "a+" );
		fputs( $fw, "$idUser");
		fputs( $fw, "\n");
		fputs( $fw, "$hash");
		fputs( $fw, "\n");
		fputs( $fw, "$path");
		fclose( $fw );
		
	}

	/***
	*	Fonction retourne le chemin
	*	du dossier temp
	***/
	function f_Getpath(){
		@$rep_dir = TEMPORARY_DIR.'KEY/';
		return ( $rep_dir );	
	}

	/***
	*	Fonction qui permet lecture
	*	de d'une clef (pas utiles);
	***/
	function f_ReadInfoKey( $arg ){


		$nFile = $arg;
		$nFile .= $key.'.vld';

		$fr = fopen( $nFile, "r" );
		$ret = fgets( $fr );
		
		fclose( $fr );
		return ( $ret );
	}

	/***
	*	Fonction qui permet d'obtenir 
	*	l'ensemble des informations 
	*	de la sesion sauvegarder 
	*	il retoune un tableaux contenant
	*	l'ensemble des informations 
	***/

	function f_GetUser($key){

		$i 		= 0;
		$ret 	= array();

		$path = TEMPORARY_DIR.'KEY/';
		$path .=$key.'.vld';

		$fr = fopen( $path, "r" );
		flock( $fr, LOCK_SH );
		while( ( $lgn = fgets( $fr ) ) != false ){
			list( $key,$val ) = explode(' ', rtrim( $lgn ) );
			$ret[$i] = $key;
			$i++;
		}
		flock( $fr, LOCK_UN );
		fclose( $fr );
		return ( $ret );
	}
?>