<?php
	
	/***
	*	Ensemble des outils 
	*	pour la gestion des articles
	***/

	/***
	*	Fonction qui sauvegarde le 
	*	nom du fichier articles et par 
	*	session
	***/
	function f_SaveArticles($path, $arg ){

		$fw = fopen( $path, "a+" );
		fputs($fw, $arg);
		fputs($fw, "\n");
		fclose($fw);
	}

	/***
	*	Fonction gestion des l'article
	*	à sauvegarder
	***/
	function f_OutArticles( $arg ){

		$nFile 	= 'list_Articles.list';
		$path 	= TEMPORARY_DIR.'ART/';
		$FILE 	= $path.$nFile;

		$dir = opendir($path);
		if( file_exists($nFile) ){
			closedir($dir);
			f_SaveArticles($FILE, $arg);
		}
		touch($FILE);
		f_SaveArticles($FILE,$arg);
		closedir($dir);
	}

	/***
	*	Fonction qui retourne
	*	un tableaux de la liste des
	*	fichier sauvegarder
	***/
	function f_getFileArticles(){

		$i 		= 0;
		$ret 	= array();

		$path =  TEMPORARY_DIR.'ART/';
		$path .= 'list_Articles.list';

		$fr = fopen( $path, "r" );
		flock( $fr, LOCK_SH );
		while( ( $lgn = fgets( $fr ) ) != false ){
			list( $key,$val ) = explode(' ', rtrim( $lgn ) );
			$ret[$i] = $key;
			$i++;
		}
		flock( $fr, LOCK_UN );
		fclose( $fr );
		return ( $ret );
	}

	/***
	*	fonction permettant
	*	le forcing de la 
	*	sauvegarde en bd
	***/
	function f_ForcingBdSave(DB $db, $article){

		// Table Articles
		insert($db, "Articles", $article['articles']);
		$article['contenu']['ref_fiche'] = $id_article;
		$article['auteurs']['ref_fiche'] = $id_article;
		$article['evenements']['ref_article'] = $id_article;
		
		// Table Contenu
		insert($db, "Contenu", $article['contenu']);
		// Table Auteurs
		insert($db, "Auteurs", $article['auteurs']);

		// Table Evenements
		if (($article['articles']['type_article'] & DOC_EVENEMENT) || ($article['articles']['type_article'] & DOC_FORMATION)) {
			insert($db, "Evenements", $article['evenements']);
		}
	}

	/***
	* Fonction qui charge tout l'emsemble des 
	* article dans un tableaux
	****


	/***
	*	Fonction qui injecte la 
	*	liste des articles pour 
	*	forcer le chargement de 
	*	l'ensemble de la liste des
	*	articles
	***/
	function f_InjectArticle(session $session, $verif){

		$i   = 0;							/*	Variable d'incrémentation 	*/
		$ret = array();						/*	Tableau d'articles 			*/
	 	$ret = f_getFileArticles();			/*	Aquisition des articles 	*/

	 	$cpt = count($ret);
	 	$retour = array();
	 	$results = array();
	 	$pattern_temp = "/^(.+)_([a-zA-Z0-9]{32})\.xml$/";


	 	
		/*	contrôle de l'utilisateur */
	 	if( !is_membre_ca($session) && $verif ){
	 		return ( false );
	 	}

	  	else{
	 		
	 		if($cpt <= 1 ){
				
	 			$file = $ret[0];

	 			if (preg_match($pattern_temp, $file, $results)){
	 				// Type de fichier temporaire
		 				$type_of_file = $results[1];

		// 				// Id de session
		 				$id_session = $results[2];
		// 				// Création d'une "fausse" session
		 				$s_factice = new session_factice($id_session);
					
		// 				// On définit is_inscription à false si il n'existe pas déjà pour cette session
		 				if (!isset($retour[$s_factice->id_session]['inscription']['is_inscription'])) {
		 					$retour[$s_factice->id_session]['inscription']['is_inscription'] = false;
		 					$retour[$s_factice->id_session]['inscription']['finalized'] = false;
		 					$retour[$s_factice->id_session]['inscription']['pre_finalized'] = false;
		 				}
		 			
					
		// 				// On définit article_ok à false si il n'existe pas déjà pour cette session
		 				if (!isset($retour[$s_factice->id_session]['article']['finalized'])) {
		 					$retour[$s_factice->id_session]['article']['finalized'] = false;
		 				}
		 			
		 				switch($type_of_file){
						
		// 				// Inscription / Infos personnelles
		 				case "inscrit":
						
							$inscrit = get_inscrit($s_factice);

							// Dans le cas de l'inscription, on le précise
							if ($inscrit && !$inscrit['inscrit']['id_inscrit']) {
								$retour[$s_factice->id_session]['inscription']['is_inscription'] = true;
							}
						
							$retour[$s_factice->id_session]['inscription']['inscrit'] = $inscrit;
		 					break;
						
						case "structures":
							$retour[$s_factice->id_session]['inscription']['structures'] = get_structures($s_factice);
							break;
						
						case "fonctions":
							$retour[$s_factice->id_session]['inscription']['fonctions'] = get_fonctions($s_factice);
							break;
						
						case "adresses":
							$retour[$s_factice->id_session]['inscription']['adresses'] = get_adresses($s_factice);
							break;
						
						case "telephones":
							$retour[$s_factice->id_session]['inscription']['telephones'] = get_telephones($s_factice);
							break;
						
						case "emails":
							$retour[$s_factice->id_session]['inscription']['emails'] = get_emails($s_factice);
							break;
							
						case "pre_inscription_ok":
							$retour[$s_factice->id_session]['inscription']['pre_finalized'] = true;
							break;
						
						case "inscription_ok":
							$retour[$s_factice->id_session]['inscription']['finalized'] = true;
							break;
							
						case "adresse_principale_ok":
							break;

						case "email_principal_ok":
							break;

						case "telephone_principal_ok":
							break;
							
						// Articles
						case "articles":
							$retour[$s_factice->id_session]['article']['articles'] = get_articles($s_factice);
							break;
							
						// CVIs
						case "fiche_cvi":
							$retour[$s_factice->id_session]['cvi']['cvi'] = get_cvi($s_factice);
							break;
		  			}
	 			}
	 			return ( $retour );
	 		}
	 		/***
	 		*	Sinon plusieur articles
	 		***/
			else{

				for(; $i < $cpt; $i++){

					$file = $ret[$i];

					if (preg_match($pattern_temp, $file, $results)){
					
						// Type de fichier temporaire
						$type_of_file = $results[1];

						// Id de session
						$id_session = $results[2];
							
						// Création d'une "fausse" session
						$s_factice = new session_factice($id_session);
							
						// On définit is_inscription à false si il n'existe pas déjà pour cette session
						if (!isset($retour[$s_factice->id_session]['inscription']['is_inscription'])) {
							$retour[$s_factice->id_session]['inscription']['is_inscription'] = false;
							$retour[$s_factice->id_session]['inscription']['finalized'] = false;
							$retour[$s_factice->id_session]['inscription']['pre_finalized'] = false;
						}
							
						// On définit article_ok à false si il n'existe pas déjà pour cette session
						if (!isset($retour[$s_factice->id_session]['article']['finalized'])) {
							$retour[$s_factice->id_session]['article']['finalized'] = false;
						}
							
						switch($type_of_file){
								
							// Inscription / Infos personnelles
							case "inscrit":
								
								$inscrit = get_inscrit($s_factice);
									
								// Dans le cas de l'inscription, on le précise
								if ($inscrit && !$inscrit['inscrit']['id_inscrit']) {
									$retour[$s_factice->id_session]['inscription']['is_inscription'] = true;
								}
								
								$retour[$s_factice->id_session]['inscription']['inscrit'] = $inscrit;
							break;
								
							case "structures":
								$retour[$s_factice->id_session]['inscription']['structures'] = get_structures($s_factice);
							break;
								
							case "fonctions":
								$retour[$s_factice->id_session]['inscription']['fonctions'] = get_fonctions($s_factice);
							break;
								
							case "adresses":
								$retour[$s_factice->id_session]['inscription']['adresses'] = get_adresses($s_factice);
							break;
								
							case "telephones":
								$retour[$s_factice->id_session]['inscription']['telephones'] = get_telephones($s_factice);
							break;
								
							case "emails":
								$retour[$s_factice->id_session]['inscription']['emails'] = get_emails($s_factice);
							break;
									
							case "pre_inscription_ok":
								$retour[$s_factice->id_session]['inscription']['pre_finalized'] = true;
							break;
								
							case "inscription_ok":
								$retour[$s_factice->id_session]['inscription']['finalized'] = true;
							break;
									
							case "adresse_principale_ok":
							break;

							case "email_principal_ok":
							break;

							case "telephone_principal_ok":
							break;
									
							// Articles
							case "articles":
								$retour[$s_factice->id_session]['article']['articles'] = get_articles($s_factice);
							break;
									
							// CVIs
							case "fiche_cvi":
								$retour[$s_factice->id_session]['cvi']['cvi'] = get_cvi($s_factice);
							break;
						}
				
					}
				}

				return ( $retour );
			}
	 	}
	}


	/***
	*	copie de la fonction d'origine 
	*	avec juste la modifiction du chemin 
	*	ou ce trouve les articles
	***/

	function f_ModiflistArticles(session $session, $verif = true) {
	
		// Hacking attempt
		if (!is_membre_ca($session) && $verif) {
			return false;
		}
		
		$dir = TEMPORARY_DIR.'ART/';
		if (!$temp_dh = @opendir($dir) ) {
			echo "OK";
			return false;
		}
		
		$retour = array();
		$pattern_temp = "/^(.+)_([a-zA-Z0-9]{32})\.xml$/";

		
		while (($file = readdir($temp_dh)) !== false) {
			switch ($file) {
			
				case "." :
					continue;
				
				case "..":
					continue;
				
				case ".htaccess":
					continue;
			}
			
			$results = array();
			if (preg_match($pattern_temp, $file, $results)) {
				// Type de fichier temporaire
				$type_of_file = $results[1];

				// Id de session
				$id_session = $results[2];
				// Création d'une "fausse" session
				$s_factice = new session_factice($id_session);
				
				// On définit is_inscription à false si il n'existe pas déjà pour cette session
				if (!isset($retour[$s_factice->id_session]['inscription']['is_inscription'])) {
					$retour[$s_factice->id_session]['inscription']['is_inscription'] = false;
					$retour[$s_factice->id_session]['inscription']['finalized'] = false;
					$retour[$s_factice->id_session]['inscription']['pre_finalized'] = false;
				}
				
				// On définit article_ok à false si il n'existe pas déjà pour cette session
				if (!isset($retour[$s_factice->id_session]['article']['finalized'])) {
					$retour[$s_factice->id_session]['article']['finalized'] = false;
				}
				
				switch($type_of_file) {
					
					// Inscription / Infos personnelles
					case "inscrit":
					
						$inscrit = get_inscrit($s_factice);
						
						// Dans le cas de l'inscription, on le précise
						if ($inscrit && !$inscrit['inscrit']['id_inscrit']) {
							$retour[$s_factice->id_session]['inscription']['is_inscription'] = true;
						}
					
						$retour[$s_factice->id_session]['inscription']['inscrit'] = $inscrit;
						break;
					
					case "structures":
						$retour[$s_factice->id_session]['inscription']['structures'] = get_structures($s_factice);
						break;
					
					case "fonctions":
						$retour[$s_factice->id_session]['inscription']['fonctions'] = get_fonctions($s_factice);
						break;
					
					case "adresses":
						$retour[$s_factice->id_session]['inscription']['adresses'] = get_adresses($s_factice);
						break;
					
					case "telephones":
						$retour[$s_factice->id_session]['inscription']['telephones'] = get_telephones($s_factice);
						break;
					
					case "emails":
						$retour[$s_factice->id_session]['inscription']['emails'] = get_emails($s_factice);
						break;
						
					case "pre_inscription_ok":
						$retour[$s_factice->id_session]['inscription']['pre_finalized'] = true;
						break;
					
					case "inscription_ok":
						$retour[$s_factice->id_session]['inscription']['finalized'] = true;
						break;
						
					case "adresse_principale_ok":
						break;

					case "email_principal_ok":
						break;

					case "telephone_principal_ok":
						break;
						
					// Articles
					case "articles":
						$retour[$s_factice->id_session]['article']['articles'] = get_articles($s_factice);
						break;
						
					// CVIs
					case "fiche_cvi":
						$retour[$s_factice->id_session]['cvi']['cvi'] = get_cvi($s_factice);
						break;
				}
			}
		}
		
		return $retour;
	}	
?>