package projet;

import projet.Deplacement;
import projet.Piece;

public class Tour extends Piece {
	
	 //Constructeur de la classe tour
	 //Prend en parametre la couleur de la tour
	 
    
	public Tour(Couleur couleur) {
		super(couleur);
	}


	
	public boolean estValide(Deplacement deplacement) {
		//pour deplacement valide de la tour, il faut que le produit de l'abscisse et de l'ordonner soit nul car un des deux doit etre nul
		return deplacement.getDeplacementX() * deplacement.getDeplacementY() == 0 && !deplacement.isNul();
	}



	@Override
	public final char getCode() {
		return 'T';
	}



	@Override
	public final String getNom() {
		return "Tour";
	}

}
