package projet;

import projet.Deplacement;
import projet.Piece;


public class Reine extends Piece{
	
	
	 // Constructeur de la classe reine
	 // Prend en parametre la couleur de la reine
	 
	public Reine(Couleur couleur) {
		super(couleur);
	}

	public boolean estValide(Deplacement deplacement) {
		//le deplacement d'une reine, c'est le deplacement du fou et de la tour combiner donc nous utiliserons les regles de deplacement de la tour et du fou
		//math.abs sert a retourner la valeur absolue
		return (Math.abs(deplacement.getDeplacementX()) - Math.abs(deplacement.getDeplacementY()) == 0 
				| deplacement.getDeplacementX() * deplacement.getDeplacementY() == 0) && !deplacement.isNul();
	}

	@Override
	public char getCode() {
		return 'D';
	}

	@Override
	public String getNom() {
		return "Reine";
	}
}
