package projet;

import javax.swing.Icon;
import javax.swing.ImageIcon;

//  point de depart pour tous les types de pieces d'un jeu d'echecs

public abstract class Piece {
	
	private boolean deplaceunefois;
	 // couleur de la pièce 
	private Couleur couleur;


	// constructeur permettant d'initialiser le nom et la couleur d'une pièce 
	public Piece(Couleur couleur) {
		setCouleur(couleur);
	}

	public abstract String getNom();

	public abstract char getCode();
	
	public Couleur getCouleur() {
		return couleur;
	}

	public void setCouleur(Couleur couleur) {
			this.couleur = couleur;
	}

	// méthode permettant de vérifier si le déplacement de la pièce est valide 
	public abstract boolean estValide(Deplacement deplacement);
	
	public void enregistreDeplacement(boolean deplace) {
	    deplaceunefois=deplace;
	}
	public boolean aDejaEteDeplaceUneFois(){
	       return deplaceunefois;
	}

	public Icon getIcon(String dossierIcone) {
		return getIcon(dossierIcone,getCode(),getCouleur().getCode());
	}

	public static Icon getIcon(String dossierIcone, char codepiece, char codecouleur ) {
		return new ImageIcon(dossierIcone + codepiece + codecouleur + ".gif");
	}

}

