package projet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
 
/**
 * stocke les diffrents coups d'une partie
 */
public class Partie {
 
	private static List<Coup> coupsjoues = new ArrayList<Coup>();
 
	/**
	 * recommence une partie  zro
	 */
	public static void reset() {
		coupsjoues.clear();
	}
	/**
	 * stocke un nouveau coup sans prise de pice
	 */
	public static void nouveauCoup(Couleur couleur, Piece piecejouee,
			Deplacement deplacement) {
		nouveauCoup(couleur, piecejouee, deplacement, null);
	}
	/**
	 * stocke un nouveau coup avec prise de pice
	 */
	public static void nouveauCoup(Couleur couleur, Piece piecejouee,
			Deplacement deplacement, Piece pieceprise) {
		Coup coup = new Coup();
		coup.couleur = couleur;
		coup.piecejouee = piecejouee;
		coup.depart = deplacement.getDepart();
		coup.arrivee = deplacement.getArrivee();
		coup.pieceprise = pieceprise;
		coupsjoues.add(coup);
	}
	/**
	 * rcupre le dernier coup jou
	 */
	public static Coup getDernierCoupJoue() {
		if ( coupsjoues.isEmpty() ) {
			return null;
		}
		else {
			return coupsjoues.get(coupsjoues.size()-1);
		}
	}

	/**
	 * reprsente un coup
	 */
	public static class Coup {
		private Couleur couleur;
		private Piece piecejouee;
		private Position depart, arrivee;
		private Piece pieceprise;
 
		public Couleur getCouleur() {
			return couleur;
		}
 
		public Piece getPieceJouee() {
			return piecejouee;
		}
 
		public Position getDepart() {
			return depart;
		}
 
		public Position getArrivee() {
			return arrivee;
		}
 
		public Piece getPiecePrise() {
			return pieceprise;
		}
		public byte[] encode(){
			byte[] data=new byte[7];// on cr un tableau de 7 octets
			data[0]=getCodeCouleur(couleur);//couleur 
			data[1]=getCodePiece(piecejouee); // code piece
			data[2]=getCode(depart.getColonne()); // colonne dpart
			data[3]=getCode(depart.getLigne()); // ligne dpart
			data[4]=getCode(arrivee.getColonne()); // colonne arrive
			data[5]=getCode(arrivee.getLigne()); // ligne arrive
			data[6]=getCodePiece(pieceprise); // code piece
			return data;
		}
		private byte getCodeCouleur(Couleur joueur) {
			return (byte) (joueur==Couleur.blanc?1:0); // 1 = blanc, 0 = noir
		}
		private byte getCode(int value) {
			return (byte) value;
		}
		private byte getCodePiece(Piece piecejouee) {
			if ( piecejouee==null ) {
				return 0;
			}
			else {
				return (byte)piecejouee.getCode();
			}
		}
		public void decode(byte[] data, Echiquier echiquier) throws IOException {
			// on vrifie le tableau data
			if ( data!=null && data.length>0 && data.length<8 ) {
				couleur=decodeToCouleur(data[0]);
				depart=new Position(decode(data[2]),decode(data[3]));
				arrivee=new Position(decode(data[4]),decode(data[5]));
				piecejouee=decodePiece(data[1],depart,couleur,echiquier);
				pieceprise=decodePiece(data[6],arrivee,couleur.couleurAdverse(),echiquier);
			}
			else {
				throw new IOException();
			}
		}
 
		private Piece decodePiece(byte code, Position position, Couleur couleur, Echiquier echiquier) throws IOException {
			Piece piece = echiquier.getCase(position).getPiece();
			byte codepiece = getCodePiece(piece);
			if (codepiece==code && (codepiece==0 || couleur==piece.getCouleur())) return piece;
            //System.out.println((code!=0?(""+(char)code):"?")+" "+(codepiece!=0?("?"+(char)codepiece):"")+" "+couleur+" "+piece);
			throw new IOException();
		}
 
		private int decode(byte value) throws IOException {
            if ( value>=0 && value<8 ) {
            	return value;
            }
			throw new IOException();
		}
 
		private Couleur decodeToCouleur(byte code) throws IOException {
			if ( code==1 ) return Couleur.blanc;
			else if ( code==0 ) return Couleur.noir;
			else throw new IOException();
		}
	}
	
	
	
	
	
	public static void save(File file) throws IOException {
		OutputStream output = null;
		try {
			output=new BufferedOutputStream(new FileOutputStream(file));//on utilise un stream bufferis pour ne pas a se soucier des octes
			// on parcout tous les coups jous
			for( Coup coup : coupsjoues ) {
				output.write(coup.encode()); // les encoder et les crires
			}
			output.flush(); //pour tre sur que tous les octets sont crits
		}
		finally {
			if ( output!=null ) {
				try {
					output.close(); // on ferme le fichier
				} catch (IOException e) {
				}
			}
		}
	}
	
	
	public static PartieChargee load(File file) throws IOException {
		 
		// on cre un echiquier virtuel pour vrifier le fichier pendant le chargement et prpar le jeu
		Echiquier echiquier = new Echiquier();
		echiquier.debuter();
		
		//pour prparer les panneaux des pices prises
		List<Piece> pieceprisesParLesBlancs = new ArrayList<Piece>();
		List<Piece> pieceprisesParLesNoirs = new ArrayList<Piece>();
 
		// on ne charge pas directement dans l'echiquier au cas ou on aurait une erreur en plein milieu,
		//on aura pas des donnes pourries dans l'chiquier
 
		// on initialise l'chiquier virtuel
		
 
		List<Coup> coupsjoues = new ArrayList<Coup>(); 
		byte[] data=new byte[7];      
		InputStream input = null;
		try {
			input=new BufferedInputStream(new FileInputStream(file));//on utilise un stream bufferis pour ne pas a se soucier des octes
 
			// on parcourt le fichier, 
			int read;
			while ( (read=input.read(data))!=-1 ) {
				if ( read<7 ) {
					// pas assez de donnes lu
					throw new IOException();
				}
				Coup coup = new Coup();
				try {
				coup.decode(data, echiquier);
				}
				catch (Exception e) {
					break;
				}
				//System.out.println(coup);
				coupsjoues.add(coup);
				// on joue virtuellement le coup
				echiquier.getCase(coup.depart).setPiece(null);
				echiquier.getCase(coup.arrivee).setPiece(coup.piecejouee);
				coup.piecejouee.enregistreDeplacement(true);
				// il y a le cas particulier du roque : on a sauv que le mouvement du roi
				if( coup.getPieceJouee() instanceof Roi ) {
					int deplacementX=coup.getArrivee().getColonne()-coup.getDepart().getColonne();
					if ( Math.abs(deplacementX)==2 ) {
						Position positionTourDepart, positionTourArrive;
						// c'est un roque,il faut aussi bouger la tour
						if ( deplacementX<0 ) {
							// deplacement vers la gauche
							positionTourDepart=new Position(0,coup.arrivee.getLigne());
							positionTourArrive=coup.arrivee.position(1,0);
						}
						else {
							// deplacement vers la droite
							positionTourDepart=new Position(7,coup.arrivee.getLigne());
							positionTourArrive=coup.arrivee.position(-1,0);
						}
						Piece tour=echiquier.getCase(positionTourDepart).getPiece();
						echiquier.getCase(positionTourArrive).setPiece(tour);
						echiquier.getCase(positionTourDepart).setPiece(null);
						tour.enregistreDeplacement(true);
					}
				}
				if ( coup.pieceprise!=null ) {
					switch (coup.couleur) {
					case blanc:
						pieceprisesParLesBlancs.add(coup.pieceprise);
						break;
					case noir:
						pieceprisesParLesNoirs.add(coup.pieceprise);
						break;
					}
				}
			}
 
 
		}
		finally {
			if ( input!=null ) {
				try {
					input.close(); // on ferme le fichier
				} catch (IOException e) {
				}
			}
		}
 
		// on a pas eu d'erreur jusque l
		// on peut construire notre affichage  partir des donnes chargs 
		Partie.reset();
		Partie.coupsjoues.addAll(coupsjoues);
 
		// on cr l'objet partiechargee pour retourner l'tat de la partie charge
		PartieChargee partiechargee=new PartieChargee();
		partiechargee.echiquier=echiquier;
		partiechargee.pieceprisesParLesBlancs=pieceprisesParLesBlancs;
		partiechargee.pieceprisesParLesNoirs=pieceprisesParLesNoirs;
 
		return partiechargee;
	}
	
	
	
	
 
}