package projet;

import javax.swing.JFrame;

import java.awt.Dimension;

import javax.swing.JPanel;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.JLabel;
import javax.swing.JTextField;

import projet.CaseLabel.CoupPossible;
import projet.Partie.Coup;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
 //cette classe permet de faire l'inteface graphique avec les boutons reset et commencer ainsi que le champs texte informant que c'est sont tour et des Jpanel pour recuperer les pions manger 
public class FenetreJeu extends JFrame {
	private static final String DOSSIER_ICONES = "Icone/";
	private static final long serialVersionUID = 42L; //serialVersionUID permet d'affecter un numéro de version à la classe
	//construction tableau echequier
	private Echiquier e; // echiquier
	private CaseLabel[][] tab; // tableau de cases
	private JPanel panelControle = new JPanel(); // panel du haut
	private JPanel panelGrille = new JPanel(); // panel du bas ( grille )
	GridLayout gridLayout1 = new GridLayout();

	private JTextField champTexte = new JTextField();
	private JPanel panelblanc = new JPanel();
	private JPanel panelnoir = new JPanel();
	private JPanel panellens = new JPanel();
	private JPanel joueurblanc = new JPanel();
	private JPanel joueurnoir = new JPanel();
	JLabel banniere = new JLabel( new ImageIcon( "banniere.jpg"));
	JLabel jblanc = new JLabel( new ImageIcon( "jblanc.gif"));
	JLabel jnoir = new JLabel( new ImageIcon( "jnoir.gif"));
	Couleur couleurControle = Couleur.blanc;

	
	 //Constructeur
	public FenetreJeu()
	{
		try {
			initialisationPanel(); //appelle methode initialisationPanel
		} catch (Exception e) {
			e.printStackTrace(); //affiche l'exception au moment de son appel
	    }
	}

	
	 // initialise la surface de jeu. Cre tout les elements et initialise leur position, leur couleur.. etc
	 
	private void initialisationPanel() throws Exception {
        champTexte.setEnabled(false);

		tab = new CaseLabel[8][8]; // création du tableau de JLabel
		e = new Echiquier(); // création de l'échiquier

		this.getContentPane().setLayout(null); // permet de centrer le cadre du haut
		this.setSize(new Dimension(900, 715)); //dimension fenetre 
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); //fermer la fenetre
		this.setTitle("RCL ECHEC"); //titre de la fenetre
		panelControle.setBounds(new Rectangle(160, 10, 550, 45)); //dimension du bloc du haut
		panelControle.setLayout(null); //permet de voir le champ en haut
		panelGrille.setBounds(new Rectangle(160, 65, 550, 465)); //dimension de l'échiquier
		panelGrille.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.RAISED));
		panelGrille.setLayout(gridLayout1); // insert les colonnes et les lignes pour les cases
		gridLayout1.setColumns(8);
		gridLayout1.setRows(8);
		this.getContentPane().add(panelnoir, null); //visualiser le recuperateur de piece noir
		this.getContentPane().add(panelblanc, null);//visualiser le recuperateur de piece blanche
		this.getContentPane().add(panellens, null);//visualiser la banniere de lens
		this.getContentPane().add(joueurblanc, null);//visualiser le joueur blanc
		this.getContentPane().add(joueurnoir, null);//visualiser le joueur noir
		this.getContentPane().add(panelGrille, null); //visualiser lechiquier
		panelControle.add(champTexte, null);
		this.getContentPane().add(panelControle, null); //visualiser le champ text en haut
		champTexte.setBounds(new Rectangle(160, 10, 215, 25));
		champTexte.setText("Bienvenue");
        champTexte.setEnabled(false);
        champTexte.setHorizontalAlignment(SwingConstants.CENTER);

		// les écouteurs
		GestionnaireEvenement gest = new GestionnaireEvenement();
		
		//crŽation des labels
		panelblanc.setBounds(new Rectangle(30, 65, 90, 465)); // dimension recuperateur de piece blanche
		panelblanc.setBackground(new Color(255, 0, 0));
		panelblanc.setLayout(new FlowLayout());
		panelblanc.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.RAISED));
		panelnoir.setBounds(new Rectangle(750, 65, 90, 465)); // dimension recuperateur de piece noire
		panelnoir.setBackground(new Color(0, 0, 0));
		panelnoir.setLayout(new FlowLayout());
		panelnoir.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.RAISED));
		panellens.setBounds(new Rectangle(160, 550, 550, 100)); // dimension banniere de lens
		panellens.setLayout(new FlowLayout());
		panellens.add(banniere);
		joueurblanc.setBounds(new Rectangle(20, 1, 115, 60)); // dimension joueur blanc
		joueurblanc.setLayout(new FlowLayout());
		joueurblanc.add(jblanc);
		joueurnoir.setBounds(new Rectangle(735, 1, 115, 60)); // dimension joueur noir
		joueurnoir.setLayout(new FlowLayout());
		joueurnoir.add(jnoir);
		JMenuBar menuBar;
		JMenu menu;
		JMenuItem menuItem;
		//Create the menu bar.
		menuBar = new JMenuBar();

		//Build the first menu.
		menu = new JMenu("Fichier");
		menu.setMnemonic(KeyEvent.VK_A);
		menuBar.add(menu);

		//a group of JMenuItems
		menuItem = new JMenuItem("Commencer",
		                         KeyEvent.VK_C);
		menuItem.setAccelerator(KeyStroke.getKeyStroke(
		        KeyEvent.VK_1, ActionEvent.ALT_MASK));
		menu.add(menuItem);
		menuItem.addActionListener(new ActionListener() {
			
		public void actionPerformed(ActionEvent paramActionEvent) {

			RAZ();
			Partie.reset();
			couleurControle = Couleur.blanc; // les blancs commencent
		    //initialise le champ texte, apelle la methode debuter, et initialise toute les variables 
		    champTexte.setText(couleurControle.getTexte() + " a vous de jouer");
			e.debuter();
			placeIcons();

			}
		});
		//a group of JMenuItems
		menuItem = new JMenuItem("Terminer",
		                         KeyEvent.VK_T);
		menuItem.setAccelerator(KeyStroke.getKeyStroke(
		        KeyEvent.VK_2, ActionEvent.ALT_MASK));
		menu.add(menuItem);
		menuItem.addActionListener(new ActionListener() {
			
			public void actionPerformed(ActionEvent paramActionEvent) {
				//on appel la methode RAZ
				RAZ();
			}
		});
		menuItem = new JMenuItem("Sauvegarder",
                KeyEvent.VK_R);
		menuItem.setAccelerator(KeyStroke.getKeyStroke(
				KeyEvent.VK_3, ActionEvent.ALT_MASK));
		menu.add(menuItem);
		
		menuItem.addActionListener(new ActionListener() {
			
			public void actionPerformed(ActionEvent paramActionEvent) {
				save();
			}
		});
		
		menuItem = new JMenuItem("Charger",
                KeyEvent.VK_A);
		menuItem.setAccelerator(KeyStroke.getKeyStroke(
				KeyEvent.VK_4, ActionEvent.ALT_MASK));
		menu.add(menuItem);
		
		menuItem.addActionListener(new ActionListener() {
			
			public void actionPerformed(ActionEvent paramActionEvent) {
				load();
			}
		});
		
		
		
		
		menuItem = new JMenuItem("Quitter",
                KeyEvent.VK_Q);
		menuItem.setAccelerator(KeyStroke.getKeyStroke(
				KeyEvent.VK_4, ActionEvent.ALT_MASK));
		menu.add(menuItem);
		menuItem.addActionListener(new ActionListener() {
			
			public void actionPerformed(ActionEvent paramActionEvent) {
				System.exit(0);
			}
		});
		
		 setJMenuBar(menuBar);

		
		//J'attribue la couleur aux cases
		int a = 1;
		for (int ligne = 0; ligne < 8; ligne++) {
			a = a == 1 ? 0 : 1;
			for (int colonne = 0; colonne < 8; colonne++) {
				tab[colonne][ligne] = new CaseLabel();
				panelGrille.add(tab[colonne][ligne]); // ajouter au Panel
				tab[colonne][ligne].setOpaque(true);
				tab[colonne][ligne].setHorizontalAlignment(SwingConstants.CENTER); //centre les pieces dans les cases
				tab[colonne][ligne].addMouseListener(gest); 
				if ((colonne + 1) % 2 == a)
					tab[colonne][ligne].setCouleur(CouleurCase.blanc); //couleur des cases : blanc
				else
					tab[colonne][ligne].setCouleur(CouleurCase.noire); //couleur des cases : noir
				
			}
		}		
	}
	
	// classe privee pour la gestion des evenement de la souris.
	 
	/**
	 * remetsles icones sur l'echiquier graphique conformément à leur place dans Echiquier
	 */
	protected void placeIcons() {
		for(int colonne=0;colonne<8;colonne++) {
			  for(int ligne=0;ligne<8;ligne++) {
				  Piece piece=e.getCase(colonne, ligne).getPiece();
				  if (piece==null) {
					  tab[colonne][ligne].setIcon(null);
				  }
				  else {
					  tab[colonne][ligne].setIcon(piece.getIcon(DOSSIER_ICONES));
				  }
			  }
			}
	}

	private class GestionnaireEvenement extends MouseAdapter {

		Piece pieceTampon = null;
		ImageIcon iconeTampon;
		int ligneClic;
		int colonneClic;
		Position temp = null;
	
		public void mouseClicked(MouseEvent eve) {
	

			if (eve.getSource() instanceof JLabel) // donc on a cliqué sur un Label
			{
				for (int i = 0; i < 8; i++)
					//on determine sur quel Jlabel on a clique
					for (int j = 0; j < 8; j++) 
						if (eve.getSource() == tab[j][i]) {
							ligneClic = i;
							colonneClic = j;
						}
					//si on a clique sur une case non vide et que le tampon n'est pas null
					if((e.getCase(colonneClic, ligneClic).getPiece() != null | pieceTampon != null) )
					{
						//si le tampon est null
						if(pieceTampon == null )
						{
							//si c'est au tour de la couleur de controle a jouer
							if(e.getCase(colonneClic, ligneClic).getPiece().getCouleur()==(couleurControle)){
								//J'initialise la piece tampon a la piece sur laquelle on a clique
								pieceTampon = e.getCase(colonneClic, ligneClic).getPiece();
								iconeTampon = (ImageIcon)tab[colonneClic][ligneClic].getIcon();
								temp = new Position(colonneClic,ligneClic);
								tab[colonneClic][ligneClic].setBorder(BorderFactory.createLineBorder(new Color(255,0 ,0),5));
								for (int ligne = 0; ligne < 8; ligne++) {
									  for (int colonne = 0; colonne < 8; colonne++) {
									    if ( colonne==temp.getColonne() && ligne==temp.getLigne() ) continue; // une pièce ne peut pas se déplacer sur elle même
									        Position pos = new Position(colonne,ligne);
									        Deplacement deplacement=new Deplacement(temp,pos);
									        
									        if (pieceTampon.estValide(deplacement) ) {
									          // si la pièce peut effectuer ce déplacement (en la considérant seule sur l'échiquier)
									        	if ( e.cheminPossible(deplacement) ) {
									            // si la pièce peut se déplacer vers la case d'arrivée, c'est à dire si le chemin est libre
									        		if ( e.getCase(colonne,ligne).estOccupe() ) {
									        			// si la case d'arrivée est occupée, alors c'est que c'est une pièce adverse prenable
									        			// pas beson de tester la couleur, puisque si la couleur est la couleur du joueur le déplacement n'est pas possible
									        		    tab[colonne][ligne].setCoupPossible(CoupPossible.prise);
									        		}
									        		else {
									          		// alors le déplacement est possible
									        		    tab[colonne][ligne].setCoupPossible(CoupPossible.mouvement);
									        		}
									        	}
									      } else if ( e.captureParUnPionPossible(deplacement) ) {
									      	tab[colonne][ligne].setCoupPossible(CoupPossible.prise);
									      }else if ( e.isRoquePossible(deplacement) ) {
																	        	tab[colonne][ligne].setCoupPossible(CoupPossible.roque);
																	        }
									    else {
									        tab[colonne][ligne].setCoupPossible(null);
									    }
									  } 

									}
								marqueRoiEchec();
						  }
							
						}
						else
						{
							//je cree un deplacement
							for (int ligne = 0; ligne < 8; ligne++) {
								   for (int colonne = 0; colonne < 8; colonne++) {
								      tab[colonne][ligne].setCoupPossible(null);
								   }
							}
							Deplacement deplacement = new Deplacement(temp, new Position(colonneClic,ligneClic));
							//je verifie si le deplacement est valide, si le chemin est possible et si il est possible, pour un pion de manger la piece
							if ((pieceTampon.estValide(deplacement) && e.cheminPossible(deplacement)) || e.captureParUnPionPossible(deplacement) ||e.prisePionEnPassant(deplacement,false))
							{
								Piece piecePrise = e.getCase(colonneClic, ligneClic).getPiece();
								Icon iconPiecePrise = tab[colonneClic][ligneClic].getIcon();
								if ( e.prisePionEnPassant(deplacement, false) ) {
										
								  piecePrise = e.getCase(deplacement.getArrivee().getColonne(),deplacement.getDepart().getLigne()).getPiece();
								  iconPiecePrise = tab[deplacement.getArrivee().getColonne()][deplacement.getDepart().getLigne()].getIcon();
								  tab[deplacement.getArrivee().getColonne()][deplacement.getDepart().getLigne()].setIcon(null); // pièce prise
									 
								}
								if ( iconPiecePrise!=null ) {
									//je cree un jLabel avec l'icone de la piece manger
									JLabel manger = new JLabel(iconPiecePrise);
									manger.setHorizontalAlignment(SwingConstants.CENTER);
									
									//je l'ajoute au bon jPanel
									if (couleurControle==Couleur.blanc)
										panelblanc.add(manger);
									else		
										panelnoir.add(manger);
								}
								Partie.nouveauCoup(couleurControle,pieceTampon,deplacement,piecePrise);
								
								// je verifie si la piece manger est un roi, si oui le jeu est termine et l'utilisateur peut choisir si il veut continuer a jouer ou non
								if(e.getCase(colonneClic, ligneClic).getPiece() instanceof Roi)
								{
									if(JOptionPane.showConfirmDialog(null, "Felicitation vous avez gagne ! Desirez-vous jouer de nouveau ?\n", "Victoire !!!", JOptionPane.YES_NO_OPTION) == 0){
										RAZ();
										tab[temp.getColonne()][temp.getLigne()].setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0),0)); // j'enleve le cadre rouge de la piece selectionne
									}

									else
										System.exit(0);

								}
								else//si on depose la piece sur une case vide
								{
									//on met le tampon sur la case vide et on vide le tampon apres
									e.getCase(temp.getColonne(), temp.getLigne()).setPiece(null);
									tab[temp.getColonne()][temp.getLigne()].setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0),0)); // j'enleve le cadre rouge de la piece selectionne
									tab[colonneClic][ligneClic].setIcon(iconeTampon);
									e.getCase(colonneClic, ligneClic).setPiece(pieceTampon); // pour pouvoir le rebouger plusieurs fois dans une partie
									tab[temp.getColonne()][temp.getLigne()].setIcon(null); // permet de faire bouger la piece selectionne en supprimant la piece bouger de sa position initiale 
									pieceTampon.enregistreDeplacement(true);
									if ( pieceTampon instanceof Pion ) {
										
									}
									if ( pieceTampon instanceof Roi ) {
										if ( Math.abs(deplacement.getDeplacementX())==2) {
											// faut que je déplace aussi la tour derrière le roi
											int xtourDepart, xtourArrivee;
											if( deplacement.getDeplacementX()<0 ) {
												// déplacement vers la gauche = grand roque = roque avec la tour gauche (vue des blancs)
												xtourDepart=0;
												xtourArrivee=3;
											}
											else {
												// déplacement vers la droite = petit roque = roque avec la tour droite (vue des blancs)
												xtourDepart=7;
												xtourArrivee=5;
											}
									                // on déplace la tour... donc la pièce et l'icone
											Piece tour = e.getCase(xtourDepart, ligneClic).getPiece();
											e.getCase(xtourArrivee, ligneClic).setPiece(tour);
											e.getCase(xtourDepart, ligneClic).setPiece(null);
											tour.enregistreDeplacement(true); // ce déplacement doit être compté
											tab[xtourArrivee][ligneClic].setIcon(tab[xtourDepart][ligneClic].getIcon());
											tab[xtourDepart][ligneClic].setIcon(null);
										}
									}

									pieceTampon = null;
									iconeTampon = null;
									temp = null;

									couleurControle = couleurControle.couleurAdverse();
									champTexte.setText(couleurControle.getTexte() + " , a vous de jouer");
                                    		
								}
							}
							else
							{
								tab[temp.getColonne()][temp.getLigne()].setBorder(BorderFactory.createLineBorder(new Color(255, 0, 0),0));
								pieceTampon = null;
								iconeTampon = null;
								temp = null;

							}
							marqueRoiEchec();
						}

					}
				
					
				}

		}
	}

	//Je remet tout les attributs de la classe a 0
	public void RAZ()
	{

		for (int ligne = 0; ligne < 8; ligne++) 
			for (int colonne = 0; colonne < 8; colonne++) {
				tab[colonne][ligne].setIcon(null);
				tab[colonne][ligne].setCoupPossible(null);
				tab[colonne][ligne].setBorder(null);
			}
		champTexte.setText("");
		e.vide();

		panelblanc.removeAll();
		panelblanc.repaint();
		panelnoir.removeAll();
		panelnoir.repaint();

	}

	
	
	
	public void marqueRoiEchec() {
		Couleur couleurAdverse=couleurControle.couleurAdverse();
		Position positionRoiJoue = e.getPosition(Roi.class, couleurControle);
		for(int colonne=0; colonne<8;colonne++) {
		    for(int ligne=0; ligne<8;ligne++) {
		        if (e.getCase(colonne,ligne).estOccupe(couleurAdverse)){
		        	Deplacement simuleDeplacementEchec=new Deplacement(new Position(colonne, ligne),positionRoiJoue);
		        		if ((e.getCase(colonne,ligne).getPiece().estValide(simuleDeplacementEchec) && e.cheminPossible(simuleDeplacementEchec)) || e.captureParUnPionPossible(simuleDeplacementEchec)){
		        			tab[positionRoiJoue.getColonne()][positionRoiJoue.getLigne()].setCoupPossible(CoupPossible.echec);
		        		}
		        }
		    }
		}
	}


	public void save() {
		JFileChooser filechooser = new JFileChooser();
		filechooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		filechooser.setFileFilter( new FileNameExtensionFilter(
		        "Partie de Jeu d'echec", "rcl", "rcl"));
 
		int returnVal = filechooser.showSaveDialog(this);
 
	    if (returnVal == JFileChooser.APPROVE_OPTION) {
 
                  File file=filechooser.getSelectedFile(); 
                  if ( !file.getName().endsWith(".rcl") ) {
                	  file=new File(file.getParentFile(),file.getName()+".rcl");
                  }
	    	  // là on a un fichier on va ecrire dedans
                try {
                	Partie.save(file);
                } catch (IOException e) {
                	JOptionPane.showMessageDialog(this, "Impossible de sauvegarder la partie", "Erreur", JOptionPane.ERROR_MESSAGE);
                }
 
	    } 
	}
	
	
	public void load() {
		JFileChooser filechooser = new JFileChooser();
		filechooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		filechooser.setFileFilter( new FileNameExtensionFilter(
		        "Partie de Jeu d'echec", "rcl", "rcl"));
 
		int returnVal = filechooser.showOpenDialog(this);
	    if (returnVal == JFileChooser.APPROVE_OPTION) {
 
	    	File file=filechooser.getSelectedFile(); 
	    	try {
  	    	PartieChargee partieChargee = Partie.load(file);
  	    	// on met à jour l'interface graphique a partir de partieChargée
 
  	    	Coup dernierCoupJoue=Partie.getDernierCoupJoue();
			if( dernierCoupJoue==null ) {
  	    	// on a sauvée une partie non jouée
  	    		couleurControle=Couleur.blanc;
          }
          else {
        	  couleurControle=dernierCoupJoue.getCouleur().couleurAdverse();
  	    	}
 
			RAZ(); // on remet à zéro
			// on met à jour l'echiquier virtuel et l'echiquier graphique
			for (int ligne = 0; ligne < 8; ligne++) {
				   for (int colonne = 0; colonne < 8; colonne++) {
					   Piece piece=partieChargee.echiquier.getCase(colonne,ligne).getPiece();
					   e.getCase(colonne, ligne).setPiece(piece);
				   }
			}
			placeIcons(); // on met à jouer l'echiquier graphique
			// pièce prise
			for( Piece piece:partieChargee.pieceprisesParLesBlancs) {
				JLabel manger = new JLabel(piece.getIcon(DOSSIER_ICONES));
				manger.setHorizontalAlignment(SwingConstants.CENTER);
				panelblanc.add(manger);
			}
			for( Piece piece:partieChargee.pieceprisesParLesNoirs) {
				JLabel manger = new JLabel(piece.getIcon(DOSSIER_ICONES));
				manger.setHorizontalAlignment(SwingConstants.CENTER);
				panelnoir.add(manger);
			}
			
		    champTexte.setText(couleurControle.getTexte() + " a vous de jouer");

		    // après le chargement le roi peut etre en situation d'echec
		    marqueRoiEchec();
			
        } catch (IOException e) {
        	e.printStackTrace();
        	JOptionPane.showMessageDialog(this, "Impossible de charger la partie", "Erreur", JOptionPane.ERROR_MESSAGE);
        	}

	    }
	}
	
	
	

	// main pour pouvoir exécuter l'interface graphique
	public static void main(String[] args) {
		FenetreJeu j = new FenetreJeu();
		j.setVisible(true);
		j.setLocationRelativeTo(null);
		j.setDefaultCloseOperation(EXIT_ON_CLOSE); // ferme le processus associé
	}

}