package projet;

import java.awt.Color;

import javax.swing.JLabel;

public class CaseLabel extends JLabel {
	private static final long serialVersionUID = 1L;
	private CouleurCase couleurCase; 
	private CoupPossible couppossible;	

	public enum CoupPossible {
	     mouvement(0, 240, 0),
	     prise(255, 129, 0),
	     roque(247, 255, 60),
	     echec(255, 0 , 0);
	     
	     private Color color;
	     private CoupPossible(int r,int g, int b) {
	    	 this(new Color(r,g,b));
		}
	     private CoupPossible(Color color) {
	    	 this.color=color;
		}
		public Color getCouleurCase() {
			return color;
		}
	}
	
	private void updateCouleur() {
		if ( couppossible!=null )
			setBackground(couppossible.getCouleurCase()); //couleur normale de la casee
		else 
			setBackground(couleurCase.getCouleurCase()); //couleur normale de la casee
	}
	public void setCoupPossible(CoupPossible couppossible) {
	    this.couppossible=couppossible;
	    updateCouleur();
	}
	
	public void setCouleur(CouleurCase couleur ) {
	    this.couleurCase=couleur;
	    updateCouleur();
	}
}