EventObserver={
	/**
	* Ajoute un vnement  un lment du DOM
	* @param DOMELement HTMLElement lment du DOM sur lequel l'venement sera ajout
	* @param evtName string Nom de l'lment auquel l'venement sera associ
	* @param fn function fonction  associer  l'venement
	*/
	addEvent:function(DOMElement,evtName,fn){
	///<summary>Ajoute un vnement  un lment du DOM</summary>
	///<param type="HTMLElement">DOMElement</param>
	///<param type="string">evtName</param>
	///<param type="fonction">fn</param>
	//On associe l'vnement
		if(DOMElement.attachEvent)
			DOMElement.attachEvent("on"+evtName,fn,false);
			
		else
			DOMElement.addEventListener(evtName,fn);
	
	//On stock l'vnement dans un tableau associer au HTMLElement passer en paramtre
	if(DOMElement.Events==undefined)
		DOMElement.Events=new Array();
	if(DOMElement.Events[evtName]==undefined)
		DOMElement.Events[evtName]=new Array();
	DOMElement.Events[evtName].push(fn);
		
	},
	detachEvent:function(DOMElement,evtName,fn){
		if(typeof fn =="integer")//si le troisime paramtre correspond  un entier
		{
			//recuperer la fonction  l'index passer en paramtre
			var handler=DOMElement.Events[evtName][fn];
		}else{
			var i=0;
			var t=false;
			while(i<DOMElement.Events[evtName].length&&!t)
			{
				if(DOMElement.Events[evtName][i]==fn){
					t=true;
				}else
					i++;
			}
			var handler=(t)?fn:null;
		}
		if(handler){
			if(DOMElement.removeEventListener)
				DOMElement.removeEventLister(evtName,handler);
		}
	}
	
}